/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public class Purge
extends Task {
    private static final String PROPERTIES_FILE = "task.properties";
    private Settings settings;
    private String dataDirectory = null;
    private boolean failOnError = true;
    private String hostedSuppressionsUrl = null;

    public Purge() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public String getHostedSuppressionsUrl() {
        return this.hostedSuppressionsUrl;
    }

    public void setHostedSuppressionsUrl(String hostedSuppressionsUrl) {
        this.hostedSuppressionsUrl = hostedSuppressionsUrl;
    }

    public final void execute() throws BuildException {
        this.muteJCS();
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.executeWithContextClassloader();
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    private void muteJCS() {
        String[] noisyLoggers;
        if (System.getProperty("jcs.logSystem") == null) {
            System.setProperty("jcs.logSystem", "slf4j");
        }
        for (String loggerName : noisyLoggers = new String[]{"org.apache.commons.jcs3.auxiliary.disk.AbstractDiskCache", "org.apache.commons.jcs3.engine.memory.AbstractMemoryCache", "org.apache.commons.jcs3.engine.control.CompositeCache", "org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskCache", "org.apache.commons.jcs3.engine.control.CompositeCache", "org.apache.commons.jcs3.engine.memory.AbstractMemoryCache", "org.apache.commons.jcs3.engine.control.event.ElementEventQueue", "org.apache.commons.jcs3.engine.memory.AbstractDoubleLinkedListMemoryCache", "org.apache.commons.jcs3.auxiliary.AuxiliaryCacheConfigurator", "org.apache.commons.jcs3.engine.control.CompositeCacheManager", "org.apache.commons.jcs3.utils.threadpool.ThreadPoolManager", "org.apache.commons.jcs3.engine.control.CompositeCacheConfigurator"}) {
            try {
                Logger l = LoggerFactory.getLogger((String)loggerName);
                Field f = l.getClass().getSuperclass().getDeclaredField("currentLogLevel");
                f.setAccessible(true);
                f.set(l, 40);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                LoggerFactory.getLogger(Purge.class).debug("Failed to reset the log level of " + loggerName + ", it will continue being noisy.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeWithContextClassloader() throws BuildException {
        this.populateSettings();
        try (Engine engine = new Engine(Engine.Mode.EVIDENCE_PROCESSING, this.getSettings());){
            engine.purge();
        }
        finally {
            this.settings.cleanup(true);
        }
    }

    protected void populateSettings() throws BuildException {
        this.settings = new Settings();
        try (InputStream taskProperties = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);){
            this.settings.mergeProperties(taskProperties);
        }
        catch (IOException ex) {
            String msg = "Unable to load the dependency-check ant task.properties file.";
            if (this.failOnError) {
                throw new BuildException("Unable to load the dependency-check ant task.properties file.", (Throwable)ex);
            }
            this.log("Unable to load the dependency-check ant task.properties file.", ex, 1);
        }
        this.settings.setStringIfNotEmpty("hosted.suppressions.url", this.hostedSuppressionsUrl);
        if (this.dataDirectory != null) {
            this.settings.setString("data.directory", this.dataDirectory);
        } else {
            File jarPath = new File(Purge.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            File base = jarPath.getParentFile();
            String sub = this.settings.getString("data.directory");
            File dataDir = new File(base, sub);
            this.settings.setString("data.directory", dataDir.getAbsolutePath());
        }
    }
}

