/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import org.apache.tools.ant.BuildException;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.taskdefs.Purge;
import org.slf4j.impl.StaticLoggerBinder;

public class Update
extends Purge {
    private String proxyServer;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String connectionTimeout;
    private String databaseDriverName;
    private String databaseDriverPath;
    private String connectionString;
    private String databaseUser;
    private String databasePassword;
    private String cveUrlModified;
    private String cveUrlBase;
    private Integer cveValidForHours;

    public Update() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(String server) {
        this.proxyServer = server;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getDatabaseDriverName() {
        return this.databaseDriverName;
    }

    public void setDatabaseDriverName(String databaseDriverName) {
        this.databaseDriverName = databaseDriverName;
    }

    public String getDatabaseDriverPath() {
        return this.databaseDriverPath;
    }

    public void setDatabaseDriverPath(String databaseDriverPath) {
        this.databaseDriverPath = databaseDriverPath;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public void setCveUrlModified(String cveUrlModified) {
        this.cveUrlModified = cveUrlModified;
    }

    public String getCveUrlModified() {
        return this.cveUrlModified;
    }

    public String getCveUrlBase() {
        return this.cveUrlBase;
    }

    public void setCveUrlBase(String cveUrlBase) {
        this.cveUrlBase = cveUrlBase;
    }

    public Integer getCveValidForHours() {
        return this.cveValidForHours;
    }

    public void setCveValidForHours(Integer cveValidForHours) {
        this.cveValidForHours = cveValidForHours;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        this.populateSettings();
        try (Engine engine = new Engine(Update.class.getClassLoader(), this.getSettings());){
            try {
                engine.doUpdates();
            }
            catch (UpdateException ex) {
                if (this.isFailOnError()) {
                    throw new BuildException((Throwable)ex);
                }
                this.log(ex.getMessage(), 0);
            }
        }
        catch (DatabaseException ex) {
            String msg = "Unable to connect to the dependency-check database; unable to update the NVD data";
            if (this.isFailOnError()) {
                throw new BuildException("Unable to connect to the dependency-check database; unable to update the NVD data", (Throwable)ex);
            }
            this.log("Unable to connect to the dependency-check database; unable to update the NVD data", 0);
        }
        finally {
            this.getSettings().cleanup();
        }
    }

    @Override
    protected void populateSettings() throws BuildException {
        super.populateSettings();
        this.getSettings().setStringIfNotEmpty("proxy.server", this.proxyServer);
        this.getSettings().setStringIfNotEmpty("proxy.port", this.proxyPort);
        this.getSettings().setStringIfNotEmpty("proxy.username", this.proxyUsername);
        this.getSettings().setStringIfNotEmpty("proxy.password", this.proxyPassword);
        this.getSettings().setStringIfNotEmpty("connection.timeout", this.connectionTimeout);
        this.getSettings().setStringIfNotEmpty("data.driver_name", this.databaseDriverName);
        this.getSettings().setStringIfNotEmpty("data.driver_path", this.databaseDriverPath);
        this.getSettings().setStringIfNotEmpty("data.connection_string", this.connectionString);
        this.getSettings().setStringIfNotEmpty("data.user", this.databaseUser);
        this.getSettings().setStringIfNotEmpty("data.password", this.databasePassword);
        this.getSettings().setStringIfNotEmpty("cve.url.modified", this.cveUrlModified);
        this.getSettings().setStringIfNotEmpty("cve.url.base", this.cveUrlBase);
        if (this.cveValidForHours != null) {
            if (this.cveValidForHours >= 0) {
                this.getSettings().setInt("cve.check.validforhours", this.cveValidForHours.intValue());
            } else {
                throw new BuildException("Invalid setting: `cpeValidForHours` must be 0 or greater");
            }
        }
    }
}

