/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import org.apache.tools.ant.BuildException;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.taskdefs.Purge;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.slf4j.impl.StaticLoggerBinder;

public class Update
extends Purge {
    private String retireJsUrl;
    private String retireJsUrlUser;
    private String retireJsUrlPassword;
    private String retireJsUrlBearerToken;
    private Boolean retireJsForceUpdate;
    private Boolean knownExploitedEnabled;
    private String knownExploitedUrl;
    private Integer knownExploitedValidForHours;
    private String knownExploitedUser;
    private String knownExploitedPassword;
    private String knownExploitedBearerToken;
    private String nvdApiEndpoint;
    private String nvdApiKey;
    private Integer nvdMaxRetryCount;
    private Integer nvdValidForHours;
    private String nvdDatafeedUrl;
    private String nvdUser;
    private String nvdPassword;
    private String nvdBearerToken;
    private Integer nvdApiDelay;
    private Integer nvdApiResultsPerPage;
    private String proxyServer;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String nonProxyHosts;
    private String connectionTimeout;
    private String readTimeout;
    private String databaseDriverName;
    private String databaseDriverPath;
    private String connectionString;
    private String databaseUser;
    private String databasePassword;
    private Integer hostedSuppressionsValidForHours;
    private String hostedSuppressionsUser;
    private String hostedSuppressionsPassword;
    private String hostedSuppressionsBearerToken;
    private Boolean hostedSuppressionsForceUpdate;
    private Boolean hostedSuppressionsEnabled;
    private String hostedSuppressionsUrl = null;
    private Boolean retireJsAnalyzerEnabled;

    public Update() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public void setNvdApiEndpoint(String nvdApiEndpoint) {
        this.nvdApiEndpoint = nvdApiEndpoint;
    }

    public void setNvdApiKey(String nvdApiKey) {
        this.nvdApiKey = nvdApiKey;
    }

    public void setNvdMaxRetryCount(Integer nvdMaxRetryCount) {
        if (nvdMaxRetryCount <= 0) {
            throw new BuildException("Invalid setting: `nvdMaxRetryCount` must be greater than zero");
        }
        this.nvdMaxRetryCount = nvdMaxRetryCount;
    }

    public void setNvdValidForHours(int nvdValidForHours) {
        if (nvdValidForHours < 0) {
            throw new BuildException("Invalid setting: `nvdValidForHours` must be 0 or greater");
        }
        this.nvdValidForHours = nvdValidForHours;
    }

    public void setNvdDatafeedUrl(String nvdDatafeedUrl) {
        this.nvdDatafeedUrl = nvdDatafeedUrl;
    }

    public void setNvdUser(String nvdUser) {
        this.nvdUser = nvdUser;
    }

    public void setNvdPassword(String nvdPassword) {
        this.nvdPassword = nvdPassword;
    }

    public void setNvdBearerToken(String nvdBearerToken) {
        this.nvdBearerToken = nvdBearerToken;
    }

    public void setNvdApiDelay(Integer nvdApiDelay) {
        this.nvdApiDelay = nvdApiDelay;
    }

    public void setNvdApiResultsPerPage(Integer nvdApiResultsPerPage) {
        this.nvdApiResultsPerPage = nvdApiResultsPerPage;
    }

    public void setProxyServer(String server) {
        this.proxyServer = server;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(String readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setDatabaseDriverName(String databaseDriverName) {
        this.databaseDriverName = databaseDriverName;
    }

    public void setDatabaseDriverPath(String databaseDriverPath) {
        this.databaseDriverPath = databaseDriverPath;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public void setHostedSuppressionsValidForHours(Integer hostedSuppressionsValidForHours) {
        this.hostedSuppressionsValidForHours = hostedSuppressionsValidForHours;
    }

    public void setHostedSuppressionsUser(String hostedSuppressionsUser) {
        this.hostedSuppressionsUser = hostedSuppressionsUser;
    }

    public void setHostedSuppressionsPassword(String hostedSuppressionsPassword) {
        this.hostedSuppressionsPassword = hostedSuppressionsPassword;
    }

    public void setHostedSuppressionsBearerToken(String hostedSuppressionsBearerToken) {
        this.hostedSuppressionsBearerToken = hostedSuppressionsBearerToken;
    }

    public void setHostedSuppressionsForceUpdate(Boolean hostedSuppressionsForceUpdate) {
        this.hostedSuppressionsForceUpdate = hostedSuppressionsForceUpdate;
    }

    public void setHostedSuppressionsEnabled(Boolean hostedSuppressionsEnabled) {
        this.hostedSuppressionsEnabled = hostedSuppressionsEnabled;
    }

    public void setHostedSuppressionsUrl(String hostedSuppressionsUrl) {
        this.hostedSuppressionsUrl = hostedSuppressionsUrl;
    }

    public void setKnownExploitedUrl(String knownExploitedUrl) {
        this.knownExploitedUrl = knownExploitedUrl;
    }

    public void setKnownExploitedValidForHours(Integer knownExploitedValidForHours) {
        this.knownExploitedValidForHours = knownExploitedValidForHours;
    }

    public void setKnownExploitedUser(String knownExploitedUser) {
        this.knownExploitedUser = knownExploitedUser;
    }

    public void setKnownExploitedPassword(String knownExploitedPassword) {
        this.knownExploitedPassword = knownExploitedPassword;
    }

    public void setKnownExploitedBearerToken(String knownExploitedBearerToken) {
        this.knownExploitedBearerToken = knownExploitedBearerToken;
    }

    public void setKnownExploitedEnabled(Boolean knownExploitedEnabled) {
        this.knownExploitedEnabled = knownExploitedEnabled;
    }

    public void setRetireJsUrl(String retireJsUrl) {
        this.retireJsUrl = retireJsUrl;
    }

    public void setRetireJsUrlUser(String retireJsUrlUser) {
        this.retireJsUrlUser = retireJsUrlUser;
    }

    public void setRetireJsUrlPassword(String retireJsUrlPassword) {
        this.retireJsUrlPassword = retireJsUrlPassword;
    }

    public void setRetireJsUrlBearerToken(String retireJsUrlBearerToken) {
        this.retireJsUrlBearerToken = retireJsUrlBearerToken;
    }

    public void setRetireJsForceUpdate(Boolean retireJsForceUpdate) {
        this.retireJsForceUpdate = retireJsForceUpdate;
    }

    public void setRetireJsAnalyzerEnabled(Boolean retireJsAnalyzerEnabled) {
        this.retireJsAnalyzerEnabled = retireJsAnalyzerEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeWithContextClassloader() throws BuildException {
        this.populateSettings();
        try {
            Downloader.getInstance().configure(this.getSettings());
        }
        catch (InvalidSettingException e) {
            throw new BuildException((Throwable)e);
        }
        try (Engine engine = new Engine(Update.class.getClassLoader(), this.getSettings());){
            engine.doUpdates();
        }
        catch (UpdateException ex) {
            if (this.isFailOnError()) {
                throw new BuildException((Throwable)ex);
            }
            this.log(ex.getMessage(), 0);
        }
        catch (DatabaseException ex) {
            String msg = "Unable to connect to the dependency-check database; unable to update the NVD data";
            if (this.isFailOnError()) {
                throw new BuildException("Unable to connect to the dependency-check database; unable to update the NVD data", (Throwable)ex);
            }
            this.log("Unable to connect to the dependency-check database; unable to update the NVD data", 0);
        }
        finally {
            this.getSettings().cleanup();
        }
    }

    @Override
    protected void populateSettings() throws BuildException {
        super.populateSettings();
        this.getSettings().setStringIfNotEmpty("proxy.server", this.proxyServer);
        this.getSettings().setStringIfNotEmpty("proxy.port", this.proxyPort);
        this.getSettings().setStringIfNotEmpty("proxy.username", this.proxyUsername);
        this.getSettings().setStringIfNotEmpty("proxy.password", this.proxyPassword);
        this.getSettings().setStringIfNotEmpty("proxy.nonproxyhosts", this.nonProxyHosts);
        this.getSettings().setStringIfNotEmpty("connection.timeout", this.connectionTimeout);
        this.getSettings().setStringIfNotEmpty("connection.read.timeout", this.readTimeout);
        this.getSettings().setStringIfNotEmpty("data.driver_name", this.databaseDriverName);
        this.getSettings().setStringIfNotEmpty("data.driver_path", this.databaseDriverPath);
        this.getSettings().setStringIfNotEmpty("data.connection_string", this.connectionString);
        this.getSettings().setStringIfNotEmpty("data.user", this.databaseUser);
        this.getSettings().setStringIfNotEmpty("data.password", this.databasePassword);
        this.getSettings().setStringIfNotEmpty("kev.url", this.knownExploitedUrl);
        this.getSettings().setStringIfNotEmpty("kev.user", this.knownExploitedUser);
        this.getSettings().setStringIfNotEmpty("kev.password", this.knownExploitedPassword);
        this.getSettings().setStringIfNotEmpty("kev.bearertoken", this.knownExploitedBearerToken);
        this.getSettings().setIntIfNotNull("kev.check.validforhours", this.knownExploitedValidForHours);
        this.getSettings().setBooleanIfNotNull("analyzer.knownexploited.enabled", this.knownExploitedEnabled);
        this.getSettings().setStringIfNotNull("analyzer.retirejs.repo.js.url", this.retireJsUrl);
        this.getSettings().setStringIfNotNull("analyzer.retirejs.repo.js.username", this.retireJsUrlUser);
        this.getSettings().setStringIfNotNull("analyzer.retirejs.repo.js.password", this.retireJsUrlPassword);
        this.getSettings().setStringIfNotNull("analyzer.retirejs.repo.js.bearertoken", this.retireJsUrlBearerToken);
        this.getSettings().setBooleanIfNotNull("analyzer.retirejs.forceupdate", this.retireJsForceUpdate);
        this.getSettings().setBooleanIfNotNull("analyzer.retirejs.enabled", this.retireJsAnalyzerEnabled);
        this.getSettings().setStringIfNotEmpty("hosted.suppressions.url", this.hostedSuppressionsUrl);
        this.getSettings().setIntIfNotNull("hosted.suppressions.validforhours", this.hostedSuppressionsValidForHours);
        this.getSettings().setStringIfNotNull("hosted.suppressions.user", this.hostedSuppressionsUser);
        this.getSettings().setStringIfNotNull("hosted.suppressions.password", this.hostedSuppressionsPassword);
        this.getSettings().setStringIfNotNull("hosted.suppressions.bearertoken", this.hostedSuppressionsBearerToken);
        this.getSettings().setBooleanIfNotNull("hosted.suppressions.forceupdate", this.hostedSuppressionsForceUpdate);
        this.getSettings().setBooleanIfNotNull("hosted.suppressions.enabled", this.hostedSuppressionsEnabled);
        this.getSettings().setStringIfNotEmpty("nvd.api.key", this.nvdApiKey);
        this.getSettings().setStringIfNotEmpty("nvd.api.endpoint", this.nvdApiEndpoint);
        this.getSettings().setIntIfNotNull("nvd.api.delay", this.nvdApiDelay);
        this.getSettings().setIntIfNotNull("nvd.api.results.per.page", this.nvdApiResultsPerPage);
        this.getSettings().setStringIfNotEmpty("nvd.api.datafeed.url", this.nvdDatafeedUrl);
        this.getSettings().setStringIfNotEmpty("nvd.api.datafeed.user", this.nvdUser);
        this.getSettings().setStringIfNotEmpty("nvd.api.datafeed.password", this.nvdPassword);
        this.getSettings().setStringIfNotEmpty("nvd.api.datafeed.bearertoken", this.nvdBearerToken);
        this.getSettings().setIntIfNotNull("nvd.api.max.retry.count", this.nvdMaxRetryCount);
        this.getSettings().setIntIfNotNull("nvd.api.check.validforhours", this.nvdValidForHours);
    }
}

