/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import org.apache.tools.ant.BuildException;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.taskdefs.Purge;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.slf4j.impl.StaticLoggerBinder;

public class Update
extends Purge {
    private String nvdApiEndpoint;
    private String nvdApiKey;
    private Integer nvdMaxRetryCount;
    private Integer nvdValidForHours;
    private String nvdDatafeedUrl;
    private String nvdUser;
    private String nvdPassword;
    private int nvdApiDelay = 0;
    private Integer nvdApiResultsPerPage;
    private String proxyServer;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String nonProxyHosts;
    private String connectionTimeout;
    private String readTimeout;
    private String databaseDriverName;
    private String databaseDriverPath;
    private String connectionString;
    private String databaseUser;
    private String databasePassword;
    private Integer hostedSuppressionsValidForHours;
    private Boolean hostedSuppressionsForceUpdate;
    private Boolean hostedSuppressionsEnabled;

    public Update() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public String getNvdApiEndpoint() {
        return this.nvdApiEndpoint;
    }

    public void setNvdApiEndpoint(String nvdApiEndpoint) {
        this.nvdApiEndpoint = nvdApiEndpoint;
    }

    public String getNvdApiKey() {
        return this.nvdApiKey;
    }

    public void setNvdApiKey(String nvdApiKey) {
        this.nvdApiKey = nvdApiKey;
    }

    public int getNvdMaxRetryCounts() {
        return this.nvdMaxRetryCount;
    }

    public void setNvdMaxRetryCount(int nvdMaxRetryCount) {
        this.nvdMaxRetryCount = nvdMaxRetryCount;
    }

    public int getNvdValidForHours() {
        return this.nvdValidForHours;
    }

    public void setNvdValidForHours(int nvdValidForHours) {
        this.nvdValidForHours = nvdValidForHours;
    }

    public String getNvdDatafeedUrl() {
        return this.nvdDatafeedUrl;
    }

    public void setNvdDatafeedUrl(String nvdDatafeedUrl) {
        this.nvdDatafeedUrl = nvdDatafeedUrl;
    }

    public String getNvdUser() {
        return this.nvdUser;
    }

    public void setNvdUser(String nvdUser) {
        this.nvdUser = nvdUser;
    }

    public String getNvdPassword() {
        return this.nvdPassword;
    }

    public void setNvdPassword(String nvdPassword) {
        this.nvdPassword = nvdPassword;
    }

    public int getNvdApiDelay() {
        return this.nvdApiDelay;
    }

    public void setNvdApiDelay(int nvdApiDelay) {
        this.nvdApiDelay = nvdApiDelay;
    }

    public int getNvdApiResultsPerPage() {
        return this.nvdApiResultsPerPage;
    }

    public void setApiResultsPerPage(int nvdApiResultsPerPage) {
        this.nvdApiResultsPerPage = nvdApiResultsPerPage;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(String server) {
        this.proxyServer = server;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(String readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getDatabaseDriverName() {
        return this.databaseDriverName;
    }

    public void setDatabaseDriverName(String databaseDriverName) {
        this.databaseDriverName = databaseDriverName;
    }

    public String getDatabaseDriverPath() {
        return this.databaseDriverPath;
    }

    public void setDatabaseDriverPath(String databaseDriverPath) {
        this.databaseDriverPath = databaseDriverPath;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public Integer getHostedSuppressionsValidForHours() {
        return this.hostedSuppressionsValidForHours;
    }

    public void setHostedSuppressionsValidForHours(Integer hostedSuppressionsValidForHours) {
        this.hostedSuppressionsValidForHours = hostedSuppressionsValidForHours;
    }

    public Boolean isHostedSuppressionsForceUpdate() {
        return this.hostedSuppressionsForceUpdate;
    }

    public void setHostedSuppressionsForceUpdate(Boolean hostedSuppressionsForceUpdate) {
        this.hostedSuppressionsForceUpdate = hostedSuppressionsForceUpdate;
    }

    public Boolean isHostedSuppressionsEnabled() {
        return this.hostedSuppressionsEnabled;
    }

    public void setHostedSuppressionsEnabled(Boolean hostedSuppressionsEnabled) {
        this.hostedSuppressionsEnabled = hostedSuppressionsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeWithContextClassloader() throws BuildException {
        this.populateSettings();
        try {
            Downloader.getInstance().configure(this.getSettings());
        }
        catch (InvalidSettingException e) {
            throw new BuildException((Throwable)e);
        }
        try (Engine engine = new Engine(Update.class.getClassLoader(), this.getSettings());){
            engine.doUpdates();
        }
        catch (UpdateException ex) {
            if (this.isFailOnError()) {
                throw new BuildException((Throwable)ex);
            }
            this.log(ex.getMessage(), 0);
        }
        catch (DatabaseException ex) {
            String msg = "Unable to connect to the dependency-check database; unable to update the NVD data";
            if (this.isFailOnError()) {
                throw new BuildException("Unable to connect to the dependency-check database; unable to update the NVD data", (Throwable)ex);
            }
            this.log("Unable to connect to the dependency-check database; unable to update the NVD data", 0);
        }
        finally {
            this.getSettings().cleanup();
        }
    }

    @Override
    protected void populateSettings() throws BuildException {
        super.populateSettings();
        this.getSettings().setStringIfNotEmpty("proxy.server", this.proxyServer);
        this.getSettings().setStringIfNotEmpty("proxy.port", this.proxyPort);
        this.getSettings().setStringIfNotEmpty("proxy.username", this.proxyUsername);
        this.getSettings().setStringIfNotEmpty("proxy.password", this.proxyPassword);
        this.getSettings().setStringIfNotEmpty("proxy.nonproxyhosts", this.nonProxyHosts);
        this.getSettings().setStringIfNotEmpty("connection.timeout", this.connectionTimeout);
        this.getSettings().setStringIfNotEmpty("connection.read.timeout", this.readTimeout);
        this.getSettings().setStringIfNotEmpty("data.driver_name", this.databaseDriverName);
        this.getSettings().setStringIfNotEmpty("data.driver_path", this.databaseDriverPath);
        this.getSettings().setStringIfNotEmpty("data.connection_string", this.connectionString);
        this.getSettings().setStringIfNotEmpty("data.user", this.databaseUser);
        this.getSettings().setStringIfNotEmpty("data.password", this.databasePassword);
        this.getSettings().setIntIfNotNull("hosted.suppressions.validforhours", this.hostedSuppressionsValidForHours);
        this.getSettings().setBooleanIfNotNull("hosted.suppressions.forceupdate", this.hostedSuppressionsForceUpdate);
        this.getSettings().setBooleanIfNotNull("hosted.suppressions.enabled", this.hostedSuppressionsEnabled);
        this.getSettings().setStringIfNotEmpty("nvd.api.key", this.nvdApiKey);
        this.getSettings().setStringIfNotEmpty("nvd.api.endpoint", this.nvdApiEndpoint);
        this.getSettings().setIntIfNotNull("nvd.api.delay", Integer.valueOf(this.nvdApiDelay));
        this.getSettings().setIntIfNotNull("nvd.api.results.per.page", this.nvdApiResultsPerPage);
        this.getSettings().setStringIfNotEmpty("nvd.api.datafeed.url", this.nvdDatafeedUrl);
        this.getSettings().setStringIfNotEmpty("nvd.api.datafeed.user", this.nvdUser);
        this.getSettings().setStringIfNotEmpty("nvd.api.datafeed.password", this.nvdPassword);
        if (this.nvdMaxRetryCount != null) {
            if (this.nvdMaxRetryCount > 0) {
                this.getSettings().setInt("nvd.api.max.retry.count", this.nvdMaxRetryCount.intValue());
            } else {
                throw new BuildException("Invalid setting: `nvdMaxRetryCount` must be greater than zero");
            }
        }
        if (this.nvdValidForHours != null) {
            if (this.nvdValidForHours >= 0) {
                this.getSettings().setInt("nvd.api.check.validforhours", this.nvdValidForHours.intValue());
            } else {
                throw new BuildException("Invalid setting: `nvdValidForHours` must be 0 or greater");
            }
        }
    }
}

