/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.Resources;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.taskdefs.Update;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.impl.StaticLoggerBinder;

public class Check
extends Update {
    private static final String NEW_LINE = System.getProperty("line.separator", "\n").intern();
    private Resources path = null;
    private Reference refid = null;
    @Deprecated
    private String applicationName = null;
    private String projectName = "dependency-check";
    private String reportOutputDirectory = ".";
    private float failBuildOnCVSS = 11.0f;
    private Boolean autoUpdate;
    @Deprecated
    private boolean updateOnly = false;
    private String reportFormat = "HTML";
    private String suppressionFile;
    private boolean showSummary = true;
    private Boolean jarAnalyzerEnabled;
    private Boolean archiveAnalyzerEnabled;
    private Boolean assemblyAnalyzerEnabled;
    private Boolean nuspecAnalyzerEnabled;
    private Boolean composerAnalyzerEnabled;
    private Boolean autoconfAnalyzerEnabled;
    private Boolean cmakeAnalyzerEnabled;
    private Boolean opensslAnalyzerEnabled;
    private Boolean nodeAnalyzerEnabled;
    private Boolean rubygemsAnalyzerEnabled;
    private Boolean pyPackageAnalyzerEnabled;
    private Boolean pyDistributionAnalyzerEnabled;
    private Boolean centralAnalyzerEnabled;
    private Boolean nexusAnalyzerEnabled;
    private String nexusUrl;
    private Boolean nexusUsesProxy;
    private String zipExtensions;
    private String pathToMono;

    public Check() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public void add(ResourceCollection rc) {
        if (this.isReference()) {
            throw new BuildException("Nested elements are not allowed when using the refid attribute.");
        }
        this.getPath().add(rc);
    }

    private synchronized Resources getPath() {
        if (this.path == null) {
            this.path = new Resources(this.getProject());
            this.path.setCache(true);
        }
        return this.path;
    }

    public boolean isReference() {
        return this.refid != null;
    }

    public void setRefid(Reference r) {
        if (this.path != null) {
            throw new BuildException("Nested elements are not allowed when using the refid attribute.");
        }
        this.refid = r;
    }

    private void dealWithReferences() throws BuildException {
        if (this.isReference()) {
            Object o = this.refid.getReferencedObject(this.getProject());
            if (!(o instanceof ResourceCollection)) {
                throw new BuildException("refid '" + this.refid.getRefId() + "' does not refer to a resource collection.");
            }
            this.getPath().add((ResourceCollection)o);
        }
    }

    @Deprecated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Deprecated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getProjectName() {
        if (this.applicationName != null) {
            this.log("Configuration 'applicationName' has been deprecated, please use 'projectName' instead", 1);
            if ("dependency-check".equals(this.projectName)) {
                this.projectName = this.applicationName;
            }
        }
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(String reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
    }

    public float getFailBuildOnCVSS() {
        return this.failBuildOnCVSS;
    }

    public void setFailBuildOnCVSS(float failBuildOnCVSS) {
        this.failBuildOnCVSS = failBuildOnCVSS;
    }

    public Boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(Boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    @Deprecated
    public boolean isUpdateOnly() {
        return this.updateOnly;
    }

    @Deprecated
    public void setUpdateOnly(boolean updateOnly) {
        this.updateOnly = updateOnly;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(ReportFormats reportFormat) {
        this.reportFormat = reportFormat.getValue();
    }

    public String getSuppressionFile() {
        return this.suppressionFile;
    }

    public void setSuppressionFile(String suppressionFile) {
        this.suppressionFile = suppressionFile;
    }

    public boolean isShowSummary() {
        return this.showSummary;
    }

    public void setShowSummary(boolean showSummary) {
        this.showSummary = showSummary;
    }

    public Boolean isJarAnalyzerEnabled() {
        return this.jarAnalyzerEnabled;
    }

    public void setJarAnalyzerEnabled(Boolean jarAnalyzerEnabled) {
        this.jarAnalyzerEnabled = jarAnalyzerEnabled;
    }

    public Boolean isArchiveAnalyzerEnabled() {
        return this.archiveAnalyzerEnabled;
    }

    public void setArchiveAnalyzerEnabled(Boolean archiveAnalyzerEnabled) {
        this.archiveAnalyzerEnabled = archiveAnalyzerEnabled;
    }

    public Boolean isAssemblyAnalyzerEnabled() {
        return this.assemblyAnalyzerEnabled;
    }

    public void setAssemblyAnalyzerEnabled(Boolean assemblyAnalyzerEnabled) {
        this.assemblyAnalyzerEnabled = assemblyAnalyzerEnabled;
    }

    public Boolean isNuspecAnalyzerEnabled() {
        return this.nuspecAnalyzerEnabled;
    }

    public void setNuspecAnalyzerEnabled(Boolean nuspecAnalyzerEnabled) {
        this.nuspecAnalyzerEnabled = nuspecAnalyzerEnabled;
    }

    public Boolean isComposerAnalyzerEnabled() {
        return this.composerAnalyzerEnabled;
    }

    public void setComposerAnalyzerEnabled(Boolean composerAnalyzerEnabled) {
        this.composerAnalyzerEnabled = composerAnalyzerEnabled;
    }

    public Boolean isAutoconfAnalyzerEnabled() {
        return this.autoconfAnalyzerEnabled;
    }

    public void setAutoconfAnalyzerEnabled(Boolean autoconfAnalyzerEnabled) {
        this.autoconfAnalyzerEnabled = autoconfAnalyzerEnabled;
    }

    public Boolean isCMakeAnalyzerEnabled() {
        return this.cmakeAnalyzerEnabled;
    }

    public void setCMakeAnalyzerEnabled(Boolean cmakeAnalyzerEnabled) {
        this.cmakeAnalyzerEnabled = cmakeAnalyzerEnabled;
    }

    public Boolean isOpensslAnalyzerEnabled() {
        return this.opensslAnalyzerEnabled;
    }

    public void setOpensslAnalyzerEnabled(Boolean opensslAnalyzerEnabled) {
        this.opensslAnalyzerEnabled = opensslAnalyzerEnabled;
    }

    public Boolean isNodeAnalyzerEnabled() {
        return this.nodeAnalyzerEnabled;
    }

    public void setNodeAnalyzerEnabled(Boolean nodeAnalyzerEnabled) {
        this.nodeAnalyzerEnabled = nodeAnalyzerEnabled;
    }

    public Boolean isRubygemsAnalyzerEnabled() {
        return this.rubygemsAnalyzerEnabled;
    }

    public void setRubygemsAnalyzerEnabled(Boolean rubygemsAnalyzerEnabled) {
        this.rubygemsAnalyzerEnabled = rubygemsAnalyzerEnabled;
    }

    public Boolean isPyPackageAnalyzerEnabled() {
        return this.pyPackageAnalyzerEnabled;
    }

    public void setPyPackageAnalyzerEnabled(Boolean pyPackageAnalyzerEnabled) {
        this.pyPackageAnalyzerEnabled = pyPackageAnalyzerEnabled;
    }

    public Boolean isPyDistributionAnalyzerEnabled() {
        return this.pyDistributionAnalyzerEnabled;
    }

    public void setPyDistributionAnalyzerEnabled(Boolean pyDistributionAnalyzerEnabled) {
        this.pyDistributionAnalyzerEnabled = pyDistributionAnalyzerEnabled;
    }

    public Boolean isCentralAnalyzerEnabled() {
        return this.centralAnalyzerEnabled;
    }

    public void setCentralAnalyzerEnabled(Boolean centralAnalyzerEnabled) {
        this.centralAnalyzerEnabled = centralAnalyzerEnabled;
    }

    public Boolean isNexusAnalyzerEnabled() {
        return this.nexusAnalyzerEnabled;
    }

    public void setNexusAnalyzerEnabled(Boolean nexusAnalyzerEnabled) {
        this.nexusAnalyzerEnabled = nexusAnalyzerEnabled;
    }

    public String getNexusUrl() {
        return this.nexusUrl;
    }

    public void setNexusUrl(String nexusUrl) {
        this.nexusUrl = nexusUrl;
    }

    public Boolean isNexusUsesProxy() {
        return this.nexusUsesProxy;
    }

    public void setNexusUsesProxy(Boolean nexusUsesProxy) {
        this.nexusUsesProxy = nexusUsesProxy;
    }

    public String getZipExtensions() {
        return this.zipExtensions;
    }

    public void setZipExtensions(String zipExtensions) {
        this.zipExtensions = zipExtensions;
    }

    public String getPathToMono() {
        return this.pathToMono;
    }

    public void setPathToMono(String pathToMono) {
        this.pathToMono = pathToMono;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        block19: {
            this.dealWithReferences();
            this.validateConfiguration();
            this.populateSettings();
            Engine engine = null;
            try {
                engine = new Engine(Check.class.getClassLoader());
                if (this.isUpdateOnly()) {
                    this.log("Deprecated 'UpdateOnly' property set; please use the UpdateTask instead", 1);
                    engine.doUpdates();
                    break block19;
                }
                try {
                    for (Resource resource : this.path) {
                        File file;
                        FileProvider provider = (FileProvider)resource.as(FileProvider.class);
                        if (provider == null || (file = provider.getFile()) == null || !file.exists()) continue;
                        engine.scan(file);
                    }
                    engine.analyzeDependencies();
                    DatabaseProperties prop = null;
                    CveDB cve = null;
                    try {
                        cve = new CveDB();
                        cve.open();
                        prop = cve.getDatabaseProperties();
                    }
                    catch (DatabaseException ex) {
                        this.log("Unable to retrieve DB Properties", ex, 4);
                    }
                    finally {
                        if (cve != null) {
                            cve.close();
                        }
                    }
                    ReportGenerator reporter = new ReportGenerator(this.getProjectName(), engine.getDependencies(), engine.getAnalyzers(), prop);
                    reporter.generateReports(this.reportOutputDirectory, this.reportFormat);
                    if (this.failBuildOnCVSS <= 10.0f) {
                        this.checkForFailure(engine.getDependencies());
                    }
                    if (this.showSummary) {
                        this.showSummary(engine.getDependencies());
                    }
                }
                catch (IOException ex) {
                    this.log("Unable to generate dependency-check report", ex, 4);
                    throw new BuildException("Unable to generate dependency-check report", (Throwable)ex);
                }
                catch (Exception ex) {
                    this.log("An exception occurred; unable to continue task", ex, 4);
                    throw new BuildException("An exception occurred; unable to continue task", (Throwable)ex);
                }
            }
            catch (DatabaseException ex) {
                this.log("Unable to connect to the dependency-check database; analysis has stopped", ex, 0);
            }
            finally {
                Settings.cleanup((boolean)true);
                if (engine != null) {
                    engine.cleanup();
                }
            }
        }
    }

    private void validateConfiguration() throws BuildException {
        if (this.path == null) {
            throw new BuildException("No project dependencies have been defined to analyze.");
        }
        if (this.failBuildOnCVSS < 0.0f || this.failBuildOnCVSS > 11.0f) {
            throw new BuildException("Invalid configuration, failBuildOnCVSS must be between 0 and 11.");
        }
    }

    @Override
    protected void populateSettings() throws BuildException {
        super.populateSettings();
        Settings.setBooleanIfNotNull((String)"autoupdate", (Boolean)this.autoUpdate);
        Settings.setStringIfNotEmpty((String)"suppression.file", (String)this.suppressionFile);
        Settings.setBooleanIfNotNull((String)"analyzer.jar.enabled", (Boolean)this.jarAnalyzerEnabled);
        Settings.setBooleanIfNotNull((String)"analyzer.python.distribution.enabled", (Boolean)this.pyDistributionAnalyzerEnabled);
        Settings.setBooleanIfNotNull((String)"analyzer.python.package.enabled", (Boolean)this.pyPackageAnalyzerEnabled);
        Settings.setBooleanIfNotNull((String)"analyzer.ruby.gemspec.enabled", (Boolean)this.rubygemsAnalyzerEnabled);
        Settings.setBooleanIfNotNull((String)"analyzer.openssl.enabled", (Boolean)this.opensslAnalyzerEnabled);
        Settings.setBooleanIfNotNull((String)"analyzer.cmake.enabled", (Boolean)this.cmakeAnalyzerEnabled);
        Settings.setBooleanIfNotNull((String)"analyzer.autoconf.enabled", (Boolean)this.autoconfAnalyzerEnabled);
        Settings.setBooleanIfNotNull((String)"analyzer.composer.lock.enabled", (Boolean)this.composerAnalyzerEnabled);
        Settings.setBooleanIfNotNull((String)"analyzer.node.package.enabled", (Boolean)this.nodeAnalyzerEnabled);
        Settings.setBooleanIfNotNull((String)"analyzer.nuspec.enabled", (Boolean)this.nuspecAnalyzerEnabled);
        Settings.setBooleanIfNotNull((String)"analyzer.central.enabled", (Boolean)this.centralAnalyzerEnabled);
        Settings.setBooleanIfNotNull((String)"analyzer.nexus.enabled", (Boolean)this.nexusAnalyzerEnabled);
        Settings.setBooleanIfNotNull((String)"analyzer.archive.enabled", (Boolean)this.archiveAnalyzerEnabled);
        Settings.setBooleanIfNotNull((String)"analyzer.assembly.enabled", (Boolean)this.assemblyAnalyzerEnabled);
        Settings.setStringIfNotEmpty((String)"analyzer.nexus.url", (String)this.nexusUrl);
        Settings.setBooleanIfNotNull((String)"analyzer.nexus.proxy", (Boolean)this.nexusUsesProxy);
        Settings.setStringIfNotEmpty((String)"extensions.zip", (String)this.zipExtensions);
        Settings.setStringIfNotEmpty((String)"analyzer.assembly.mono.path", (String)this.pathToMono);
    }

    private void checkForFailure(List<Dependency> dependencies) throws BuildException {
        StringBuilder ids = new StringBuilder();
        for (Dependency d : dependencies) {
            for (Vulnerability v : d.getVulnerabilities()) {
                if (!(v.getCvssScore() >= this.failBuildOnCVSS)) continue;
                if (ids.length() == 0) {
                    ids.append(v.getName());
                    continue;
                }
                ids.append(", ").append(v.getName());
            }
        }
        if (ids.length() > 0) {
            String msg = String.format("%n%nDependency-Check Failure:%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater then '%.1f': %s%nSee the dependency-check report for more details.%n%n", Float.valueOf(this.failBuildOnCVSS), ids.toString());
            throw new BuildException(msg);
        }
    }

    private void showSummary(List<Dependency> dependencies) {
        StringBuilder summary = new StringBuilder();
        for (Dependency d : dependencies) {
            boolean firstEntry = true;
            StringBuilder ids = new StringBuilder();
            for (Vulnerability v : d.getVulnerabilities()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    ids.append(", ");
                }
                ids.append(v.getName());
            }
            if (ids.length() <= 0) continue;
            summary.append(d.getFileName()).append(" (");
            firstEntry = true;
            for (Identifier id : d.getIdentifiers()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    summary.append(", ");
                }
                summary.append(id.getValue());
            }
            summary.append(") : ").append((CharSequence)ids).append(NEW_LINE);
        }
        if (summary.length() > 0) {
            String msg = String.format("%n%nOne or more dependencies were identified with known vulnerabilities:%n%n%s%n%nSee the dependency-check report for more details.%n%n", summary.toString());
            this.log(msg, 1);
        }
    }

    public static class ReportFormats
    extends EnumeratedAttribute {
        public String[] getValues() {
            int i = 0;
            ReportGenerator.Format[] formats = ReportGenerator.Format.values();
            String[] values = new String[formats.length];
            for (ReportGenerator.Format format : formats) {
                values[i++] = format.name();
            }
            return values;
        }
    }
}

