/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import org.apache.tools.ant.BuildException;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.taskdefs.Purge;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.impl.StaticLoggerBinder;

public class Update
extends Purge {
    private String proxyServer;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String connectionTimeout;
    private String databaseDriverName;
    private String databaseDriverPath;
    private String connectionString;
    private String databaseUser;
    private String databasePassword;
    private String cveUrl12Modified;
    private String cveUrl20Modified;
    private String cveUrl12Base;
    private String cveUrl20Base;

    public Update() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(String server) {
        this.proxyServer = server;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getDatabaseDriverName() {
        return this.databaseDriverName;
    }

    public void setDatabaseDriverName(String databaseDriverName) {
        this.databaseDriverName = databaseDriverName;
    }

    public String getDatabaseDriverPath() {
        return this.databaseDriverPath;
    }

    public void setDatabaseDriverPath(String databaseDriverPath) {
        this.databaseDriverPath = databaseDriverPath;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getCveUrl12Modified() {
        return this.cveUrl12Modified;
    }

    public void setCveUrl12Modified(String cveUrl12Modified) {
        this.cveUrl12Modified = cveUrl12Modified;
    }

    public String getCveUrl20Modified() {
        return this.cveUrl20Modified;
    }

    public void setCveUrl20Modified(String cveUrl20Modified) {
        this.cveUrl20Modified = cveUrl20Modified;
    }

    public String getCveUrl12Base() {
        return this.cveUrl12Base;
    }

    public void setCveUrl12Base(String cveUrl12Base) {
        this.cveUrl12Base = cveUrl12Base;
    }

    public String getCveUrl20Base() {
        return this.cveUrl20Base;
    }

    public void setCveUrl20Base(String cveUrl20Base) {
        this.cveUrl20Base = cveUrl20Base;
    }

    @Override
    public void execute() throws BuildException {
        this.populateSettings();
        Engine engine = null;
        try {
            engine = new Engine(Update.class.getClassLoader());
            engine.doUpdates();
        }
        catch (DatabaseException ex) {
            throw new BuildException("Unable to connect to the dependency-check database; unable to update the NVD data", (Throwable)ex);
        }
        finally {
            Settings.cleanup((boolean)true);
            if (engine != null) {
                engine.cleanup();
            }
        }
    }

    @Override
    protected void populateSettings() {
        super.populateSettings();
        if (this.proxyServer != null && !this.proxyServer.isEmpty()) {
            Settings.setString((String)"proxy.server", (String)this.proxyServer);
        }
        if (this.proxyPort != null && !this.proxyPort.isEmpty()) {
            Settings.setString((String)"proxy.port", (String)this.proxyPort);
        }
        if (this.proxyUsername != null && !this.proxyUsername.isEmpty()) {
            Settings.setString((String)"proxy.username", (String)this.proxyUsername);
        }
        if (this.proxyPassword != null && !this.proxyPassword.isEmpty()) {
            Settings.setString((String)"proxy.password", (String)this.proxyPassword);
        }
        if (this.connectionTimeout != null && !this.connectionTimeout.isEmpty()) {
            Settings.setString((String)"connection.timeout", (String)this.connectionTimeout);
        }
        if (this.databaseDriverName != null && !this.databaseDriverName.isEmpty()) {
            Settings.setString((String)"data.driver_name", (String)this.databaseDriverName);
        }
        if (this.databaseDriverPath != null && !this.databaseDriverPath.isEmpty()) {
            Settings.setString((String)"data.driver_path", (String)this.databaseDriverPath);
        }
        if (this.connectionString != null && !this.connectionString.isEmpty()) {
            Settings.setString((String)"data.connection_string", (String)this.connectionString);
        }
        if (this.databaseUser != null && !this.databaseUser.isEmpty()) {
            Settings.setString((String)"data.user", (String)this.databaseUser);
        }
        if (this.databasePassword != null && !this.databasePassword.isEmpty()) {
            Settings.setString((String)"data.password", (String)this.databasePassword);
        }
        if (this.cveUrl12Modified != null && !this.cveUrl12Modified.isEmpty()) {
            Settings.setString((String)"cve.url-1.2.modified", (String)this.cveUrl12Modified);
        }
        if (this.cveUrl20Modified != null && !this.cveUrl20Modified.isEmpty()) {
            Settings.setString((String)"cve.url-2.0.modified", (String)this.cveUrl20Modified);
        }
        if (this.cveUrl12Base != null && !this.cveUrl12Base.isEmpty()) {
            Settings.setString((String)"cve.url-1.2.base", (String)this.cveUrl12Base);
        }
        if (this.cveUrl20Base != null && !this.cveUrl20Base.isEmpty()) {
            Settings.setString((String)"cve.url-2.0.base", (String)this.cveUrl20Base);
        }
    }
}

