/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMakeAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CMakeAnalyzer.class);
    private static final int REGEX_OPTIONS = 42;
    private static final Pattern PROJECT = Pattern.compile("^ *project *\\([ \\n]*(\\w+)[ \\n]*.*?\\)", 42);
    private static final Pattern SET_VERSION = Pattern.compile("^ *set\\s*\\(\\s*(\\w+)_version\\s+\"?(\\d+(?:\\.\\d+)+)[\\s\"]?\\)", 42);
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions(".cmake").addFilenames("CMakeLists.txt").build();
    private static MessageDigest sha1 = null;

    @Override
    public String getName() {
        return "CMake Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    protected void initializeFileTypeAnalyzer() throws Exception {
    }

    @Override
    protected void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        String contents;
        File file = dependency.getActualFile();
        String parentName = file.getParentFile().getName();
        String name = file.getName();
        dependency.setDisplayFileName(String.format("%s%c%s", parentName, Character.valueOf(File.separatorChar), name));
        try {
            contents = FileUtils.readFileToString(file).trim();
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        if (StringUtils.isNotBlank(contents)) {
            Matcher m = PROJECT.matcher(contents);
            int count = 0;
            while (m.find()) {
                ++count;
                LOGGER.debug(String.format("Found project command match with %d groups: %s", m.groupCount(), m.group(0)));
                String group = m.group(1);
                LOGGER.debug("Group 1: " + group);
                dependency.getProductEvidence().addEvidence(name, "Project", group, Confidence.HIGH);
            }
            LOGGER.debug(String.format("Found %d matches.", count));
            this.analyzeSetVersionCommand(dependency, engine, contents);
        }
    }

    private void analyzeSetVersionCommand(Dependency dependency, Engine engine, String contents) {
        Dependency orig = dependency;
        Matcher m = SET_VERSION.matcher(contents);
        int count = 0;
        while (m.find()) {
            ++count;
            LOGGER.debug(String.format("Found project command match with %d groups: %s", m.groupCount(), m.group(0)));
            String product = m.group(1);
            String version = m.group(2);
            LOGGER.debug("Group 1: " + product);
            LOGGER.debug("Group 2: " + version);
            String aliasPrefix = "ALIASOF_";
            if (product.startsWith("ALIASOF_")) {
                product = product.replaceFirst("ALIASOF_", "");
            }
            if (count > 1) {
                dependency = new Dependency(orig.getActualFile());
                dependency.setDisplayFileName(String.format("%s:%s", orig.getDisplayFileName(), product));
                String filePath = String.format("%s:%s", orig.getFilePath(), product);
                dependency.setFilePath(filePath);
                dependency.setSha1sum(Checksum.getHex(sha1.digest(filePath.getBytes())));
                engine.getDependencies().add(dependency);
            }
            String source = dependency.getDisplayFileName();
            dependency.getProductEvidence().addEvidence(source, "Product", product, Confidence.MEDIUM);
            dependency.getVersionEvidence().addEvidence(source, "Version", version, Confidence.MEDIUM);
        }
        LOGGER.debug(String.format("Found %d matches.", count));
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.cmake.enabled";
    }

    static {
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(e.getMessage());
        }
    }
}

