/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.jaxb.pom;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.owasp.dependencycheck.analyzer.JarAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.jaxb.pom.MavenNamespaceFilter;
import org.owasp.dependencycheck.jaxb.pom.generated.Model;
import org.owasp.dependencycheck.jaxb.pom.generated.Organization;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PomUtils {
    private static final Logger LOGGER = Logger.getLogger(PomUtils.class.getName());
    private Unmarshaller pomUnmarshaller;

    public PomUtils() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Model.class});
            this.pomUnmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException ex) {
            LOGGER.log(Level.SEVERE, "Unable to load parser. See the log for more details.");
            LOGGER.log(Level.FINE, null, ex);
        }
    }

    public Model readPom(File file) throws AnalysisException {
        Model model = null;
        try {
            FileInputStream stream = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader((InputStream)stream, "UTF-8");
            InputSource xml = new InputSource(reader);
            SAXSource source = new SAXSource(xml);
            model = this.readPom(source);
        }
        catch (SecurityException ex) {
            String msg = String.format("Unable to parse pom '%s'; invalid signature", file.getPath());
            LOGGER.log(Level.WARNING, msg);
            LOGGER.log(Level.FINE, "", ex);
            throw new AnalysisException(ex);
        }
        catch (IOException ex) {
            String msg = String.format("Unable to parse pom '%s'(IO Exception)", file.getPath());
            LOGGER.log(Level.WARNING, msg);
            LOGGER.log(Level.FINE, "", ex);
            throw new AnalysisException(ex);
        }
        catch (Throwable ex) {
            String msg = String.format("Unexpected error during parsing of the pom '%s'", file.getPath());
            LOGGER.log(Level.WARNING, msg);
            LOGGER.log(Level.FINE, "", ex);
            throw new AnalysisException(ex);
        }
        return model;
    }

    public Model readPom(SAXSource source) throws AnalysisException {
        Model model = null;
        try {
            MavenNamespaceFilter filter = new MavenNamespaceFilter();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            filter.setParent(xr);
            JAXBElement el = this.pomUnmarshaller.unmarshal((Source)source, Model.class);
            model = (Model)el.getValue();
        }
        catch (SecurityException ex) {
            throw new AnalysisException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new AnalysisException(ex);
        }
        catch (SAXException ex) {
            throw new AnalysisException(ex);
        }
        catch (JAXBException ex) {
            throw new AnalysisException(ex);
        }
        catch (Throwable ex) {
            throw new AnalysisException(ex);
        }
        return model;
    }

    public void analyzePOM(Dependency dependency, File pomFile) throws AnalysisException {
        String description;
        String pomName;
        String orgName;
        Organization org;
        Model pom = this.readPom(pomFile);
        String groupid = pom.getGroupId();
        String parentGroupId = null;
        if (pom.getParent() != null) {
            parentGroupId = pom.getParent().getGroupId();
            if ((groupid == null || groupid.isEmpty()) && parentGroupId != null && !parentGroupId.isEmpty()) {
                groupid = parentGroupId;
            }
        }
        if (groupid != null && !groupid.isEmpty()) {
            dependency.getVendorEvidence().addEvidence("pom", "groupid", groupid, Confidence.HIGHEST);
            dependency.getProductEvidence().addEvidence("pom", "groupid", groupid, Confidence.LOW);
            if (parentGroupId != null && !parentGroupId.isEmpty() && !parentGroupId.equals(groupid)) {
                dependency.getVendorEvidence().addEvidence("pom", "parent-groupid", parentGroupId, Confidence.MEDIUM);
                dependency.getProductEvidence().addEvidence("pom", "parent-groupid", parentGroupId, Confidence.LOW);
            }
        }
        String artifactid = pom.getArtifactId();
        String parentArtifactId = null;
        if (pom.getParent() != null) {
            parentArtifactId = pom.getParent().getArtifactId();
            if ((artifactid == null || artifactid.isEmpty()) && parentArtifactId != null && !parentArtifactId.isEmpty()) {
                artifactid = parentArtifactId;
            }
        }
        if (artifactid != null && !artifactid.isEmpty()) {
            if (artifactid.startsWith("org.") || artifactid.startsWith("com.")) {
                artifactid = artifactid.substring(4);
            }
            dependency.getProductEvidence().addEvidence("pom", "artifactid", artifactid, Confidence.HIGHEST);
            dependency.getVendorEvidence().addEvidence("pom", "artifactid", artifactid, Confidence.LOW);
            if (parentArtifactId != null && !parentArtifactId.isEmpty() && !parentArtifactId.equals(artifactid)) {
                dependency.getProductEvidence().addEvidence("pom", "parent-artifactid", parentArtifactId, Confidence.MEDIUM);
                dependency.getVendorEvidence().addEvidence("pom", "parent-artifactid", parentArtifactId, Confidence.LOW);
            }
        }
        String version = pom.getVersion();
        String parentVersion = null;
        if (pom.getParent() != null) {
            parentVersion = pom.getParent().getVersion();
            if ((version == null || version.isEmpty()) && parentVersion != null && !parentVersion.isEmpty()) {
                version = parentVersion;
            }
        }
        if (version != null && !version.isEmpty()) {
            dependency.getVersionEvidence().addEvidence("pom", "version", version, Confidence.HIGHEST);
            if (parentVersion != null && !parentVersion.isEmpty() && !parentVersion.equals(version)) {
                dependency.getVersionEvidence().addEvidence("pom", "parent-version", version, Confidence.LOW);
            }
        }
        if ((org = pom.getOrganization()) != null && (orgName = org.getName()) != null && !orgName.isEmpty()) {
            dependency.getVendorEvidence().addEvidence("pom", "organization name", orgName, Confidence.HIGH);
        }
        if ((pomName = pom.getName()) != null && !pomName.isEmpty()) {
            dependency.getProductEvidence().addEvidence("pom", "name", pomName, Confidence.HIGH);
            dependency.getVendorEvidence().addEvidence("pom", "name", pomName, Confidence.HIGH);
        }
        if (pom.getDescription() != null && (description = pom.getDescription()) != null && !description.isEmpty()) {
            JarAnalyzer.addDescription(dependency, description, "pom", "description");
        }
        JarAnalyzer.extractLicense(pom, null, dependency);
    }
}

