/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.owasp.dependencycheck.utils.LogFilter;

public final class LogUtils {
    private static final Logger LOGGER = Logger.getLogger(LogUtils.class.getName());
    private static boolean verboseLoggingEnabled = false;

    private LogUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareLogger(InputStream in, String verboseLogFile) {
        try {
            LogManager.getLogManager().reset();
            LogManager.getLogManager().readConfiguration(in);
            if (verboseLogFile != null && !verboseLogFile.isEmpty()) {
                verboseLoggingEnabled = true;
                Logger logger = Logger.getLogger("");
                FileHandler fileHandler = new FileHandler(verboseLogFile, true);
                fileHandler.setFormatter(new SimpleFormatter());
                fileHandler.setLevel(Level.FINE);
                fileHandler.setFilter(new LogFilter());
                logger.addHandler(fileHandler);
                logger.setLevel(Level.FINE);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "IO Error preparing the logger", ex);
        }
        catch (SecurityException ex) {
            LOGGER.log(Level.WARNING, "Error preparing the logger", ex);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.WARNING, "Error preparing the logger", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, "Error closing resource stream", ex);
                }
            }
        }
    }

    public static boolean isVerboseLoggingEnabled() {
        return verboseLoggingEnabled;
    }
}

