/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceCollection;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerabilityComparator;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileUtils;

public class Dependency
implements Serializable,
Comparable<Dependency> {
    private static final Logger LOGGER = Logger.getLogger(Dependency.class.getName());
    private String actualFilePath;
    private String filePath;
    private String fileName;
    private String fileExtension;
    private String md5sum;
    private String sha1sum;
    private Set<Identifier> identifiers;
    private final EvidenceCollection vendorEvidence;
    private final EvidenceCollection productEvidence;
    private final EvidenceCollection versionEvidence;
    private String displayName = null;
    private Set<Identifier> suppressedIdentifiers;
    private SortedSet<Vulnerability> suppressedVulnerabilities;
    private String description;
    private String license;
    private SortedSet<Vulnerability> vulnerabilities;
    private Set<Dependency> relatedDependencies = new TreeSet<Dependency>();

    public Dependency() {
        this.vendorEvidence = new EvidenceCollection();
        this.productEvidence = new EvidenceCollection();
        this.versionEvidence = new EvidenceCollection();
        this.identifiers = new TreeSet<Identifier>();
        this.vulnerabilities = new TreeSet<Vulnerability>(new VulnerabilityComparator());
        this.suppressedIdentifiers = new TreeSet<Identifier>();
        this.suppressedVulnerabilities = new TreeSet<Vulnerability>(new VulnerabilityComparator());
    }

    public Dependency(File file) {
        this();
        this.filePath = this.actualFilePath = file.getPath();
        this.fileName = file.getName();
        this.fileExtension = FileUtils.getFileExtension(this.fileName);
        this.determineHashes(file);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNameForJavaScript() {
        return this.fileName.replace("\\", "\\\\");
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setActualFilePath(String actualFilePath) {
        this.actualFilePath = actualFilePath;
        if (this.sha1sum == null) {
            File file = new File(this.actualFilePath);
            this.determineHashes(file);
        }
    }

    public String getActualFilePath() {
        return this.actualFilePath;
    }

    public File getActualFile() {
        return new File(this.actualFilePath);
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setDisplayFileName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayFileName() {
        if (this.displayName == null) {
            return this.fileName;
        }
        return this.displayName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getMd5sum() {
        return this.md5sum;
    }

    public void setMd5sum(String md5sum) {
        this.md5sum = md5sum;
    }

    public String getSha1sum() {
        return this.sha1sum;
    }

    public void setSha1sum(String sha1sum) {
        this.sha1sum = sha1sum;
    }

    public Set<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(Set<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    public void addIdentifier(String type, String value, String url) {
        Identifier i = new Identifier(type, value, url);
        this.identifiers.add(i);
    }

    public void addIdentifier(String type, String value, String url, Confidence confidence) {
        Identifier i = new Identifier(type, value, url);
        i.setConfidence(confidence);
        this.identifiers.add(i);
    }

    public void addAsEvidence(String source, MavenArtifact mavenArtifact, Confidence confidence) {
        if (mavenArtifact.getGroupId() != null && !mavenArtifact.getGroupId().isEmpty()) {
            this.getVendorEvidence().addEvidence(source, "groupid", mavenArtifact.getGroupId(), confidence);
        }
        if (mavenArtifact.getArtifactId() != null && !mavenArtifact.getArtifactId().isEmpty()) {
            this.getProductEvidence().addEvidence(source, "artifactid", mavenArtifact.getArtifactId(), confidence);
        }
        if (mavenArtifact.getVersion() != null && !mavenArtifact.getVersion().isEmpty()) {
            this.getVersionEvidence().addEvidence(source, "version", mavenArtifact.getVersion(), confidence);
        }
        if (mavenArtifact.getArtifactUrl() != null && !mavenArtifact.getArtifactUrl().isEmpty()) {
            boolean found = false;
            for (Identifier i : this.getIdentifiers()) {
                if (!"maven".equals(i.getType()) || !i.getValue().equals(mavenArtifact.toString())) continue;
                found = true;
                i.setConfidence(Confidence.HIGHEST);
                i.setUrl(mavenArtifact.getArtifactUrl());
                LOGGER.fine(String.format("Already found identifier %s. Confidence set to highest", i.getValue()));
                break;
            }
            if (!found) {
                LOGGER.fine(String.format("Adding new maven identifier %s", mavenArtifact.toString()));
                this.addIdentifier("maven", mavenArtifact.toString(), mavenArtifact.getArtifactUrl(), Confidence.HIGHEST);
            }
        }
    }

    public void addIdentifier(Identifier identifier) {
        this.identifiers.add(identifier);
    }

    public Set<Identifier> getSuppressedIdentifiers() {
        return this.suppressedIdentifiers;
    }

    public void setSuppressedIdentifiers(Set<Identifier> suppressedIdentifiers) {
        this.suppressedIdentifiers = suppressedIdentifiers;
    }

    public void addSuppressedIdentifier(Identifier identifier) {
        this.suppressedIdentifiers.add(identifier);
    }

    public SortedSet<Vulnerability> getSuppressedVulnerabilities() {
        return this.suppressedVulnerabilities;
    }

    public void setSuppressedVulnerabilities(SortedSet<Vulnerability> suppressedVulnerabilities) {
        this.suppressedVulnerabilities = suppressedVulnerabilities;
    }

    public void addSuppressedVulnerability(Vulnerability vulnerability) {
        this.suppressedVulnerabilities.add(vulnerability);
    }

    public EvidenceCollection getEvidence() {
        return EvidenceCollection.merge(this.productEvidence, this.vendorEvidence, this.versionEvidence);
    }

    public Set<Evidence> getEvidenceForDisplay() {
        return EvidenceCollection.mergeForDisplay(this.productEvidence, this.vendorEvidence, this.versionEvidence);
    }

    public EvidenceCollection getEvidenceUsed() {
        return EvidenceCollection.mergeUsed(this.productEvidence, this.vendorEvidence, this.versionEvidence);
    }

    public EvidenceCollection getVendorEvidence() {
        return this.vendorEvidence;
    }

    public EvidenceCollection getProductEvidence() {
        return this.productEvidence;
    }

    public EvidenceCollection getVersionEvidence() {
        return this.versionEvidence;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public SortedSet<Vulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public void setVulnerabilities(SortedSet<Vulnerability> vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
    }

    private void determineHashes(File file) {
        String md5 = null;
        String sha1 = null;
        try {
            md5 = Checksum.getMD5Checksum(file);
            sha1 = Checksum.getSHA1Checksum(file);
        }
        catch (IOException ex) {
            String msg = String.format("Unable to read '%s' to determine hashes.", file.getName());
            LOGGER.log(Level.WARNING, msg);
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            String msg = "Unable to use MD5 of SHA1 checksums.";
            LOGGER.log(Level.WARNING, "Unable to use MD5 of SHA1 checksums.");
            LOGGER.log(Level.FINE, null, ex);
        }
        this.setMd5sum(md5);
        this.setSha1sum(sha1);
    }

    public void addVulnerability(Vulnerability vulnerability) {
        this.vulnerabilities.add(vulnerability);
    }

    public Set<Dependency> getRelatedDependencies() {
        return this.relatedDependencies;
    }

    public void setRelatedDependencies(Set<Dependency> relatedDependencies) {
        this.relatedDependencies = relatedDependencies;
    }

    public void addRelatedDependency(Dependency dependency) {
        this.relatedDependencies.add(dependency);
    }

    @Override
    public int compareTo(Dependency o) {
        return this.getFilePath().compareToIgnoreCase(o.getFilePath());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency other = (Dependency)obj;
        if (this.actualFilePath == null ? other.actualFilePath != null : !this.actualFilePath.equals(other.actualFilePath)) {
            return false;
        }
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.fileExtension == null ? other.fileExtension != null : !this.fileExtension.equals(other.fileExtension)) {
            return false;
        }
        if (this.md5sum == null ? other.md5sum != null : !this.md5sum.equals(other.md5sum)) {
            return false;
        }
        if (this.sha1sum == null ? other.sha1sum != null : !this.sha1sum.equals(other.sha1sum)) {
            return false;
        }
        if (!(this.identifiers == other.identifiers || this.identifiers != null && this.identifiers.equals(other.identifiers))) {
            return false;
        }
        if (!(this.vendorEvidence == other.vendorEvidence || this.vendorEvidence != null && this.vendorEvidence.equals(other.vendorEvidence))) {
            return false;
        }
        if (!(this.productEvidence == other.productEvidence || this.productEvidence != null && this.productEvidence.equals(other.productEvidence))) {
            return false;
        }
        if (!(this.versionEvidence == other.versionEvidence || this.versionEvidence != null && this.versionEvidence.equals(other.versionEvidence))) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.license == null ? other.license != null : !this.license.equals(other.license)) {
            return false;
        }
        if (!(this.vulnerabilities == other.vulnerabilities || this.vulnerabilities != null && this.vulnerabilities.equals(other.vulnerabilities))) {
            return false;
        }
        return this.relatedDependencies == other.relatedDependencies || this.relatedDependencies != null && this.relatedDependencies.equals(other.relatedDependencies);
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + (this.actualFilePath != null ? this.actualFilePath.hashCode() : 0);
        hash = 47 * hash + (this.filePath != null ? this.filePath.hashCode() : 0);
        hash = 47 * hash + (this.fileName != null ? this.fileName.hashCode() : 0);
        hash = 47 * hash + (this.fileExtension != null ? this.fileExtension.hashCode() : 0);
        hash = 47 * hash + (this.md5sum != null ? this.md5sum.hashCode() : 0);
        hash = 47 * hash + (this.sha1sum != null ? this.sha1sum.hashCode() : 0);
        hash = 47 * hash + (this.identifiers != null ? this.identifiers.hashCode() : 0);
        hash = 47 * hash + (this.vendorEvidence != null ? this.vendorEvidence.hashCode() : 0);
        hash = 47 * hash + (this.productEvidence != null ? this.productEvidence.hashCode() : 0);
        hash = 47 * hash + (this.versionEvidence != null ? this.versionEvidence.hashCode() : 0);
        hash = 47 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 47 * hash + (this.license != null ? this.license.hashCode() : 0);
        hash = 47 * hash + (this.vulnerabilities != null ? this.vulnerabilities.hashCode() : 0);
        hash = 47 * hash + (this.relatedDependencies != null ? this.relatedDependencies.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "Dependency{ fileName='" + this.fileName + "', actualFilePath='" + this.actualFilePath + "', filePath='" + this.filePath + "'}";
    }
}

