/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.lucene;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.util.Version;
import org.owasp.dependencycheck.data.lucene.AlphaNumericTokenizer;

public class FieldAnalyzer
extends Analyzer {
    private final Version version;

    public FieldAnalyzer(Version version) {
        this.version = version;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        AlphaNumericTokenizer source;
        TokenStream stream = source = new AlphaNumericTokenizer(this.version, reader);
        stream = new WordDelimiterFilter(stream, 487, null);
        stream = new LowerCaseFilter(this.version, stream);
        stream = new StopFilter(this.version, stream, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        return new Analyzer.TokenStreamComponents(source, stream);
    }
}

