/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;

public class JavaScriptAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(JavaScriptAnalyzer.class.getName());
    private static final String ANALYZER_NAME = "JavaScript Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final Set<String> EXTENSIONS = JavaScriptAnalyzer.newHashSet("js");

    @Override
    public Set<String> getSupportedExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.javascript.enabled";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        BufferedReader fin = null;
        try {
            String text;
            Pattern extractComments = Pattern.compile("(/\\*([^*]|[\\r\\n]|(\\*+([^*/]|[\\r\\n])))*\\*+/)|(//.*)", 8);
            File file = dependency.getActualFile();
            fin = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder(2000);
            while ((text = fin.readLine()) != null) {
                sb.append(text);
            }
        }
        catch (FileNotFoundException ex) {
            String msg = String.format("Dependency file not found: '%s'", dependency.getActualFilePath());
            throw new AnalysisException(msg, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, null, ex);
                }
            }
        }
    }

    @Override
    protected void initializeFileTypeAnalyzer() throws Exception {
    }
}

