/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.lucene;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.util.Version;
import org.owasp.dependencycheck.data.lucene.AlphaNumericTokenizer;
import org.owasp.dependencycheck.data.lucene.TokenPairConcatenatingFilter;
import org.owasp.dependencycheck.data.lucene.UrlTokenizingFilter;

public class SearchFieldAnalyzer
extends Analyzer {
    private final Version version;
    private TokenPairConcatenatingFilter concatenatingFilter;

    public SearchFieldAnalyzer(Version version) {
        this.version = version;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        AlphaNumericTokenizer source;
        TokenStream stream = source = new AlphaNumericTokenizer(this.version, reader);
        stream = new WordDelimiterFilter(stream, 483, null);
        stream = new LowerCaseFilter(this.version, stream);
        stream = new UrlTokenizingFilter(stream);
        this.concatenatingFilter = new TokenPairConcatenatingFilter(stream);
        stream = this.concatenatingFilter;
        stream = new StopFilter(this.version, stream, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        return new Analyzer.TokenStreamComponents(source, stream);
    }

    public void clear() {
        if (this.concatenatingFilter != null) {
            this.concatenatingFilter.clear();
        }
    }
}

