/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.suppression.SuppressionParseException;
import org.owasp.dependencycheck.suppression.SuppressionParser;
import org.owasp.dependencycheck.suppression.SuppressionRule;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.Settings;

public abstract class AbstractSuppressionAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(AbstractSuppressionAnalyzer.class.getName());
    private List<SuppressionRule> rules;

    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this.loadSuppressionData();
    }

    public List<SuppressionRule> getRules() {
        return this.rules;
    }

    public void setRules(List<SuppressionRule> rules) {
        this.rules = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSuppressionData() throws SuppressionParseException {
        block22: {
            SuppressionParser parser = new SuppressionParser();
            File file = null;
            file = new File(this.getClass().getClassLoader().getResource("dependencycheck-base-suppression.xml").getPath());
            try {
                this.rules = parser.parseSuppressionRules(file);
            }
            catch (SuppressionParseException ex) {
                LOGGER.log(Level.FINE, "Unable to parse the base suppression data file", ex);
            }
            String suppressionFilePath = Settings.getString("suppression.file");
            if (suppressionFilePath == null) {
                return;
            }
            boolean deleteTempFile = false;
            try {
                Pattern uriRx = Pattern.compile("^(https?|file)\\:.*", 2);
                if (uriRx.matcher(suppressionFilePath).matches()) {
                    deleteTempFile = true;
                    file = FileUtils.getTempFile("suppression", "xml");
                    URL url = new URL(suppressionFilePath);
                    try {
                        Downloader.fetchFile(url, file, false);
                    }
                    catch (DownloadFailedException ex) {
                        Downloader.fetchFile(url, file, true);
                    }
                } else {
                    InputStream suppressionsFromClasspath;
                    file = new File(suppressionFilePath);
                    if (!file.exists() && (suppressionsFromClasspath = this.getClass().getClassLoader().getResourceAsStream(suppressionFilePath)) != null) {
                        deleteTempFile = true;
                        file = FileUtils.getTempFile("suppression", "xml");
                        try {
                            org.apache.commons.io.FileUtils.copyInputStreamToFile(suppressionsFromClasspath, file);
                        }
                        catch (IOException ex) {
                            this.throwSuppressionParseException("Unable to locate suppressions file in classpath", ex);
                        }
                    }
                }
                if (file == null) break block22;
                try {
                    this.rules.addAll(parser.parseSuppressionRules(file));
                    LOGGER.log(Level.FINE, this.rules.size() + " suppression rules were loaded.");
                }
                catch (SuppressionParseException ex) {
                    String msg = String.format("Unable to parse suppression xml file '%s'", file.getPath());
                    LOGGER.log(Level.WARNING, msg);
                    LOGGER.log(Level.WARNING, ex.getMessage());
                    LOGGER.log(Level.FINE, "", ex);
                    throw ex;
                }
            }
            catch (DownloadFailedException ex) {
                this.throwSuppressionParseException("Unable to fetch the configured suppression file", ex);
            }
            catch (MalformedURLException ex) {
                this.throwSuppressionParseException("Configured suppression file has an invalid URL", ex);
            }
            catch (IOException ex) {
                this.throwSuppressionParseException("Unable to create temp file for suppressions", ex);
            }
            finally {
                if (deleteTempFile && file != null) {
                    FileUtils.delete(file);
                }
            }
        }
    }

    private void throwSuppressionParseException(String message, Exception exception) throws SuppressionParseException {
        LOGGER.log(Level.WARNING, message);
        LOGGER.log(Level.FINE, "", exception);
        throw new SuppressionParseException(message, exception);
    }
}

