/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;

public final class Downloader {
    private static final Logger LOGGER = Logger.getLogger(Downloader.class.getName());

    private Downloader() {
    }

    public static void fetchFile(URL url, File outputPath) throws DownloadFailedException {
        Downloader.fetchFile(url, outputPath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetchFile(URL url, File outputPath, boolean useProxy) throws DownloadFailedException {
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            File file;
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException ex) {
                String msg = String.format("Download failed, unable to locate '%s'", url.toString());
                throw new DownloadFailedException(msg);
            }
            if (file.exists()) {
                try {
                    FileUtils.copyFile(file, outputPath);
                }
                catch (IOException ex) {
                    String msg = String.format("Download failed, unable to copy '%s'", url.toString());
                    throw new DownloadFailedException(msg);
                }
            }
            String msg = String.format("Download failed, file does not exist '%s'", url.toString());
            throw new DownloadFailedException(msg);
        }
        HttpURLConnection conn = null;
        try {
            conn = URLConnectionFactory.createHttpURLConnection(url, useProxy);
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
            conn.connect();
        }
        catch (IOException ex) {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            finally {
                conn = null;
            }
            throw new DownloadFailedException("Error downloading file.", ex);
        }
        String encoding = conn.getContentEncoding();
        FilterOutputStream writer = null;
        InputStream reader = null;
        try {
            int bytesRead;
            reader = encoding != null && "gzip".equalsIgnoreCase(encoding) ? new GZIPInputStream(conn.getInputStream()) : (encoding != null && "deflate".equalsIgnoreCase(encoding) ? new InflaterInputStream(conn.getInputStream()) : conn.getInputStream());
            writer = new BufferedOutputStream(new FileOutputStream(outputPath));
            byte[] buffer = new byte[4096];
            while ((bytesRead = reader.read(buffer)) > 0) {
                ((BufferedOutputStream)writer).write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable ex) {
            throw new DownloadFailedException("Error saving downloaded file.", ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable ex) {
                    LOGGER.log(Level.FINEST, "Error closing the writer in Downloader.", ex);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable ex) {
                    LOGGER.log(Level.FINEST, "Error closing the reader in Downloader.", ex);
                }
            }
            try {
                conn.disconnect();
            }
            finally {
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified(URL url) throws DownloadFailedException {
        long timestamp = 0L;
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            File lastModifiedFile;
            try {
                lastModifiedFile = new File(url.toURI());
            }
            catch (URISyntaxException ex) {
                String msg = String.format("Unable to locate '%s'; is the cve.url-2.0.modified property set correctly?", url.toString());
                throw new DownloadFailedException(msg);
            }
            timestamp = lastModifiedFile.lastModified();
        } else {
            HttpURLConnection conn = null;
            try {
                conn = URLConnectionFactory.createHttpURLConnection(url);
                conn.setRequestMethod("HEAD");
                conn.connect();
                timestamp = conn.getLastModified();
            }
            catch (URLConnectionFailureException ex) {
                throw new DownloadFailedException("Error creating URL Connection for HTTP HEAD request.", ex);
            }
            catch (IOException ex) {
                throw new DownloadFailedException("Error making HTTP HEAD request.", ex);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    finally {
                        conn = null;
                    }
                }
            }
        }
        return timestamp;
    }
}

