/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nexus;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.w3c.dom.Document;

public class NexusSearch {
    private final URL rootURL;
    private boolean useProxy;
    private static final Logger LOGGER = Logger.getLogger(NexusSearch.class.getName());

    public NexusSearch(URL rootURL) {
        this.rootURL = rootURL;
        try {
            if (null != Settings.getString("proxy.url") && Settings.getBoolean("analyzer.nexus.proxy")) {
                this.useProxy = true;
                LOGGER.fine("Using proxy");
            } else {
                this.useProxy = false;
                LOGGER.fine("Not using proxy");
            }
        }
        catch (InvalidSettingException ise) {
            this.useProxy = false;
        }
    }

    public MavenArtifact searchSha1(String sha1) throws IOException {
        if (null == sha1 || !sha1.matches("^[0-9A-Fa-f]{40}$")) {
            throw new IllegalArgumentException("Invalid SHA1 format");
        }
        URL url = new URL(this.rootURL, String.format("identify/sha1/%s", sha1.toLowerCase()));
        LOGGER.fine(String.format("Searching Nexus url %s", url.toString()));
        HttpURLConnection conn = URLConnectionFactory.createHttpURLConnection(url, this.useProxy);
        conn.setDoOutput(true);
        conn.addRequestProperty("Accept", "application/xml");
        conn.connect();
        if (conn.getResponseCode() == 200) {
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = builder.parse(conn.getInputStream());
                XPath xpath = XPathFactory.newInstance().newXPath();
                String groupId = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/groupId", doc);
                String artifactId = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/artifactId", doc);
                String version = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/version", doc);
                String link = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/artifactLink", doc);
                return new MavenArtifact(groupId, artifactId, version, link);
            }
            catch (Throwable e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        if (conn.getResponseCode() == 404) {
            throw new FileNotFoundException("Artifact not found in Nexus");
        }
        String msg = String.format("Could not connect to Nexus received response code: %d %s", conn.getResponseCode(), conn.getResponseMessage());
        LOGGER.fine(msg);
        throw new IOException(msg);
    }

    public boolean preflightRequest() {
        try {
            HttpURLConnection conn = URLConnectionFactory.createHttpURLConnection(new URL(this.rootURL, "status"), this.useProxy);
            conn.addRequestProperty("Accept", "application/xml");
            conn.connect();
            if (conn.getResponseCode() != 200) {
                LOGGER.log(Level.WARNING, "Expected 200 result from Nexus, got {0}", conn.getResponseCode());
                return false;
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(conn.getInputStream());
            if (!"status".equals(doc.getDocumentElement().getNodeName())) {
                LOGGER.log(Level.WARNING, "Expected root node name of status, got {0}", doc.getDocumentElement().getNodeName());
                return false;
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }
}

