/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.utils.Settings;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AssemblyAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final String ANALYZER_NAME = "Assembly Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final Set<String> SUPPORTED_EXTENSIONS = AssemblyAnalyzer.newHashSet("dll", "exe");
    private File grokAssemblyExe = null;
    private DocumentBuilder builder;
    private static final Logger LOGGER = Logger.getLogger(AssemblyAnalyzer.class.getName(), "dependencycheck-resources");

    private List<String> buildArgumentList() {
        ArrayList<String> args = new ArrayList<String>();
        if (!"\\".equals(System.getProperty("file.separator"))) {
            if (Settings.getString("analyzer.assembly.mono.path") != null) {
                args.add(Settings.getString("analyzer.assembly.mono.path"));
            } else {
                args.add("mono");
            }
        }
        args.add(this.grokAssemblyExe.getPath());
        return args;
    }

    @Override
    public void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.grokAssemblyExe == null) {
            LOGGER.warning("analyzer.AssemblyAnalyzer.notdeployed");
            return;
        }
        List<String> args = this.buildArgumentList();
        args.add(dependency.getActualFilePath());
        ProcessBuilder pb = new ProcessBuilder(args);
        BufferedReader rdr = null;
        Document doc = null;
        try {
            String product;
            String vendor;
            XPath xpath;
            String error;
            Process proc = pb.start();
            rdr = new BufferedReader(new InputStreamReader(proc.getErrorStream(), "UTF-8"));
            String line = null;
            while (rdr.ready() && (line = rdr.readLine()) != null) {
                LOGGER.log(Level.WARNING, "analyzer.AssemblyAnalyzer.grokassembly.stderr", line);
            }
            int rc = 0;
            doc = this.builder.parse(proc.getInputStream());
            try {
                rc = proc.waitFor();
            }
            catch (InterruptedException ie) {
                if (rdr != null) {
                    try {
                        rdr.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.FINEST, "ignore", ex);
                    }
                }
                return;
            }
            if (rc == 3) {
                LOGGER.log(Level.FINE, "analyzer.AssemblyAnalyzer.notassembly", dependency.getActualFilePath());
                return;
            }
            if (rc != 0) {
                LOGGER.log(Level.WARNING, "analyzer.AssemblyAnalyzer.grokassembly.rc", rc);
            }
            if ((error = (xpath = XPathFactory.newInstance().newXPath()).evaluate("/assembly/error", doc)) != null && !"".equals(error)) {
                throw new AnalysisException(error);
            }
            String version = xpath.evaluate("/assembly/version", doc);
            if (version != null) {
                dependency.getVersionEvidence().addEvidence(new Evidence("grokassembly", "version", version, Confidence.HIGHEST));
            }
            if ((vendor = xpath.evaluate("/assembly/company", doc)) != null) {
                dependency.getVendorEvidence().addEvidence(new Evidence("grokassembly", "vendor", vendor, Confidence.HIGH));
            }
            if ((product = xpath.evaluate("/assembly/product", doc)) != null) {
                dependency.getProductEvidence().addEvidence(new Evidence("grokassembly", "product", product, Confidence.HIGH));
            }
        }
        catch (IOException ioe) {
            throw new AnalysisException(ioe);
        }
        catch (SAXException saxe) {
            throw new AnalysisException("Couldn't parse GrokAssembly result", saxe);
        }
        catch (XPathExpressionException xpe) {
            throw new AnalysisException(xpe);
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, "ignore", ex);
                }
            }
        }
    }

    @Override
    public void initializeFileTypeAnalyzer() throws Exception {
        File tempFile = File.createTempFile("GKA", ".exe", Settings.getTempDirectory());
        FileOutputStream fos = null;
        InputStream is = null;
        try {
            fos = new FileOutputStream(tempFile);
            is = AssemblyAnalyzer.class.getClassLoader().getResourceAsStream("GrokAssembly.exe");
            byte[] buff = new byte[4096];
            int bread = -1;
            while ((bread = is.read(buff)) >= 0) {
                fos.write(buff, 0, bread);
            }
            this.grokAssemblyExe = tempFile;
            this.grokAssemblyExe.deleteOnExit();
            LOGGER.log(Level.FINE, "analyzer.AssemblyAnalyzer.grokassembly.deployed", this.grokAssemblyExe.getPath());
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "analyzer.AssemblyAnalyzer.grokassembly.notdeployed", ioe.getMessage());
            throw new AnalysisException("Could not extract GrokAssembly.exe", ioe);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable e) {
                    LOGGER.fine("Error closing output stream");
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {
                    LOGGER.fine("Error closing input stream");
                }
            }
        }
        List<String> args = this.buildArgumentList();
        BufferedReader rdr = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(args);
            Process p = pb.start();
            rdr = new BufferedReader(new InputStreamReader(p.getErrorStream(), "UTF-8"));
            while (rdr.ready() && rdr.readLine() != null) {
            }
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(p.getInputStream());
            XPath xpath = XPathFactory.newInstance().newXPath();
            String error = xpath.evaluate("/assembly/error", doc);
            if (p.waitFor() != 1 || error == null || "".equals(error)) {
                LOGGER.warning("An error occurred with the .NET AssemblyAnalyzer, please see the log for more details.");
                LOGGER.fine("GrokAssembly.exe is not working properly");
                this.grokAssemblyExe = null;
                throw new AnalysisException("Could not execute .NET AssemblyAnalyzer");
            }
        }
        catch (Throwable e) {
            if (e instanceof AnalysisException) {
                throw (AnalysisException)e;
            }
            LOGGER.warning("analyzer.AssemblyAnalyzer.grokassembly.initialization.failed");
            LOGGER.log(Level.FINE, "analyzer.AssemblyAnalyzer.grokassembly.initialization.message", e.getMessage());
            throw new AnalysisException("An error occured with the .NET AssemblyAnalyzer", e);
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, "ignore", ex);
                }
            }
        }
        this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    @Override
    public void close() throws Exception {
        super.close();
        try {
            if (this.grokAssemblyExe != null && !this.grokAssemblyExe.delete()) {
                this.grokAssemblyExe.deleteOnExit();
            }
        }
        catch (SecurityException se) {
            LOGGER.fine("analyzer.AssemblyAnalyzer.grokassembly.notdeleted");
        }
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return SUPPORTED_EXTENSIONS;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.assembly.enabled";
    }
}

