/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;

public class NvdCveAnalyzer
implements Analyzer {
    static final int MAX_QUERY_RESULTS = 100;
    private CveDB cveDB;

    public void open() throws SQLException, IOException, DatabaseException, ClassNotFoundException {
        this.cveDB = new CveDB();
        this.cveDB.open();
    }

    @Override
    public void close() {
        this.cveDB.close();
        this.cveDB = null;
    }

    public boolean isOpen() {
        return this.cveDB != null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.isOpen()) {
            this.close();
        }
    }

    @Override
    public void analyze(Dependency dependency, Engine engine) throws AnalysisException {
        for (Identifier id : dependency.getIdentifiers()) {
            if (!"cpe".equals(id.getType())) continue;
            try {
                String value = id.getValue();
                List<Vulnerability> vulns = this.cveDB.getVulnerabilities(value);
                dependency.getVulnerabilities().addAll(vulns);
            }
            catch (DatabaseException ex) {
                throw new AnalysisException(ex);
            }
        }
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public String getName() {
        return "NVD CVE Analyzer";
    }

    @Override
    public boolean supportsExtension(String extension) {
        return true;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINDING_ANALYSIS;
    }

    @Override
    public void initialize() throws Exception {
        this.open();
    }
}

