/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.ArchiveExtractionException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.Settings;

public class ArchiveAnalyzer
extends AbstractAnalyzer
implements Analyzer {
    private static final int BUFFER_SIZE = 4096;
    private static int dirCount = 0;
    private File tempFileLocation = null;
    private static final int MAX_SCAN_DEPTH = Settings.getInt("archive.scan.depth", 3);
    private int scanDepth = 0;
    private static final String ANALYZER_NAME = "Archive Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INITIAL;
    private static final Set<String> ZIPPABLES = ArchiveAnalyzer.newHashSet("zip", "ear", "war", "nupkg");
    private static final Set<String> EXTENSIONS = ArchiveAnalyzer.newHashSet("tar", "gz", "tgz");

    @Override
    public Set<String> getSupportedExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return EXTENSIONS.contains(extension);
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    public void initialize() throws Exception {
        File baseDir = Settings.getTempDirectory();
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            String msg = String.format("Unable to make a temporary folder '%s'", baseDir.getPath());
            throw new AnalysisException(msg);
        }
        this.tempFileLocation = File.createTempFile("check", "tmp", baseDir);
        if (!this.tempFileLocation.delete()) {
            String msg = String.format("Unable to delete temporary file '%s'.", this.tempFileLocation.getAbsolutePath());
            throw new AnalysisException(msg);
        }
        if (!this.tempFileLocation.mkdirs()) {
            String msg = String.format("Unable to create directory '%s'.", this.tempFileLocation.getAbsolutePath());
            throw new AnalysisException(msg);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.tempFileLocation != null && this.tempFileLocation.exists()) {
            Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINE, "Attempting to delete temporary files");
            boolean success = FileUtils.delete(this.tempFileLocation);
            if (!success) {
                Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.WARNING, "Failed to delete some temporary files, see the log for more details");
            }
        }
    }

    @Override
    public void analyze(Dependency dependency, Engine engine) throws AnalysisException {
        File f = new File(dependency.getActualFilePath());
        File tmpDir = this.getNextTempDirectory();
        this.extractFiles(f, tmpDir, engine);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(engine.getDependencies());
        engine.scan(tmpDir);
        List<Dependency> newDependencies = engine.getDependencies();
        if (dependencies.size() != newDependencies.size()) {
            HashSet<Dependency> dependencySet = new HashSet<Dependency>();
            dependencySet.addAll(newDependencies);
            dependencySet.removeAll(dependencies);
            for (Dependency d : dependencySet) {
                String displayPath = String.format("%s%s", dependency.getFilePath(), d.getActualFilePath().substring(tmpDir.getAbsolutePath().length()));
                String displayName = String.format("%s%s%s", dependency.getFileName(), File.separator, d.getFileName());
                d.setFilePath(displayPath);
                d.setFileName(displayName);
                if (!this.supportsExtension(d.getFileExtension()) || this.scanDepth >= MAX_SCAN_DEPTH) continue;
                ++this.scanDepth;
                this.analyze(d, engine);
                --this.scanDepth;
            }
        }
        Collections.sort(engine.getDependencies());
    }

    private File getNextTempDirectory() throws AnalysisException {
        File directory;
        if ((directory = new File(this.tempFileLocation, String.valueOf(++dirCount))).exists()) {
            return this.getNextTempDirectory();
        }
        if (!directory.mkdirs()) {
            String msg = String.format("Unable to create temp directory '%s'.", directory.getAbsolutePath());
            throw new AnalysisException(msg);
        }
        return directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFiles(File archive, File destination, Engine engine) throws AnalysisException {
        if (archive == null || destination == null) {
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(archive);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINE, null, ex);
            throw new AnalysisException("Archive file was not found.", ex);
        }
        String archiveExt = FileUtils.getFileExtension(archive.getName()).toLowerCase();
        try {
            String uncompressedName;
            String uncompressedExt;
            if (ZIPPABLES.contains(archiveExt)) {
                this.extractArchive(new ZipArchiveInputStream(new BufferedInputStream(fis)), destination, engine);
            } else if ("tar".equals(archiveExt)) {
                this.extractArchive(new TarArchiveInputStream(new BufferedInputStream(fis)), destination, engine);
            } else if (("gz".equals(archiveExt) || "tgz".equals(archiveExt)) && engine.supportsExtension(uncompressedExt = FileUtils.getFileExtension(uncompressedName = GzipUtils.getUncompressedFilename(archive.getName())).toLowerCase())) {
                this.decompressFile(new GzipCompressorInputStream(new BufferedInputStream(fis)), new File(destination, uncompressedName));
            }
        }
        catch (ArchiveExtractionException ex) {
            String msg = String.format("Exception extracting archive '%s'.", archive.getName());
            Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.WARNING, msg);
            Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINE, null, ex);
        }
        catch (IOException ex) {
            String msg = String.format("Exception reading archive '%s'.", archive.getName());
            Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.WARNING, msg);
            Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINE, null, ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINEST, null, ex);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractArchive(ArchiveInputStream input, File destination, Engine engine) throws ArchiveExtractionException {
        try {
            ArchiveEntry entry;
            while ((entry = input.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File d = new File(destination, entry.getName());
                    if (d.exists() || d.mkdirs()) continue;
                    String msg = String.format("Unable to create directory '%s'.", d.getAbsolutePath());
                    throw new AnalysisException(msg);
                }
                File file = new File(destination, entry.getName());
                String ext = FileUtils.getFileExtension(file.getName());
                if (!engine.supportsExtension(ext)) continue;
                FilterOutputStream bos = null;
                try {
                    int count;
                    File parent = file.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        String msg = String.format("Unable to build directory '%s'.", parent.getAbsolutePath());
                        throw new AnalysisException(msg);
                    }
                    FileOutputStream fos = new FileOutputStream(file);
                    bos = new BufferedOutputStream(fos, 4096);
                    byte[] data = new byte[4096];
                    while ((count = input.read(data, 0, 4096)) != -1) {
                        ((BufferedOutputStream)bos).write(data, 0, count);
                    }
                    ((BufferedOutputStream)bos).flush();
                    if (bos == null) continue;
                }
                catch (FileNotFoundException ex) {
                    try {
                        Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINE, null, ex);
                        String msg = String.format("Unable to find file '%s'.", file.getName());
                        throw new AnalysisException(msg, ex);
                        catch (IOException ex2) {
                            Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINE, null, ex2);
                            msg = String.format("IO Exception while parsing file '%s'.", file.getName());
                            throw new AnalysisException(msg, ex2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (bos == null) throw throwable;
                        try {
                            bos.close();
                            throw throwable;
                        }
                        catch (IOException ex3) {
                            Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINEST, null, ex3);
                        }
                        throw throwable;
                    }
                }
                try {
                    bos.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINEST, null, ex);
                }
            }
            return;
        }
        catch (IOException ex) {
            throw new ArchiveExtractionException(ex);
        }
        catch (Throwable ex) {
            throw new ArchiveExtractionException(ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINEST, null, ex);
                }
            }
        }
    }

    private void decompressFile(CompressorInputStream inputStream, File outputFile) throws ArchiveExtractionException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputFile);
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = inputStream.read(buffer))) {
                out.write(buffer, 0, n);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINE, null, ex);
            throw new ArchiveExtractionException(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINE, null, ex);
            throw new ArchiveExtractionException(ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ArchiveAnalyzer.class.getName()).log(Level.FINEST, null, ex);
                }
            }
        }
    }

    static {
        String additionalZipExt = Settings.getString("extensions.zip");
        if (additionalZipExt != null) {
            HashSet<String> ext = new HashSet<String>(Arrays.asList(additionalZipExt));
            ZIPPABLES.addAll(ext);
        }
        EXTENSIONS.addAll(ZIPPABLES);
    }
}

