/**
 * EasyBeans
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IFramework.java 3315 2008-05-26 11:24:41Z eyindanga $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.maven.osgi.launcher.api;

import java.io.File;
import java.net.URL;

import org.osgi.framework.BundleContext;

/**
 * Interface that needs to be implemented for the implementation in the framework.
 * @author Florent BENOIT
 */
public interface IFramework {

    /**
     * Configure the Felix gateway by using the given configuration file.
     * @param config the URL of the configuration file to use
     * @throws FrameworkException if the configuration is not done
     */
    void configure(final URL config) throws FrameworkException;

    /**
     * Start the framework.
     * @throws FrameworkException if the framework can't be started.
     */
    void start() throws FrameworkException;

    /**
     * Gets the bundle context of the framework.
     * @return the bundle context allowing to do some operations.
     */
    BundleContext getBundleContext();

    /**
     * Checks if the framework is running.
     * @return true if the framework is running
     */
    boolean isRunning();

    /**
     * Stop the framework.
     * @throws FrameworkException if the framework can't be stopped.
     */
    void stop() throws FrameworkException;

    /**
     * Sets the working directory.
     * @param workingDirectory the given directory used to store some files.
     */
    void setWorkingDirectory(final File workingDirectory);

}
