/**
 * Copyright 2007-2012 Bull S.A.S.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.util.ant.archive.info;

import java.util.List;

import org.ow2.util.ant.archive.Client;
import org.ow2.util.ant.archive.Ejb;
import org.ow2.util.ant.archive.War;

/**
 * Class that holds information about an EAR archive.
 * @author Florent Benoit
 */
public class EarInfo extends ArchiveInfo {

    /**
     * List of War to package in this EAR.
     */
    private List<War> wars = null;

    /**
     * List of EJB to package in this EAR.
     */
    private List<Ejb> ejbs = null;

    /**
     * List of Application Client to package in this EAR.
     */
    private List<Client> clients = null;

    /**
     * @return the list of EJBs modules
     */
    public List<Ejb> getEjbs() {
        return this.ejbs;
    }

    /**
     * Sets the list of EJB modules.
     * @param ejbs the list of EJBs modules
     */
    public void setEjbs(final List<Ejb> ejbs) {
        this.ejbs = ejbs;
    }

    /**
     * Sets the list of WAR modules.
     * @param wars the list of Wars modules
     */
    public void setWars(final List<War> wars) {
        this.wars = wars;
    }

    /**
     * @return the list of WARs modules
     */
    public List<War> getWars() {
        return this.wars;
    }

    /**
     * @return the clients
     */
    public List<Client> getClients() {
        return this.clients;
    }

    /**
     * @param clients the clients to set
     */
    public void setClients(final List<Client> clients) {
        this.clients = clients;
    }


}
