/*
 * Kerneos
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine AT ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id$
 */
package org.ow2.kerneos.core.api.event {
import com.adobe.cairngorm.control.CairngormEvent;

import org.ow2.kerneos.core.api.IFragmentView;


/**
 * @author Loic Albertin
 */
public class ModuleFragmentEvent extends CairngormEvent{

    private var _fragmentView:IFragmentView;

    public static const FRAGMENT_VIEW_ARRIVAL:String = "ModuleFragmentEvent_FragmentViewArrival";
    public static const FRAGMENT_VIEW_DEPARTURE:String = "ModuleFragmentEvent_FragmentViewDeparture";


    public function ModuleFragmentEvent(type:String,  fragmentView:IFragmentView) {
        super(type);
        _fragmentView = fragmentView;
    }


    public function get fragmentView():IFragmentView {
        return _fragmentView;
    }
}
}
