/*
 * Kerneos
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine AT ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id$
 */
package org.ow2.kerneos.core.api {

import com.adobe.cairngorm.business.ServiceLocator;
import com.adobe.cairngorm.control.CairngormEventDispatcher;

import flash.events.Event;

import mx.core.mx_internal;

import org.ow2.kerneos.common.vo.ModuleFragmentVO;

import spark.modules.Module;

use namespace mx_internal;

[Event(name="open", type="flash.events.Event")]
[Event(name="close", type="flash.events.Event")]
public class KerneosModuleFragment extends Module {


    private var __parentKerneosModule:KerneosModule;
    private var __configuration:ModuleFragmentVO;
    private var __serviceLocator:ServiceLocator;
    private var dispatcher:CairngormEventDispatcher;

    public function KerneosModuleFragment() {
        __serviceLocator = new ServiceLocator();
        dispatcher = new CairngormEventDispatcher();
    }

    public function getConfiguration():ModuleFragmentVO {
        return __configuration;
    }

    public function getServices():ServiceLocator {
        return __serviceLocator;
    }

    public function getDispatcher():CairngormEventDispatcher {
        return dispatcher;
    }

    public function getParentKerneosModule():KerneosModule {
        return __parentKerneosModule;
    }

    /////////////////////////
    /// INTERNAL USE ONLY ///
    /////////////////////////

    mx_internal function openModuleFragment():void {
        dispatchEvent(new Event("open"));
    }


    mx_internal function closeModuleFragment():void {
        dispatchEvent(new Event("close"));
    }

    mx_internal function setConfiguration(configuration:ModuleFragmentVO):void {
        __configuration = configuration;
    }

    mx_internal function setParentModule(parentKerneosModule:KerneosModule):void {
        __parentKerneosModule = parentKerneosModule;
    }
}
}
