/*
 * Kerneos
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine AT ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id$
 */
package org.ow2.kerneos.core.api {
import flash.display.IBitmapDrawable;
import flash.events.IEventDispatcher;

import mx.automation.IAutomationObject;
import mx.core.IChildList;
import mx.core.IConstraintClient;
import mx.core.IDeferredInstantiationUIComponent;
import mx.core.IFlexDisplayObject;
import mx.core.IFlexModule;
import mx.core.IInvalidating;
import mx.core.IPropertyChangeNotifier;
import mx.core.IRepeaterClient;
import mx.core.IStateClient;
import mx.core.IUIComponent;
import mx.core.IVisualElement;
import mx.core.IVisualElementContainer;
import mx.managers.ILayoutManagerClient;
import mx.managers.IToolTipManagerClient;
import mx.styles.IAdvancedStyleClient;
import mx.validators.IValidatorListener;

import org.ow2.kerneos.common.vo.ModuleFragmentVO;

import spark.core.IGraphicElementContainer;
import spark.core.ISharedDisplayObject;
import spark.core.IViewport;

[Event(name="loadingStateChanged", type="flash.events.Event")]
public interface IFragmentView extends IVisualElementContainer, IGraphicElementContainer, ISharedDisplayObject,
        IViewport, IAutomationObject, IChildList, IConstraintClient, IDeferredInstantiationUIComponent,
        IFlexDisplayObject, IFlexModule, IInvalidating, ILayoutManagerClient, IPropertyChangeNotifier, IRepeaterClient,
        IStateClient, IAdvancedStyleClient, IToolTipManagerClient, IUIComponent, IValidatorListener, IVisualElement,
        IBitmapDrawable, IEventDispatcher {

    /**
     * Get the current loading state of the fragment view
     * @return the current loading state of the fragment view.
     * @see FragmentViewState
     */
    function getLoadingState():String;

    /**
     * Get the KerneosModuleFragment object associated with this SwfModule
     * @return null if there is no KerneosModuleFragment
     */
    function getKerneosModuleFragment():KerneosModuleFragment;

    /**
     * Get the ModuleFragment configuration
     * @return The module fragment configuration
     */
    function getModuleFragmentConfiguration():ModuleFragmentVO;
}
}
