/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.tools.rest.jms;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;

public class RestClientContext {
    private String clientId;
    private ConnectionFactory cf;
    private JMSContext jmsContext;
    private List<String> sessionCtxNames;
    private long lastActivity = 0L;
    private long idleTimeout = -1L;

    public RestClientContext(String clientId) {
        this.clientId = clientId;
        this.sessionCtxNames = new ArrayList<String>();
        this.lastActivity = System.currentTimeMillis();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.cf;
    }

    public void setConnectionFactory(ConnectionFactory cf) {
        this.cf = cf;
    }

    public JMSContext getJmsContext() {
        return this.jmsContext;
    }

    public void setJmsContext(JMSContext jmsContext) {
        this.jmsContext = jmsContext;
    }

    public String getClientId() {
        return this.clientId;
    }

    public List<String> getSessionCtxNames() {
        return this.sessionCtxNames;
    }

    public boolean addSessionCtxNames(String ctxName) {
        return this.sessionCtxNames.add(ctxName);
    }

    public boolean removeSessionCtxNames(String ctxName) {
        return this.sessionCtxNames.remove(ctxName);
    }

    public boolean isSessionCtxNamesEmpty() {
        return this.sessionCtxNames.isEmpty();
    }

    public synchronized void setLastActivity(long activityTime) {
        this.lastActivity = activityTime;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout * 1000L;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RestClientContext [clientId=").append(this.clientId).append(", lastActivity=").append(new Date(this.lastActivity)).append(", idleTimeout=").append(this.idleTimeout).append("]");
        return builder.toString();
    }
}

