/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.tools.rest.jms;

import fr.dyade.aaa.common.Debug;
import java.net.URI;
import javax.jms.Destination;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.Queue;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.objectweb.joram.tools.rest.jms.Helper;
import org.objectweb.joram.tools.rest.jms.JmsContextService;
import org.objectweb.joram.tools.rest.jms.SessionContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

@Path(value="/jndi")
public class JndiService {
    public static Logger logger = Debug.getLogger((String)JndiService.class.getName());
    private final Helper helper = Helper.getInstance();
    public static final String JNDI = "jndi";

    @GET
    @Produces(value={"text/html"})
    public String info(@Context UriInfo uriInfo) {
        StringBuilder buff = new StringBuilder();
        buff.append("<html>");
        buff.append("<body>");
        buff.append("<h3>lookup (HEAD)</h3>");
        buff.append("<pre>");
        buff.append("set a destination-name: " + uriInfo.getAbsolutePathBuilder() + "/{<b>destination-name</b>}");
        buff.append("</pre>");
        buff.append("<h3>create a producer (POST)</h3>");
        buff.append("<pre>");
        buff.append(uriInfo.getAbsolutePathBuilder() + "/{<b>destination-name</b>}/" + "create-producer");
        buff.append("\n<b>Be careful, you needs to specify a content type with application/x-www-form-urlencoded.</b>");
        buff.append("\n<b>options:</b>");
        buff.append("\n  <b>client-id:</b> The client identifier for the JMSContext's connection");
        buff.append("\n  <b>name:</b> The producer name for the producer JMSContext");
        buff.append("\n  <b>session-mode:</b> AUTO_ACKNOWLEDGE, CLIENT_ACKNOWLEDGE,  DUPS_OK_ACKNOWLEDGE or SESSION_TRANSACTED");
        buff.append("\n  <b>persistent:</b> Specifies the delivery mode of messages that are sent using this JMSProducer");
        buff.append("\n  <b>delivery-delay:</b> Sets the minimum length of time in milliseconds that must elapse after a message is sent before\n     the JMS provider may deliver the message to a consumer");
        buff.append("\n  <b>correlation-id:</b> Specifies that messages sent using this JMSProducer will have their JMSCorrelationID header value\n     set to the specified correlation ID");
        buff.append("\n  <b>priority:</b> Specifies the priority of messages that are sent using this JMSProducer");
        buff.append("\n  <b>time-to-live:</b> Specifies the time to live of messages that are sent using this JMSProducer");
        buff.append("\n  <b>idle-timeout:</b> Allows to set the idle time in seconds in which the producer context will be closed if idle");
        buff.append("\n  <b>user:</b> Specifies the userName for the JMS connection. This parameter is now deprecated, you should use a form\n     parameter instead.");
        buff.append("\n  <b>password:</b> Specifies the password for the JMS connection. This parameter is now deprecated, you should use a\n     form parameter instead.");
        buff.append("</pre>");
        buff.append("<h3>create a consumer (POST)</h3>");
        buff.append("<pre>");
        buff.append(uriInfo.getAbsolutePathBuilder() + "/{<b>destination-name</b>}/" + "create-consumer");
        buff.append("\n<b>Be careful, you needs to specify a content type with application/x-www-form-urlencoded.</b>");
        buff.append("\n<b>options:</b>");
        buff.append("\n  <b>client-id:</b> The client identifier for the JMSContext's connection");
        buff.append("\n  <b>name:</b> The producer name for the producer JMSContext");
        buff.append("\n  <b>session-mode:</b> AUTO_ACKNOWLEDGE, CLIENT_ACKNOWLEDGE,  DUPS_OK_ACKNOWLEDGE or SESSION_TRANSACTED");
        buff.append("\n  <b>selector:</b> Only messages with properties matching the message selector expression are delivered");
        buff.append("\n  <b>durable:</b> true to creates an durable subscription on the specified topic");
        buff.append("\n  <b>shared:</b> true for shared");
        buff.append("\n  <b>sub-name:</b> the name used to identify this subscription");
        buff.append("\n  <b>idle-timeout:</b> Allows to set the idle time in seconds in which the consumer context will be closed if idle");
        buff.append("\n  <b>user:</b> Specifies the userName for the JMS connection");
        buff.append("\n  <b>password:</b> Specifies the password for the JMS connection");
        buff.append("</pre>");
        buff.append("<h3>close a producer or a consumer (DELETE)</h3>");
        buff.append("<pre>");
        buff.append(uriInfo.getAbsolutePathBuilder() + "/{<b>name</b>}");
        buff.append("</pre>");
        buff.append("</body>");
        buff.append("</html>");
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HEAD
    @Path(value="/{destName}")
    @Produces(value={"text/plain"})
    public synchronized Response lookupDestination(@Context HttpHeaders headers, @PathParam(value="destName") String destName, @Context UriInfo uriInfo) {
        if (JndiService.logger.isLoggable(BasicLevel.INFO)) {
            JndiService.logger.log(BasicLevel.INFO, "HEAD: " + uriInfo.getAbsolutePathBuilder());
        }
        if (JndiService.logger.isLoggable(BasicLevel.DEBUG)) {
            JndiService.logger.log(BasicLevel.DEBUG, "lookupDestination(" + headers + ", " + destName + ", " + uriInfo + ")");
        }
        builder = null;
        try {
            if (this.helper.lookupDestination(destName) != null) ** GOTO lbl-1000
            builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            nextBuilder = uriInfo.getAbsolutePathBuilder();
            next = nextBuilder.build(new Object[0]);
            builder.link(next, "lookup");
            var7_11 = builder.build();
            ** GOTO lbl22
        }
        catch (Exception e) {
            block8: {
                if (JndiService.logger.isLoggable(BasicLevel.WARN)) {
                    JndiService.logger.log(BasicLevel.WARN, "", (Throwable)e);
                }
                break block8;
                catch (Throwable var9_14) {
                    JmsContextService.logLinks(builder);
                    throw var9_14;
                }
lbl22:
                // 1 sources

                JmsContextService.logLinks(builder);
                return var7_11;
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage());
            nextBuilder = uriInfo.getAbsolutePathBuilder();
            next = nextBuilder.build(new Object[0]);
            builder.link(next, "lookup");
            var8_13 = builder.build();
            JmsContextService.logLinks(builder);
            return var8_13;
        }
lbl-1000:
        // 1 sources

        {
            builder = Response.status((Response.Status)Response.Status.CREATED);
            nextBuilder = uriInfo.getAbsolutePathBuilder().path("create-producer");
            builder.link(nextBuilder.build(new Object[0]), "create-producer");
            nextBuilder = uriInfo.getAbsolutePathBuilder().path("create-producer");
            nextBuilder.queryParam("session-mode", new Object[]{3});
            builder.link(nextBuilder.build(new Object[0]), "create-producer-dups-ok");
            nextBuilder = uriInfo.getAbsolutePathBuilder().path("create-producer");
            nextBuilder.queryParam("session-mode", new Object[]{0});
            builder.link(nextBuilder.build(new Object[0]), "create-producer-transacted");
            nextBuilder = uriInfo.getAbsolutePathBuilder().path("create-consumer");
            builder.link(nextBuilder.build(new Object[0]), "create-consumer");
            nextBuilder = uriInfo.getAbsolutePathBuilder().path("create-consumer");
            nextBuilder.queryParam("session-mode", new Object[]{3});
            builder.link(nextBuilder.build(new Object[0]), "create-consumer-dups-ok");
            nextBuilder = uriInfo.getAbsolutePathBuilder().path("create-consumer");
            nextBuilder.queryParam("session-mode", new Object[]{2});
            builder.link(nextBuilder.build(new Object[0]), "create-consumer-client-ack");
            nextBuilder = uriInfo.getAbsolutePathBuilder().path("create-consumer");
            nextBuilder.queryParam("session-mode", new Object[]{0});
            builder.link(nextBuilder.build(new Object[0]), "create-consumer-transacted");
            nextBuilder = uriInfo.getAbsolutePathBuilder().path("create-producer-fp");
            builder.link(nextBuilder.build(new Object[0]), "create-producer-fp");
            nextBuilder = uriInfo.getAbsolutePathBuilder().path("create-producer-fp");
            nextBuilder.queryParam("session-mode", new Object[]{3});
            builder.link(nextBuilder.build(new Object[0]), "create-producer-fp-dups-ok");
            nextBuilder = uriInfo.getAbsolutePathBuilder().path("create-producer-fp");
            nextBuilder.queryParam("session-mode", new Object[]{0});
            builder.link(nextBuilder.build(new Object[0]), "create-producer-fp-transacted");
            nextBuilder = uriInfo.getAbsolutePathBuilder().path("create-consumer-fp");
            builder.link(nextBuilder.build(new Object[0]), "create-consumer-fp");
            nextBuilder = uriInfo.getAbsolutePathBuilder().path("create-consumer-fp");
            nextBuilder.queryParam("session-mode", new Object[]{3});
            builder.link(nextBuilder.build(new Object[0]), "create-consumer-fp-dups-ok");
            nextBuilder = uriInfo.getAbsolutePathBuilder().path("create-consumer-fp");
            nextBuilder.queryParam("session-mode", new Object[]{2});
            builder.link(nextBuilder.build(new Object[0]), "create-consumer-fp-client-ack");
            nextBuilder = uriInfo.getAbsolutePathBuilder().path("create-consumer-fp");
            nextBuilder.queryParam("session-mode", new Object[]{0});
            builder.link(nextBuilder.build(new Object[0]), "create-consumer-fp-transacted");
            nextBuilder = uriInfo.getAbsolutePathBuilder();
            builder.link(nextBuilder.build(new Object[0]), "lookup");
            var6_10 = builder.build();
        }
        JmsContextService.logLinks(builder);
        return var6_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{destName}/create-producer")
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    @Deprecated
    public Response createProducerOld(@Context HttpHeaders headers, @PathParam(value="destName") String destName, @QueryParam(value="client-id") String clientID, @QueryParam(value="name") String prodName, @DefaultValue(value="1") @QueryParam(value="session-mode") int sessionMode, @DefaultValue(value="2") @QueryParam(value="persistent") int deliveryMode, @DefaultValue(value="0") @QueryParam(value="delivery-delay") long deliveryDelay, @QueryParam(value="correlation-id") String correlationID, @DefaultValue(value="4") @QueryParam(value="priority") int priority, @DefaultValue(value="0") @QueryParam(value="time-to-live") long timeToLive, @DefaultValue(value="0") @QueryParam(value="idle-timeout") long idleTimeout, @QueryParam(value="user") String userName, @QueryParam(value="password") String password, @Context UriInfo uriInfo) {
        String prodId;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, "POST: " + uriInfo.getAbsolutePathBuilder());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "createProducer(" + headers + ", " + destName + ", " + clientID + ", " + prodName + ", " + sessionMode + ", " + deliveryMode + ", " + deliveryDelay + ", " + correlationID + ", " + priority + ", " + timeToLive + ", " + idleTimeout + ", " + userName + ", " + uriInfo + ")");
        }
        Response.ResponseBuilder builder = null;
        try {
            prodId = null;
            try {
                Destination dest = this.helper.lookupDestination(destName);
                prodId = this.helper.createProducer(userName, password, clientID, prodName, dest, sessionMode, deliveryMode, deliveryDelay, correlationID, priority, timeToLive, destName, dest instanceof Queue, idleTimeout);
            }
            catch (Exception e) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, "", (Throwable)e);
                }
                builder = e instanceof JMSSecurityRuntimeException ? Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.toString()) : Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
                Response response = builder.build();
                JmsContextService.logLinks(builder);
                return response;
            }
        }
        catch (Throwable throwable) {
            JmsContextService.logLinks(builder);
            throw throwable;
        }
        builder = Response.status((Response.Status)Response.Status.CREATED);
        UriBuilder nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId);
        builder.link(nextBuilder.build(new Object[0]), "send-message");
        SessionContext prodCtx = this.helper.getSessionCtx(prodId);
        long id = prodCtx.getLastId() + 1L;
        nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId).path("" + id);
        builder.link(nextBuilder.build(new Object[0]), "send-next-message");
        nextBuilder = UriBuilder.fromPath((String)uriInfo.getBaseUri().toString()).path("jms").path(prodId);
        builder.link(nextBuilder.build(new Object[0]), "close-context");
        if (prodCtx.getJmsContext().getTransacted()) {
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId).path("commit");
            builder.link(nextBuilder.build(new Object[0]), "commit");
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId).path("rollback");
            builder.link(nextBuilder.build(new Object[0]), "rollback");
        }
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{destName}/create-consumer")
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    @Deprecated
    public Response createConsumerOld(@Context HttpHeaders headers, @PathParam(value="destName") String destName, @QueryParam(value="client-id") String clientID, @QueryParam(value="name") String consName, @DefaultValue(value="1") @QueryParam(value="session-mode") int sessionMode, @QueryParam(value="selector") String messageSelector, @DefaultValue(value="false") @QueryParam(value="no-local") boolean noLocal, @DefaultValue(value="false") @QueryParam(value="durable") boolean durable, @DefaultValue(value="false") @QueryParam(value="shared") boolean shared, @QueryParam(value="sub-name") String subName, @DefaultValue(value="0") @QueryParam(value="idle-timeout") long idleTimeout, @QueryParam(value="user") String userName, @QueryParam(value="password") String password, @Context UriInfo uriInfo) {
        String consId;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, "POST: " + uriInfo.getAbsolutePathBuilder());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "createConsumer(" + headers + ", " + destName + ", " + clientID + ", " + consName + ", " + sessionMode + ", " + messageSelector + ", " + noLocal + ", " + durable + ", " + shared + ", " + subName + ", " + idleTimeout + ", " + userName + ", " + uriInfo + ")");
        }
        Response.ResponseBuilder builder = null;
        try {
            consId = null;
            try {
                Destination dest = this.helper.lookupDestination(destName);
                consId = this.helper.createConsumer(userName, password, clientID, consName, dest, sessionMode, messageSelector, noLocal, durable, shared, subName, destName, dest instanceof Queue, idleTimeout);
            }
            catch (Exception e) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, "", (Throwable)e);
                }
                builder = e instanceof JMSSecurityRuntimeException ? Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.toString()) : Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
                Response response = builder.build();
                JmsContextService.logLinks(builder);
                return response;
            }
        }
        catch (Throwable throwable) {
            JmsContextService.logLinks(builder);
            throw throwable;
        }
        builder = Response.status((Response.Status)Response.Status.CREATED);
        UriBuilder nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId);
        builder.link(nextBuilder.build(new Object[0]), "receive-message");
        SessionContext consCtx = this.helper.getSessionCtx(consId);
        long id = consCtx.getLastId() + 1L;
        nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId).path("" + id);
        builder.link(nextBuilder.build(new Object[0]), "receive-next-message");
        nextBuilder = UriBuilder.fromPath((String)uriInfo.getBaseUri().toString()).path("jms").path(consId);
        builder.link(nextBuilder.build(new Object[0]), "close-context");
        if (consCtx.getJmsContext().getTransacted()) {
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId).path("commit");
            builder.link(nextBuilder.build(new Object[0]), "commit");
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId).path("rollback");
            builder.link(nextBuilder.build(new Object[0]), "rollback");
        }
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{destName}/create-producer-fp")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createProducer(@Context HttpHeaders headers, @PathParam(value="destName") String destName, @QueryParam(value="client-id") String clientID, @QueryParam(value="name") String prodName, @DefaultValue(value="1") @QueryParam(value="session-mode") int sessionMode, @DefaultValue(value="2") @QueryParam(value="persistent") int deliveryMode, @DefaultValue(value="0") @QueryParam(value="delivery-delay") long deliveryDelay, @QueryParam(value="correlation-id") String correlationID, @DefaultValue(value="4") @QueryParam(value="priority") int priority, @DefaultValue(value="0") @QueryParam(value="time-to-live") long timeToLive, @DefaultValue(value="0") @QueryParam(value="idle-timeout") long idleTimeout, @QueryParam(value="user") String userName, @QueryParam(value="password") String password, @FormParam(value="user") String userName2, @FormParam(value="password") String password2, @Context UriInfo uriInfo) {
        String prodId;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, "POST: " + uriInfo.getAbsolutePathBuilder());
        }
        if (userName2 != null) {
            if (userName != null) {
                logger.log(BasicLevel.WARN, "POST: overrides JMS identity from HTML body");
            }
            userName = userName2;
            password = password2;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "createProducer(" + headers + ", " + destName + ", " + clientID + ", " + prodName + ", " + sessionMode + ", " + deliveryMode + ", " + deliveryDelay + ", " + correlationID + ", " + priority + ", " + timeToLive + ", " + idleTimeout + ", " + userName + ", " + uriInfo + ")");
        }
        Response.ResponseBuilder builder = null;
        try {
            prodId = null;
            try {
                Destination dest = this.helper.lookupDestination(destName);
                prodId = this.helper.createProducer(userName, password, clientID, prodName, dest, sessionMode, deliveryMode, deliveryDelay, correlationID, priority, timeToLive, destName, dest instanceof Queue, idleTimeout);
            }
            catch (Exception e) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, "", (Throwable)e);
                }
                builder = e instanceof JMSSecurityRuntimeException ? Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.toString()) : Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
                Response response = builder.build();
                JmsContextService.logLinks(builder);
                return response;
            }
        }
        catch (Throwable throwable) {
            JmsContextService.logLinks(builder);
            throw throwable;
        }
        builder = Response.status((Response.Status)Response.Status.CREATED);
        UriBuilder nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId);
        builder.link(nextBuilder.build(new Object[0]), "send-message");
        SessionContext prodCtx = this.helper.getSessionCtx(prodId);
        long id = prodCtx.getLastId() + 1L;
        nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId).path("" + id);
        builder.link(nextBuilder.build(new Object[0]), "send-next-message");
        nextBuilder = UriBuilder.fromPath((String)uriInfo.getBaseUri().toString()).path("jms").path(prodId);
        builder.link(nextBuilder.build(new Object[0]), "close-context");
        if (prodCtx.getJmsContext().getTransacted()) {
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId).path("commit");
            builder.link(nextBuilder.build(new Object[0]), "commit");
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId).path("rollback");
            builder.link(nextBuilder.build(new Object[0]), "rollback");
        }
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{destName}/create-consumer-fp")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createConsumer(@Context HttpHeaders headers, @PathParam(value="destName") String destName, @QueryParam(value="client-id") String clientID, @QueryParam(value="name") String consName, @DefaultValue(value="1") @QueryParam(value="session-mode") int sessionMode, @QueryParam(value="selector") String messageSelector, @DefaultValue(value="false") @QueryParam(value="no-local") boolean noLocal, @DefaultValue(value="false") @QueryParam(value="durable") boolean durable, @DefaultValue(value="false") @QueryParam(value="shared") boolean shared, @QueryParam(value="sub-name") String subName, @DefaultValue(value="0") @QueryParam(value="idle-timeout") long idleTimeout, @QueryParam(value="user") String userName, @QueryParam(value="password") String password, @FormParam(value="user") String userName2, @FormParam(value="password") String password2, @Context UriInfo uriInfo) {
        String consId;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, "POST: " + uriInfo.getAbsolutePathBuilder());
        }
        if (userName2 != null) {
            if (userName != null) {
                logger.log(BasicLevel.WARN, "POST: overrides JMS identity from HTML body");
            }
            userName = userName2;
            password = password2;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "createConsumer(" + headers + ", " + destName + ", " + clientID + ", " + consName + ", " + sessionMode + ", " + messageSelector + ", " + noLocal + ", " + durable + ", " + shared + ", " + subName + ", " + idleTimeout + ", " + userName + ", " + uriInfo + ")");
        }
        Response.ResponseBuilder builder = null;
        try {
            consId = null;
            try {
                Destination dest = this.helper.lookupDestination(destName);
                consId = this.helper.createConsumer(userName, password, clientID, consName, dest, sessionMode, messageSelector, noLocal, durable, shared, subName, destName, dest instanceof Queue, idleTimeout);
            }
            catch (Exception e) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, "", (Throwable)e);
                }
                builder = e instanceof JMSSecurityRuntimeException ? Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.toString()) : Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
                Response response = builder.build();
                JmsContextService.logLinks(builder);
                return response;
            }
        }
        catch (Throwable throwable) {
            JmsContextService.logLinks(builder);
            throw throwable;
        }
        builder = Response.status((Response.Status)Response.Status.CREATED);
        UriBuilder nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId);
        builder.link(nextBuilder.build(new Object[0]), "receive-message");
        SessionContext consCtx = this.helper.getSessionCtx(consId);
        long id = consCtx.getLastId() + 1L;
        nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId).path("" + id);
        builder.link(nextBuilder.build(new Object[0]), "receive-next-message");
        nextBuilder = UriBuilder.fromPath((String)uriInfo.getBaseUri().toString()).path("jms").path(consId);
        builder.link(nextBuilder.build(new Object[0]), "close-context");
        if (consCtx.getJmsContext().getTransacted()) {
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId).path("commit");
            builder.link(nextBuilder.build(new Object[0]), "commit");
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId).path("rollback");
            builder.link(nextBuilder.build(new Object[0]), "rollback");
        }
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{name}")
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public synchronized Response closeSessionCtx(@Context HttpHeaders headers, @PathParam(value="name") String ctxName, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        block9: {
            Response response;
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, "DELETE: " + uriInfo.getAbsolutePathBuilder());
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "closeSessionCtx(" + headers + ", " + ctxName + ", " + uriInfo + ")");
            }
            builder = null;
            try {
                if (ctxName != null) break block9;
                builder = Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).entity((Object)"The context name is null.");
                response = builder.build();
            }
            catch (Throwable throwable) {
                JmsContextService.logLinks(builder);
                throw throwable;
            }
            JmsContextService.logLinks(builder);
            return response;
        }
        try {
            this.helper.closeSessionCtx(ctxName);
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, "", (Throwable)e);
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
            Response response = builder.build();
            JmsContextService.logLinks(builder);
            return response;
        }
        builder = Response.status((Response.Status)Response.Status.OK);
        UriBuilder nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(JNDI);
        builder.link(nextBuilder.build(new Object[0]), JNDI);
        nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("jms");
        builder.link(nextBuilder.build(new Object[0]), "jms");
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }
}

