/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.tools.rest.jms;

import fr.dyade.aaa.common.Debug;
import java.io.IOException;
import java.net.URI;
import java.util.Base64;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.objectweb.joram.tools.rest.jms.Helper;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

@Path(value="/")
public class RootService
implements ContainerRequestFilter {
    public static Logger logger = Debug.getLogger((String)RootService.class.getName());
    private static final String AUTHORIZATION_PROPERTY = "Authorization";
    private static final String AUTHENTICATION_SCHEME = "Basic";
    private final Helper helper = Helper.getInstance();
    @Context
    private HttpServletRequest httpServletRequest;

    @GET
    @Produces(value={"text/html"})
    public String info(@Context UriInfo uriInfo) {
        URI jndiURI = uriInfo.getBaseUriBuilder().path("jndi").build(new Object[0]);
        URI jmsURI = uriInfo.getBaseUriBuilder().path("jms").build(new Object[0]);
        URI adminURI = uriInfo.getBaseUriBuilder().path("admin").build(new Object[0]);
        URI contextURI = uriInfo.getBaseUriBuilder().path("context").build(new Object[0]);
        return "<html><body><br><a href=\"" + jndiURI + "\">" + jndiURI + "</a><br><a href=\"" + jmsURI + "\">" + jmsURI + "</a><br><a href=\"" + adminURI + "\">" + adminURI + "</a><br><a href=\"" + contextURI + "\">" + contextURI + "</a></body></html>";
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!this.helper.authenticationRequired()) {
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, "no authentication.");
            }
            return;
        }
        if (this.httpServletRequest != null) {
            String remoteIpAddress = this.httpServletRequest.getRemoteAddr();
            if (remoteIpAddress != null && !this.helper.checkIPAddress(remoteIpAddress)) {
                Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"executives\"").entity((Object)"You cannot access this resource (IP not allowed)").build();
                requestContext.abortWith(response);
                return;
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "request from: " + remoteIpAddress);
            }
        }
        MultivaluedMap headers = requestContext.getHeaders();
        List authorization = (List)headers.get((Object)AUTHORIZATION_PROPERTY);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "authorization = " + authorization);
        }
        if (authorization == null) {
            Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"executives\"").entity((Object)"You cannot access this resource").build();
            requestContext.abortWith(response);
            return;
        }
        String encodedUserPassword = ((String)authorization.get(0)).replaceFirst("Basic ", "");
        String usernameAndPassword = new String(Base64.getDecoder().decode(encodedUserPassword));
        StringTokenizer tokenizer = new StringTokenizer(usernameAndPassword, ":");
        String username = null;
        String password = null;
        if (tokenizer.hasMoreTokens()) {
            username = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            password = tokenizer.nextToken();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "username = " + username);
        }
        if (this.helper.getRestUser().equals(username) && this.helper.getRestPass().equals(password)) {
            return;
        }
        if (logger.isLoggable(BasicLevel.WARN)) {
            logger.log(BasicLevel.WARN, "Bad authorization: " + username + ":" + password);
        }
        Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"executives\"").entity((Object)"You cannot access this resource").build();
        requestContext.abortWith(response);
    }
}

