/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.tools.rest.jms;

import fr.dyade.aaa.common.Debug;
import java.util.ArrayList;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.objectweb.joram.tools.rest.jms.Helper;
import org.objectweb.joram.tools.rest.jms.RestClientContext;
import org.objectweb.joram.tools.rest.jms.SessionContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ProducerContext
extends SessionContext {
    public static Logger logger = Debug.getLogger((String)ProducerContext.class.getName());
    private JMSProducer producer;
    private int dfltDeliveryMode;
    private String dfltCorrelationID = null;
    private int dfltPriority;
    private long dfltTimeToLive;
    private long dfltDeliveryDelay;
    private int sent = 0;

    public ProducerContext(RestClientContext clientCtx) {
        super(clientCtx);
    }

    public JMSProducer getProducer() {
        return this.producer;
    }

    public void setProducer(JMSProducer producer) {
        this.producer = producer;
    }

    public void setDefaultDeliveryMode(int deliveryMode) {
        this.dfltDeliveryMode = deliveryMode;
    }

    public void setDefaultJMSCorrelationID(String correlationID) {
        this.dfltCorrelationID = correlationID;
    }

    public void setDefaultPriority(int priority) {
        this.dfltPriority = priority;
    }

    public void setDefaultTimeToLive(long timeToLive) {
        this.dfltTimeToLive = timeToLive;
    }

    public void setDefaultDeliveryDelay(long deliveryDelay) {
        this.dfltDeliveryDelay = deliveryDelay;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Message createMessage(String type, Object jmsBody) throws Exception {
        TextMessage msg = null;
        if (type.equals(TextMessage.class.getSimpleName())) {
            if (!logger.isLoggable(BasicLevel.DEBUG)) return this.getJmsContext().createTextMessage((String)jmsBody);
            logger.log(BasicLevel.DEBUG, "send text message = " + jmsBody);
            return this.getJmsContext().createTextMessage((String)jmsBody);
        }
        if (type.equals(BytesMessage.class.getSimpleName())) {
            if (!(jmsBody instanceof ArrayList)) throw new Exception("BytesMessage: invalid jmsBody = " + jmsBody.getClass().getName());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "send bytes message");
            }
            msg = this.getJmsContext().createBytesMessage();
            byte[] bytes = new byte[((ArrayList)jmsBody).size()];
            for (int i = 0; i < ((ArrayList)jmsBody).size(); ++i) {
                Object value = ((ArrayList)jmsBody).get(i);
                bytes[i] = ((Number)value).byteValue();
            }
            ((BytesMessage)msg).writeBytes(bytes);
            ((BytesMessage)msg).reset();
            return msg;
        } else if (type.equals(MapMessage.class.getSimpleName())) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "send map message");
            }
            if (!(jmsBody instanceof Map)) throw new Exception("MapMessage: invalid jmsBody = " + jmsBody.getClass().getName());
            msg = this.getJmsContext().createMapMessage();
            Helper.setMapMessage((Map)jmsBody, (MapMessage)msg);
            return msg;
        } else {
            if (type.equals(ObjectMessage.class.getSimpleName())) {
                throw new Exception("type: " + type + ", not yet implemented");
            }
            if (!type.equals(StreamMessage.class.getSimpleName())) throw new Exception("Unknown message type: " + type);
            throw new Exception("type: " + type + ", not yet implemented");
        }
    }

    final void setJMSProperties(Message msg, Map<String, Object> jmsProps) throws JMSException {
        if (jmsProps != null) {
            block24: for (String key : jmsProps.keySet()) {
                Object value = null;
                try {
                    value = Helper.getValue(jmsProps, key);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.ERROR)) continue;
                    logger.log(BasicLevel.ERROR, "ignore set jms properties(" + key + ", " + value + ") : " + e.getMessage());
                    continue;
                }
                if (value == null) continue;
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, "set jms properties: " + key + ", value = " + value + ", " + value.getClass().getSimpleName());
                }
                switch (value.getClass().getSimpleName()) {
                    case "String": {
                        msg.setStringProperty(key, (String)value);
                        continue block24;
                    }
                    case "Boolean": {
                        msg.setBooleanProperty(key, ((Boolean)value).booleanValue());
                        continue block24;
                    }
                    case "Integer": {
                        msg.setIntProperty(key, ((Integer)value).intValue());
                        continue block24;
                    }
                    case "Long": {
                        msg.setLongProperty(key, ((Long)value).longValue());
                        continue block24;
                    }
                    case "Double": {
                        msg.setDoubleProperty(key, ((Double)value).doubleValue());
                        continue block24;
                    }
                    case "Float": {
                        msg.setFloatProperty(key, ((Float)value).floatValue());
                        continue block24;
                    }
                    case "Short": {
                        msg.setShortProperty(key, ((Short)value).shortValue());
                        continue block24;
                    }
                    case "Byte": {
                        msg.setByteProperty(key, ((Byte)value).byteValue());
                        continue block24;
                    }
                }
                try {
                    msg.setObjectProperty(key, value);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.ERROR)) continue;
                    logger.log(BasicLevel.ERROR, "ignore jms setObjectProperties(" + key + ", " + value + ") : " + e.getMessage());
                }
            }
        }
    }

    synchronized long send(String type, Map<String, Object> jmsHeaders, Map<String, Object> jmsProps, Object jmsBody, int deliveryMode, long deliveryDelay, int priority, long timeToLive, String correlationID) throws Exception {
        Message msg = this.createMessage(type, jmsBody);
        this.setJMSProperties(msg, jmsProps);
        if (jmsHeaders != null) {
            Object value;
            if (deliveryMode == -1) {
                try {
                    value = (Integer)Helper.getValue(jmsHeaders, "DeliveryMode");
                    if (value != null) {
                        deliveryMode = (Integer)value;
                    }
                }
                catch (Exception exc) {
                    logger.log(BasicLevel.WARN, "ProducerContext.send(); bad DeliveryMode value", (Throwable)exc);
                }
            }
            if (deliveryDelay == -1L) {
                try {
                    value = (Long)Helper.getValue(jmsHeaders, "DeliveryTime");
                    if (value != null) {
                        deliveryDelay = (Long)value;
                    }
                }
                catch (Exception exc) {
                    logger.log(BasicLevel.WARN, "ProducerContext.send(); bad DeliveryTime value", (Throwable)exc);
                }
            }
            if (priority == -1) {
                try {
                    value = (Integer)Helper.getValue(jmsHeaders, "Priority");
                    if (value != null) {
                        priority = (Integer)value;
                    }
                }
                catch (Exception exc) {
                    logger.log(BasicLevel.WARN, "ProducerContext.send(); bad Priority value", (Throwable)exc);
                }
            }
            if (timeToLive == -1L) {
                try {
                    value = (Long)Helper.getValue(jmsHeaders, "Expiration");
                    if (value != null) {
                        timeToLive = (Long)value;
                    }
                }
                catch (Exception exc) {
                    logger.log(BasicLevel.WARN, "ProducerContext.send(); bad Expiration value", (Throwable)exc);
                }
            }
            if (correlationID == null) {
                try {
                    value = (String)Helper.getValue(jmsHeaders, "CorrelationID");
                    if (value != null) {
                        correlationID = value;
                    }
                }
                catch (Exception exc) {
                    logger.log(BasicLevel.WARN, "ProducerContext.send(); bad CorrelationID value", (Throwable)exc);
                }
            }
        }
        if (correlationID == null) {
            correlationID = this.dfltCorrelationID;
        }
        if (correlationID != null) {
            msg.setJMSCorrelationID((String)correlationID);
        }
        if (deliveryMode == -1) {
            deliveryMode = this.dfltDeliveryMode;
        }
        if (deliveryDelay == -1L) {
            deliveryDelay = this.dfltDeliveryDelay;
        }
        if (priority == -1) {
            priority = this.dfltPriority;
        }
        if (timeToLive == -1L) {
            timeToLive = this.dfltTimeToLive;
        }
        this.getProducer().setDeliveryMode(deliveryMode).setPriority(priority).setDeliveryDelay(deliveryDelay).setTimeToLive(timeToLive).send(this.getDest(), msg);
        ++this.sent;
        this.incLastId();
        this.getClientCtx().setLastActivity(System.currentTimeMillis());
        return this.getLastId();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProducerContext [clientCtx=").append(this.getClientCtx().getClientId()).append(", dest=").append(this.getDest()).append(", lastId=").append(this.viewLastId()).append(", sent=").append(this.sent).append("]");
        return builder.toString();
    }
}

