/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.tools.rest.jms;

import fr.dyade.aaa.common.Debug;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class IPFilter {
    public static Logger logger = Debug.getLogger((String)IPFilter.class.getName());
    private ArrayList<Authorized> ipAlloweds = null;

    public IPFilter(String IPAllowedList) {
        if (IPAllowedList == null) {
            return;
        }
        if ((IPAllowedList = IPAllowedList.trim()).length() == 0) {
            return;
        }
        this.ipAlloweds = new ArrayList();
        StringTokenizer st = new StringTokenizer(IPAllowedList, ",");
        while (st.hasMoreTokens()) {
            String addr = st.nextToken().trim();
            String[] parts = addr.split("/");
            String ip = parts[0];
            int prefix = parts.length < 2 ? 0 : Integer.parseInt(parts[1]);
            Inet4Address a = null;
            try {
                a = (Inet4Address)InetAddress.getByName(ip);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            byte[] b = a.getAddress();
            this.ipAlloweds.add(new Authorized(addr, (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | (b[3] & 0xFF) << 0, ~((1 << 32 - prefix) - 1)));
        }
    }

    public boolean checkIpAllowed(String addr) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("IPFilter.checkIpAllowed address=" + addr + ", ipAlloweds=" + this.ipAlloweds));
        }
        if (this.ipAlloweds == null) {
            return true;
        }
        try {
            Inet4Address a = (Inet4Address)InetAddress.getByName(addr);
            if (a.isAnyLocalAddress() || a.isLoopbackAddress()) {
                return true;
            }
            if (NetworkInterface.getByInetAddress(a) != null) {
                return true;
            }
            byte[] b = a.getAddress();
            int ipInt = (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | (b[3] & 0xFF) << 0;
            for (Authorized authorized : this.ipAlloweds) {
                if ((authorized.ip & authorized.mask) != (ipInt & authorized.mask)) continue;
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("IPFilter.checkIpAllowed address " + addr + " authorized."));
                }
                return true;
            }
        }
        catch (Exception exc) {
            logger.log(BasicLevel.WARN, (Object)("IPFilter.checkIpAllowed " + addr), (Throwable)exc);
        }
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)("IPFilter.checkIpAllowed " + addr + " failed."));
        }
        return false;
    }

    class Authorized {
        String addr;
        int ip;
        int mask;

        public Authorized(String addr, int ip, int mask) {
            this.addr = addr;
            this.ip = ip;
            this.mask = mask;
        }

        public String toString() {
            return this.addr;
        }
    }
}

