/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.tools.rest.jms;

import fr.dyade.aaa.common.Debug;
import java.net.URI;
import javax.jms.JMSSecurityRuntimeException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.objectweb.joram.tools.rest.jms.Helper;
import org.objectweb.joram.tools.rest.jms.JmsContextService;
import org.objectweb.joram.tools.rest.jms.SessionContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

@Path(value="/jms")
public class JmsService {
    public static Logger logger = Debug.getLogger((String)JmsService.class.getName());
    private final Helper helper = Helper.getInstance();
    public static final String JMS = "jms";
    public static final String JMS_CREATE_PROD = "create-producer";
    public static final String JMS_CREATE_CONS = "create-consumer";
    public static final String JMS_CREATE_PROD_FP = "create-producer-fp";
    public static final String JMS_CREATE_CONS_FP = "create-consumer-fp";

    @GET
    @Produces(value={"text/html"})
    public String info(@Context UriInfo uriInfo) {
        StringBuilder buff = new StringBuilder();
        buff.append("<html>");
        buff.append("<body>");
        buff.append("<h3>create a producer (POST)</h3>");
        buff.append("<pre>");
        buff.append(uriInfo.getAbsolutePathBuilder() + "/[queue|topic]/{<b>destination-name</b>}/" + JMS_CREATE_PROD);
        buff.append("\n<b>Be careful, you needs to specify a content type with application/x-www-form-urlencoded.</b>");
        buff.append("\n<b>options:</b>");
        buff.append("\n  <b>client-id:</b> The client identifier for the JMSContext's connection");
        buff.append("\n  <b>name:</b> The producer name for the producer JMSContext");
        buff.append("\n  <b>session-mode:</b> AUTO_ACKNOWLEDGE, CLIENT_ACKNOWLEDGE,  DUPS_OK_ACKNOWLEDGE or SESSION_TRANSACTED");
        buff.append("\n  <b>persistent:</b> Specifies the delivery mode of messages that are sent using this JMSProducer");
        buff.append("\n  <b>delivery-delay:</b> Sets the minimum length of time in milliseconds that must elapse after a message is sent before\n     the JMS provider may deliver the message to a consumer");
        buff.append("\n  <b>correlation-id:</b> Specifies that messages sent using this JMSProducer will have their JMSCorrelationID header value\n     set to the specified correlation ID");
        buff.append("\n  <b>priority:</b> Specifies the priority of messages that are sent using this JMSProducer");
        buff.append("\n  <b>time-to-live:</b> Specifies the time to live of messages that are sent using this JMSProducer");
        buff.append("\n  <b>idle-timeout:</b> Allows to set the idle time in milliseconds in which the producer context will be closed if idle");
        buff.append("\n  <b>user:</b> Specifies the userName for the JMS connection. This parameter is deprecated, you should use a form parameter\n     instead.");
        buff.append("\n  <b>password:</b> Specifies the password for the JMS connection. This parameter is deprecated, you should use a form\n     parameter instead.");
        buff.append("</pre>");
        buff.append("<h3>create a consumer (POST)</h3>");
        buff.append("<pre>");
        buff.append(uriInfo.getAbsolutePathBuilder() + "/[queue|topic]/{<b>destination-name</b>}/" + JMS_CREATE_CONS);
        buff.append("\n<b>Be careful, you needs to specify a content type with application/x-www-form-urlencoded.</b>");
        buff.append("\n<b>options:</b>");
        buff.append("\n  <b>client-id:</b> The client identifier for the JMSContext's connection");
        buff.append("\n  <b>name:</b> The producer name for the producer JMSContext");
        buff.append("\n  <b>session-mode:</b> AUTO_ACKNOWLEDGE, CLIENT_ACKNOWLEDGE,  DUPS_OK_ACKNOWLEDGE or SESSION_TRANSACTED");
        buff.append("\n  <b>selector:</b> Only messages with properties matching the message selector expression are delivered");
        buff.append("\n  <b>durable:</b> true to creates an durable subscription on the specified topic");
        buff.append("\n  <b>shared:</b> true for shared");
        buff.append("\n  <b>sub-name:</b> the name used to identify this subscription");
        buff.append("\n  <b>idle-timeout:</b> Allows to set the idle time in milliseconds in which the consumer context will be closed if idle");
        buff.append("\n  <b>user:</b> Specifies the userName for the JMS connection. This parameter is deprecated, you should use a form parameter\n     instead.");
        buff.append("\n  <b>password:</b> Specifies the password for the JMS connection. This parameter is deprecated, you should use a form\n     parameter instead.");
        buff.append("</pre>");
        buff.append("<h3>close a producer or a consumer (DELETE)</h3>");
        buff.append("<pre>");
        buff.append(uriInfo.getAbsolutePathBuilder() + "/{<b>name</b>}");
        buff.append("</pre>");
        buff.append("</body>");
        buff.append("</html>");
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/topic/{destName}/create-producer")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createTopicProducer(@Context HttpHeaders headers, @PathParam(value="destName") String destName, @QueryParam(value="client-id") String clientID, @QueryParam(value="name") String prodName, @DefaultValue(value="1") @QueryParam(value="session-mode") int sessionMode, @DefaultValue(value="2") @QueryParam(value="persistent") int deliveryMode, @DefaultValue(value="0") @QueryParam(value="delivery-delay") long deliveryDelay, @QueryParam(value="correlation-id") String correlationID, @DefaultValue(value="4") @QueryParam(value="priority") int priority, @DefaultValue(value="0") @QueryParam(value="time-to-live") long timeToLive, @DefaultValue(value="0") @QueryParam(value="idle-timeout") long idleTimeout, @QueryParam(value="user") String userName, @QueryParam(value="password") String password, @FormParam(value="user") String userName2, @FormParam(value="password") String password2, @Context UriInfo uriInfo) {
        String prodId;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)("POST: " + uriInfo.getAbsolutePathBuilder()));
        }
        if (userName2 != null) {
            if (userName != null) {
                logger.log(BasicLevel.WARN, (Object)"POST: overrides JMS identity from HTML body");
            }
            userName = userName2;
            password = password2;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("createProducer(" + headers + ", " + destName + ", " + clientID + ", " + prodName + ", " + sessionMode + ", " + deliveryMode + ", " + deliveryDelay + ", " + correlationID + ", " + priority + ", " + timeToLive + ", " + idleTimeout + ", " + userName + ", " + uriInfo + ")"));
        }
        Response.ResponseBuilder builder = null;
        try {
            prodId = null;
            try {
                prodId = this.helper.createProducer(userName, password, clientID, prodName, null, sessionMode, deliveryMode, deliveryDelay, correlationID, priority, timeToLive, destName, false, idleTimeout);
            }
            catch (Exception e) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)e);
                }
                builder = e instanceof JMSSecurityRuntimeException ? Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.toString()) : Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
                Response response = builder.build();
                JmsContextService.logLinks(builder);
                return response;
            }
        }
        catch (Throwable throwable) {
            JmsContextService.logLinks(builder);
            throw throwable;
        }
        builder = Response.status((Response.Status)Response.Status.CREATED);
        UriBuilder nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId);
        builder.link(nextBuilder.build(new Object[0]), "send-message");
        SessionContext prodCtx = this.helper.getSessionCtx(prodId);
        long id = prodCtx.getLastId() + 1L;
        nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId).path("" + id);
        builder.link(nextBuilder.build(new Object[0]), "send-next-message");
        nextBuilder = UriBuilder.fromPath((String)uriInfo.getBaseUri().toString()).path(JMS).path(prodId);
        builder.link(nextBuilder.build(new Object[0]), "close-context");
        if (prodCtx.getJmsContext().getTransacted()) {
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId).path("commit");
            builder.link(nextBuilder.build(new Object[0]), "commit");
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId).path("rollback");
            builder.link(nextBuilder.build(new Object[0]), "rollback");
        }
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/queue/{destName}/create-producer")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createQueueProducer(@Context HttpHeaders headers, @PathParam(value="destName") String destName, @QueryParam(value="client-id") String clientID, @QueryParam(value="name") String prodName, @DefaultValue(value="1") @QueryParam(value="session-mode") int sessionMode, @DefaultValue(value="2") @QueryParam(value="persistent") int deliveryMode, @DefaultValue(value="0") @QueryParam(value="delivery-delay") long deliveryDelay, @QueryParam(value="correlation-id") String correlationID, @DefaultValue(value="4") @QueryParam(value="priority") int priority, @DefaultValue(value="0") @QueryParam(value="time-to-live") long timeToLive, @DefaultValue(value="0") @QueryParam(value="idle-timeout") long idleTimeout, @QueryParam(value="user") String userName, @QueryParam(value="password") String password, @FormParam(value="user") String userName2, @FormParam(value="password") String password2, @Context UriInfo uriInfo) {
        String prodId;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)("POST: " + uriInfo.getAbsolutePathBuilder()));
        }
        if (userName2 != null) {
            if (userName != null) {
                logger.log(BasicLevel.WARN, (Object)"POST: overrides JMS identity from HTML body");
            }
            userName = userName2;
            password = password2;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("createProducer(" + headers + ", " + destName + ", " + clientID + ", " + prodName + ", " + sessionMode + ", " + deliveryMode + ", " + deliveryDelay + ", " + correlationID + ", " + priority + ", " + timeToLive + ", " + idleTimeout + ", " + userName + ", " + uriInfo + ")"));
        }
        Response.ResponseBuilder builder = null;
        try {
            prodId = null;
            try {
                prodId = this.helper.createProducer(userName, password, clientID, prodName, null, sessionMode, deliveryMode, deliveryDelay, correlationID, priority, timeToLive, destName, true, idleTimeout);
            }
            catch (Exception e) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)e);
                }
                builder = e instanceof JMSSecurityRuntimeException ? Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.toString()) : Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
                Response response = builder.build();
                JmsContextService.logLinks(builder);
                return response;
            }
        }
        catch (Throwable throwable) {
            JmsContextService.logLinks(builder);
            throw throwable;
        }
        builder = Response.status((Response.Status)Response.Status.CREATED);
        UriBuilder nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId);
        builder.link(nextBuilder.build(new Object[0]), "send-message");
        SessionContext prodCtx = this.helper.getSessionCtx(prodId);
        long id = prodCtx.getLastId() + 1L;
        nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId).path("" + id);
        builder.link(nextBuilder.build(new Object[0]), "send-next-message");
        nextBuilder = UriBuilder.fromPath((String)uriInfo.getBaseUri().toString()).path(JMS).path(prodId);
        builder.link(nextBuilder.build(new Object[0]), "close-context");
        if (prodCtx.getJmsContext().getTransacted()) {
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId).path("commit");
            builder.link(nextBuilder.build(new Object[0]), "commit");
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(prodId).path("rollback");
            builder.link(nextBuilder.build(new Object[0]), "rollback");
        }
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/topic/{destName}/create-consumer")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createTopicConsumer(@Context HttpHeaders headers, @PathParam(value="destName") String destName, @QueryParam(value="client-id") String clientID, @QueryParam(value="name") String consName, @DefaultValue(value="1") @QueryParam(value="session-mode") int sessionMode, @QueryParam(value="selector") String messageSelector, @DefaultValue(value="false") @QueryParam(value="no-local") boolean noLocal, @DefaultValue(value="false") @QueryParam(value="durable") boolean durable, @DefaultValue(value="false") @QueryParam(value="shared") boolean shared, @QueryParam(value="sub-name") String subName, @DefaultValue(value="0") @QueryParam(value="idle-timeout") long idleTimeout, @QueryParam(value="user") String userName, @QueryParam(value="password") String password, @FormParam(value="user") String userName2, @FormParam(value="password") String password2, @Context UriInfo uriInfo) {
        String consId;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)("POST: " + uriInfo.getAbsolutePathBuilder()));
        }
        if (userName2 != null) {
            if (userName != null) {
                logger.log(BasicLevel.WARN, (Object)"POST: overrides JMS identity from HTML body");
            }
            userName = userName2;
            password = password2;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("createConsumer(" + headers + ", " + destName + ", " + clientID + ", " + consName + ", " + sessionMode + ", " + messageSelector + ", " + noLocal + ", " + durable + ", " + shared + ", " + subName + ", " + idleTimeout + ", " + userName + ", " + uriInfo + ")"));
        }
        Response.ResponseBuilder builder = null;
        try {
            consId = null;
            try {
                consId = this.helper.createConsumer(userName, password, clientID, consName, null, sessionMode, messageSelector, noLocal, durable, shared, subName, destName, false, idleTimeout);
            }
            catch (Exception e) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)e);
                }
                builder = e instanceof JMSSecurityRuntimeException ? Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.toString()) : Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
                Response response = builder.build();
                JmsContextService.logLinks(builder);
                return response;
            }
        }
        catch (Throwable throwable) {
            JmsContextService.logLinks(builder);
            throw throwable;
        }
        builder = Response.status((Response.Status)Response.Status.CREATED);
        UriBuilder nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId);
        builder.link(nextBuilder.build(new Object[0]), "receive-message");
        SessionContext consCtx = this.helper.getSessionCtx(consId);
        long id = consCtx.getLastId() + 1L;
        nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId).path("" + id);
        builder.link(nextBuilder.build(new Object[0]), "receive-next-message");
        nextBuilder = UriBuilder.fromPath((String)uriInfo.getBaseUri().toString()).path(JMS).path(consId);
        builder.link(nextBuilder.build(new Object[0]), "close-context");
        if (consCtx.getJmsContext().getTransacted()) {
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId).path("commit");
            builder.link(nextBuilder.build(new Object[0]), "commit");
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId).path("rollback");
            builder.link(nextBuilder.build(new Object[0]), "rollback");
        }
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/queue/{destName}/create-consumer")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createQueueConsumer(@Context HttpHeaders headers, @PathParam(value="destName") String destName, @QueryParam(value="client-id") String clientID, @QueryParam(value="name") String consName, @DefaultValue(value="1") @QueryParam(value="session-mode") int sessionMode, @QueryParam(value="selector") String messageSelector, @DefaultValue(value="false") @QueryParam(value="no-local") boolean noLocal, @DefaultValue(value="false") @QueryParam(value="durable") boolean durable, @DefaultValue(value="false") @QueryParam(value="shared") boolean shared, @QueryParam(value="sub-name") String subName, @DefaultValue(value="0") @QueryParam(value="idle-timeout") long idleTimeout, @QueryParam(value="user") String userName, @QueryParam(value="password") String password, @FormParam(value="user") String userName2, @FormParam(value="password") String password2, @Context UriInfo uriInfo) {
        String consId;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)("POST: " + uriInfo.getAbsolutePathBuilder()));
        }
        if (userName2 != null) {
            if (userName != null) {
                logger.log(BasicLevel.WARN, (Object)"POST: overrides JMS identity from HTML body");
            }
            userName = userName2;
            password = password2;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("createConsumer(" + headers + ", " + destName + ", " + clientID + ", " + consName + ", " + sessionMode + ", " + messageSelector + ", " + noLocal + ", " + durable + ", " + shared + ", " + subName + ", " + idleTimeout + ", " + userName + ", " + uriInfo + ")"));
        }
        Response.ResponseBuilder builder = null;
        try {
            consId = null;
            try {
                consId = this.helper.createConsumer(userName, password, clientID, consName, null, sessionMode, messageSelector, noLocal, durable, shared, subName, destName, true, idleTimeout);
            }
            catch (Exception e) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)e);
                }
                builder = e instanceof JMSSecurityRuntimeException ? Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.toString()) : Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
                Response response = builder.build();
                JmsContextService.logLinks(builder);
                return response;
            }
        }
        catch (Throwable throwable) {
            JmsContextService.logLinks(builder);
            throw throwable;
        }
        builder = Response.status((Response.Status)Response.Status.CREATED);
        UriBuilder nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId);
        builder.link(nextBuilder.build(new Object[0]), "receive-message");
        SessionContext consCtx = this.helper.getSessionCtx(consId);
        long id = consCtx.getLastId() + 1L;
        nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId).path("" + id);
        builder.link(nextBuilder.build(new Object[0]), "receive-next-message");
        nextBuilder = UriBuilder.fromPath((String)uriInfo.getBaseUri().toString()).path(JMS).path(consId);
        builder.link(nextBuilder.build(new Object[0]), "close-context");
        if (consCtx.getJmsContext().getTransacted()) {
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId).path("commit");
            builder.link(nextBuilder.build(new Object[0]), "commit");
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("context").path(consId).path("rollback");
            builder.link(nextBuilder.build(new Object[0]), "rollback");
        }
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{name}")
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public Response closeSessionCtx(@Context HttpHeaders headers, @PathParam(value="name") String ctxName, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        block9: {
            Response response;
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("DELETE: " + uriInfo.getAbsolutePathBuilder()));
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("closeSessionCtx(" + headers + ", " + ctxName + ", " + uriInfo + ")"));
            }
            builder = null;
            try {
                if (ctxName != null) break block9;
                builder = Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).entity((Object)"The context name is null.");
                response = builder.build();
            }
            catch (Throwable throwable) {
                JmsContextService.logLinks(builder);
                throw throwable;
            }
            JmsContextService.logLinks(builder);
            return response;
        }
        try {
            this.helper.closeSessionCtx(ctxName);
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)e);
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
            Response response = builder.build();
            JmsContextService.logLinks(builder);
            return response;
        }
        builder = Response.status((Response.Status)Response.Status.OK);
        UriBuilder nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("jndi");
        builder.link(nextBuilder.build(new Object[0]), "jndi");
        nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(JMS);
        builder.link(nextBuilder.build(new Object[0]), JMS);
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }
}

