/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.tools.rest.jms;

import fr.dyade.aaa.common.Debug;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.joram.tools.rest.jms.ConsumerContext;
import org.objectweb.joram.tools.rest.jms.IPFilter;
import org.objectweb.joram.tools.rest.jms.ProducerContext;
import org.objectweb.joram.tools.rest.jms.RestClientContext;
import org.objectweb.joram.tools.rest.jms.SessionContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;

public class Helper {
    public static Logger logger = Debug.getLogger((String)Helper.class.getName());
    private static final String BYTES_CLASS_NAME = byte[].class.getName();
    public static final String BUNDLE_CF_PROP = "rest.jms.connectionFactory";
    public static final String BUNDLE_JNDI_FACTORY_INITIAL_PROP = "rest.jndi.factory.initial";
    public static final String BUNDLE_JNDI_FACTORY_HOST_PROP = "rest.jndi.factory.host";
    public static final String BUNDLE_JNDI_FACTORY_PORT_PROP = "rest.jndi.factory.port";
    public static final String BUNDLE_IDLE_TIMEOUT_PROP = "rest.idle.timeout";
    public static final String BUNDLE_CLEANER_PERIOD_PROP = "rest.cleaner.period";
    public static final String BUNDLE_JMS_USER = "rest.jms.user";
    public static final String BUNDLE_JMS_PASS = "rest.jms.password";
    public static final String BUNDLE_JMS_IP_ALLOWED = "rest.jms.ipallowed";
    public static final int DFLT_CLEANER_PERIOD = 15;
    private Random rand = new Random();
    private static final AtomicLong counter = new AtomicLong(1L);
    private static Helper helper = null;
    private InitialContext ictx;
    private HashMap<String, RestClientContext> restClientCtxs = new HashMap();
    private HashMap<String, SessionContext> sessionCtxs = new HashMap();
    private String cfName;
    private long globalIdleTimeout = 0L;
    private Properties jndiProps;
    private String restUser;
    private String restPass;
    private String IPAllowed;
    private IPFilter ipfilter;

    private Helper() {
    }

    public static synchronized Helper getInstance() {
        if (helper == null) {
            helper = new Helper();
        }
        return helper;
    }

    public String getRestUser() {
        return this.restUser;
    }

    public String getRestPass() {
        return this.restPass;
    }

    public void setGlobalProperties(BundleContext bundleContext) throws NamingException {
        block7: {
            String value;
            this.restUser = bundleContext.getProperty(BUNDLE_JMS_USER);
            this.restPass = bundleContext.getProperty(BUNDLE_JMS_PASS);
            this.IPAllowed = bundleContext.getProperty(BUNDLE_JMS_IP_ALLOWED);
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("IPFilter allowedList = " + this.IPAllowed));
            }
            this.ipfilter = new IPFilter(this.IPAllowed);
            this.setConnectionFactoryName(bundleContext.getProperty(BUNDLE_CF_PROP));
            if (bundleContext.getProperty(BUNDLE_JNDI_FACTORY_INITIAL_PROP) != null && bundleContext.getProperty(BUNDLE_JNDI_FACTORY_HOST_PROP) != null && bundleContext.getProperty(BUNDLE_JNDI_FACTORY_PORT_PROP) != null) {
                this.jndiProps = new Properties();
                this.jndiProps.setProperty("java.naming.factory.initial", bundleContext.getProperty(BUNDLE_JNDI_FACTORY_INITIAL_PROP));
                this.jndiProps.setProperty("java.naming.factory.host", bundleContext.getProperty(BUNDLE_JNDI_FACTORY_HOST_PROP));
                this.jndiProps.setProperty("java.naming.factory.port", bundleContext.getProperty(BUNDLE_JNDI_FACTORY_PORT_PROP));
            } else {
                this.jndiProps = new Properties();
                this.jndiProps.setProperty("java.naming.factory.initial", "fr.dyade.aaa.jndi2.client.NamingContextFactory");
                this.jndiProps.setProperty("java.naming.factory.host", "localhost");
                this.jndiProps.setProperty("java.naming.factory.port", "16400");
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("jndiProperties = " + this.jndiProps));
            }
            if ((value = bundleContext.getProperty(BUNDLE_IDLE_TIMEOUT_PROP)) != null && !value.isEmpty()) {
                try {
                    this.globalIdleTimeout = Long.parseLong(value);
                }
                catch (NumberFormatException exc) {
                    if (!logger.isLoggable(BasicLevel.WARN)) break block7;
                    logger.log(BasicLevel.WARN, (Object)("Bad configuration property rest.idle.timeout, should be a number: " + value), (Throwable)exc);
                }
            }
        }
    }

    public String getIPAllowed() {
        return this.IPAllowed;
    }

    public boolean checkIPAddress(String addr) {
        return this.ipfilter.checkIpAllowed(addr);
    }

    public boolean authenticationRequired() {
        return this.restUser != null && !this.restUser.isEmpty() && this.restPass != null && !this.restPass.isEmpty();
    }

    public HashMap<String, RestClientContext> getRestClientCtxs() {
        return this.restClientCtxs;
    }

    public void setConnectionFactoryName(String cfName) {
        if (cfName != null) {
            this.cfName = cfName;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Helper.setConnectionFactoryName = " + this.cfName));
            }
        } else {
            this.cfName = "cf";
        }
    }

    public void closeAll() throws Exception {
        ArrayList<RestClientContext> values = new ArrayList<RestClientContext>(this.restClientCtxs.values());
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.closeAll " + values));
        }
        for (RestClientContext restClientCtx : values) {
            this.close(restClientCtx.getClientId());
        }
        if (this.ictx != null) {
            this.ictx.close();
        }
    }

    public void close(String clientId) {
        RestClientContext restClientCtx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.close " + clientId));
        }
        if ((restClientCtx = this.restClientCtxs.get(clientId)) != null) {
            ArrayList<String> names = new ArrayList<String>(restClientCtx.getSessionCtxNames());
            for (String name : names) {
                this.closeSessionCtx(name);
            }
            this.restClientCtxs.remove(clientId);
        }
    }

    public void closeSessionCtx(String ctxName) {
        SessionContext ctx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.closeSessionCtx " + ctxName));
        }
        if ((ctx = this.sessionCtxs.get(ctxName)) != null) {
            RestClientContext restClientCtx = ctx.getClientCtx();
            ctx.getJmsContext().close();
            this.sessionCtxs.remove(ctxName);
            restClientCtx.removeSessionCtxNames(ctxName);
            if (restClientCtx.getSessionCtxNames().isEmpty()) {
                restClientCtx.getJmsContext().close();
                this.restClientCtxs.remove(restClientCtx.getClientId());
            }
        }
    }

    public Destination lookupDestination(String destName) throws NamingException {
        Object obj;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.lookupDestination " + destName));
        }
        if ((obj = this.lookup(destName)) instanceof Queue || obj instanceof Topic) {
            return (Destination)obj;
        }
        return null;
    }

    public synchronized Object lookup(String name) throws NamingException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.lookup " + name));
        }
        if (this.ictx == null) {
            this.ictx = new InitialContext(this.jndiProps);
        }
        return this.ictx.lookup(name);
    }

    public synchronized String createProducer(String userName, String password, String clientId, String prodName, Destination dest, int sessionMode, int deliveryMode, long deliveryDelay, String correlationID, int priority, long timeToLive, String destName, boolean isQueue, long idleTimeout) throws Exception {
        ProducerContext prodContext;
        RestClientContext restClientCtx;
        String prodId = prodName;
        if (prodId == null) {
            prodId = this.createProducerId();
            while (this.sessionCtxs != null && this.sessionCtxs.get(prodId) != null) {
                prodId = this.createProducerId();
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Helper.createProducer: create the new producer Id " + prodId));
            }
        }
        if ((restClientCtx = this.getClientContext(clientId)).getJmsContext() == null) {
            if (restClientCtx.getConnectionFactory() == null) {
                restClientCtx.setConnectionFactory((ConnectionFactory)this.lookup(this.cfName));
                if (idleTimeout != 0L) {
                    restClientCtx.setIdleTimeout(idleTimeout);
                } else if (this.globalIdleTimeout > 0L) {
                    restClientCtx.setIdleTimeout(this.globalIdleTimeout);
                }
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Helper.createProducer cf = " + restClientCtx.getConnectionFactory()));
            }
            JMSContext jmsContext = userName != null && !userName.isEmpty() ? restClientCtx.getConnectionFactory().createContext(userName, password) : restClientCtx.getConnectionFactory().createContext();
            jmsContext.setClientID(restClientCtx.getClientId());
            jmsContext.setAutoStart(false);
            restClientCtx.setJmsContext(jmsContext);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Helper.createProducer jmsContext = " + restClientCtx.getJmsContext()));
            }
        }
        if ((prodContext = (ProducerContext)this.sessionCtxs.get(prodId)) == null) {
            prodContext = new ProducerContext(restClientCtx);
            prodContext.setJmsContext(restClientCtx.getJmsContext().createContext(sessionMode));
            prodContext.setDefaultDeliveryMode(deliveryMode);
            prodContext.setDefaultJMSCorrelationID(correlationID);
            prodContext.setDefaultPriority(priority);
            prodContext.setDefaultTimeToLive(timeToLive);
            prodContext.setDefaultDeliveryDelay(deliveryDelay);
            JMSProducer producer = prodContext.getJmsContext().createProducer();
            prodContext.setProducer(producer);
            this.sessionCtxs.put(prodId, prodContext);
            restClientCtx.addSessionCtxNames(prodId);
            Object destination = dest;
            if (destination == null) {
                destination = isQueue ? restClientCtx.getJmsContext().createQueue(destName) : restClientCtx.getJmsContext().createTopic(destName);
            }
            prodContext.setDest((Destination)destination);
        }
        return prodId;
    }

    public synchronized String createConsumer(String userName, String password, String clientId, String consName, Destination dest, int sessionMode, String messageSelector, boolean noLocal, boolean durable, boolean shared, String name, String destName, boolean isQueue, long idleTimeout) throws Exception {
        SessionContext consumerContext;
        RestClientContext restClientCtx;
        String consId = consName;
        if (consId == null) {
            consId = this.createConsumerId();
            while (this.sessionCtxs != null && this.sessionCtxs.get(consId) != null) {
                consId = this.createConsumerId();
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Helper.createConsumer: create the new consumer Id " + consId));
            }
        }
        if ((restClientCtx = this.getClientContext(clientId)).getJmsContext() == null) {
            if (restClientCtx.getConnectionFactory() == null) {
                restClientCtx.setConnectionFactory((ConnectionFactory)this.lookup(this.cfName));
                if (idleTimeout != 0L) {
                    restClientCtx.setIdleTimeout(idleTimeout);
                } else if (this.globalIdleTimeout > 0L) {
                    restClientCtx.setIdleTimeout(this.globalIdleTimeout);
                }
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Helper.createConsumer cf = " + restClientCtx.getConnectionFactory()));
            }
            JMSContext jmsContext = userName != null && !userName.isEmpty() ? restClientCtx.getConnectionFactory().createContext(userName, password) : restClientCtx.getConnectionFactory().createContext();
            restClientCtx.setJmsContext(jmsContext);
            restClientCtx.getJmsContext().setClientID(restClientCtx.getClientId());
            restClientCtx.getJmsContext().setAutoStart(false);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Helper.createConsumer jmsContext = " + restClientCtx.getJmsContext()));
            }
        }
        if ((consumerContext = this.sessionCtxs.get(consId)) == null) {
            consumerContext = new ConsumerContext(restClientCtx);
            Object destination = dest;
            if (destination == null) {
                destination = isQueue ? restClientCtx.getJmsContext().createQueue(destName) : restClientCtx.getJmsContext().createTopic(destName);
            }
            consumerContext.setDest((Destination)destination);
            consumerContext.setJmsContext(restClientCtx.getJmsContext().createContext(sessionMode));
            if (durable && !shared) {
                if (messageSelector == null) {
                    ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createDurableConsumer((Topic)consumerContext.getDest(), name));
                } else {
                    ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createDurableConsumer((Topic)consumerContext.getDest(), name, messageSelector, noLocal));
                }
            } else if (durable && shared) {
                if (messageSelector == null) {
                    ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createSharedDurableConsumer((Topic)consumerContext.getDest(), name));
                } else {
                    ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createSharedDurableConsumer((Topic)consumerContext.getDest(), name, messageSelector));
                }
            } else if (shared) {
                if (messageSelector == null) {
                    ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createSharedConsumer((Topic)consumerContext.getDest(), name));
                } else {
                    ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createSharedConsumer((Topic)consumerContext.getDest(), name, messageSelector));
                }
            } else if (messageSelector == null) {
                ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createConsumer(consumerContext.getDest()));
            } else {
                ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createConsumer(consumerContext.getDest(), messageSelector, noLocal));
            }
            this.sessionCtxs.put(consId, consumerContext);
            restClientCtx.addSessionCtxNames(consId);
            if (!consumerContext.getJmsContext().getAutoStart()) {
                consumerContext.getJmsContext().start();
            }
        }
        return consId;
    }

    static final void setMapMessage(Map<String, Object> jsonMap, MapMessage msg) throws Exception {
        if (jsonMap == null) {
            return;
        }
        block28: for (String key : jsonMap.keySet()) {
            Object value;
            block36: {
                value = jsonMap.get(key);
                if (value instanceof ArrayList) {
                    ArrayList array = (ArrayList)value;
                    try {
                        if (array.size() != 2) break block36;
                        String className = (String)array.get(1);
                        if (Character.class.getName().equals(className)) {
                            value = Character.valueOf(((String)array.get(0)).charAt(0));
                        } else if (BYTES_CLASS_NAME.equals(className)) {
                            value = ((String)array.get(0)).getBytes("UTF-8");
                        } else {
                            Constructor<?> constructor = Class.forName(className).getConstructor(String.class);
                            value = constructor.newInstance(array.get(0));
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(BasicLevel.ERROR)) continue;
                        logger.log(BasicLevel.ERROR, (Object)("setMapMessage: ignore map entry " + key + ", " + value + " : " + e.getMessage()));
                        continue;
                    }
                }
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("setMapMessage: " + key + ", value = " + value + ", " + value.getClass().getSimpleName()));
            }
            switch (value.getClass().getSimpleName()) {
                case "String": {
                    msg.setString(key, (String)value);
                    continue block28;
                }
                case "Boolean": {
                    msg.setBoolean(key, ((Boolean)value).booleanValue());
                    continue block28;
                }
                case "Integer": {
                    msg.setInt(key, ((Integer)value).intValue());
                    continue block28;
                }
                case "Long": {
                    msg.setLong(key, ((Long)value).longValue());
                    continue block28;
                }
                case "Double": {
                    msg.setDouble(key, ((Double)value).doubleValue());
                    continue block28;
                }
                case "Float": {
                    msg.setFloat(key, ((Float)value).floatValue());
                    continue block28;
                }
                case "Short": {
                    msg.setShort(key, ((Short)value).shortValue());
                    continue block28;
                }
                case "Character": {
                    msg.setChar(key, ((Character)value).charValue());
                    continue block28;
                }
                case "Byte": {
                    msg.setByte(key, ((Byte)value).byteValue());
                    continue block28;
                }
                case "byte[]": {
                    msg.setBytes(key, (byte[])value);
                    continue block28;
                }
            }
            try {
                msg.setObjectProperty(key, value);
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.ERROR)) continue;
                logger.log(BasicLevel.ERROR, (Object)("ignore jms setObjectProperties(" + key + ", " + value + ") : " + e.getMessage()));
            }
        }
    }

    static final Object getValue(Map map, String key) throws Exception {
        Object value = map.get(key);
        if (value instanceof ArrayList) {
            ArrayList array = (ArrayList)value;
            try {
                if (array.size() == 2) {
                    String className = (String)array.get(1);
                    Constructor<?> constructor = Class.forName(className).getConstructor(String.class);
                    value = constructor.newInstance(array.get(0));
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(BasicLevel.ERROR)) {
                    logger.log(BasicLevel.ERROR, (Object)("getValue(" + key + ", " + value + ") : " + e.getMessage()));
                }
                throw e;
            }
        }
        return value;
    }

    public long send(String prodName, String type, Map<String, Object> jmsHeaders, Map<String, Object> jmsProps, Object jmsBody, int deliveryMode, long deliveryDelay, int priority, long timeToLive, String correlationID) throws Exception {
        try {
            ProducerContext producerCtx = (ProducerContext)this.sessionCtxs.get(prodName);
            if (producerCtx == null) {
                throw new Exception(prodName + " not found.");
            }
            return producerCtx.send(type, jmsHeaders, jmsProps, jmsBody, deliveryMode, deliveryDelay, priority, timeToLive, correlationID);
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)e);
            }
            throw e;
        }
    }

    public Message consume(String consName, long timeout, boolean noLocal, boolean durable, boolean shared, String name, long msgId) throws Exception {
        ConsumerContext consumerCtx = (ConsumerContext)this.sessionCtxs.get(consName);
        if (consumerCtx == null) {
            throw new Exception(consName + " not found.");
        }
        Message message = consumerCtx.getMessage(msgId);
        if (message != null) {
            return message;
        }
        message = consumerCtx.receive(timeout, msgId);
        return message;
    }

    public String createClientId() {
        return "clientID" + counter.getAndIncrement();
    }

    public String createProducerId() {
        return "prod_" + Math.abs(this.rand.nextLong()) + "_" + counter.getAndIncrement();
    }

    public String createConsumerId() {
        return "cons_" + Math.abs(this.rand.nextLong()) + "_" + counter.getAndIncrement();
    }

    public SessionContext getSessionCtx(String name) {
        return this.sessionCtxs.get(name);
    }

    public RestClientContext getClientContext(String id) {
        RestClientContext ret = this.restClientCtxs.get(id);
        if (ret == null) {
            String clientID = id;
            if (clientID == null) {
                clientID = this.createClientId();
                while (this.restClientCtxs.get(clientID) != null) {
                    clientID = this.createClientId();
                }
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Helper.getClientContext: create the new client Id " + clientID));
                }
            }
            ret = new RestClientContext(clientID);
            this.restClientCtxs.put(clientID, ret);
        }
        return ret;
    }

    public void commit(String name) throws Exception {
        SessionContext ctx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.commit " + name));
        }
        if ((ctx = this.sessionCtxs.get(name)) == null) {
            throw new Exception(name + " not found.");
        }
        if (ctx.getJmsContext().getTransacted()) {
            ctx.getJmsContext().commit();
        }
    }

    public void rollback(String name) throws Exception {
        SessionContext ctx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.rollback " + name));
        }
        if ((ctx = this.sessionCtxs.get(name)) == null) {
            throw new Exception(name + " not found.");
        }
        if (ctx.getJmsContext().getTransacted()) {
            ctx.getJmsContext().rollback();
        }
    }

    public void acknowledgeAllMsg(String consName) throws Exception {
        ConsumerContext consumerCtx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.acknowledgeAllMsg " + consName));
        }
        if ((consumerCtx = (ConsumerContext)this.sessionCtxs.get(consName)) == null) {
            throw new Exception(consName + " not found.");
        }
        if (consumerCtx.getJmsContext().getSessionMode() == 2) {
            consumerCtx.getJmsContext().acknowledge();
            consumerCtx.clear();
        }
    }

    public void acknowledgeMsg(String consName, long id) throws Exception {
        ConsumerContext consumerCtx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.acknowledgeMsg " + consName + ", " + id));
        }
        if ((consumerCtx = (ConsumerContext)this.sessionCtxs.get(consName)) == null) {
            throw new Exception(consName + " not found.");
        }
        if (consumerCtx.getJmsContext().getSessionMode() == 2) {
            Message msg = consumerCtx.getMessage(id);
            msg.acknowledge();
            consumerCtx.removeMessage(id);
        }
    }
}

