/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.tools.rest.jms;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSConsumer;
import javax.jms.JMSException;
import javax.jms.Message;
import org.objectweb.joram.tools.rest.jms.RestClientContext;
import org.objectweb.joram.tools.rest.jms.SessionContext;

public class ConsumerContext
extends SessionContext {
    private JMSConsumer consumer;
    private ConcurrentHashMap<Long, Message> messages = new ConcurrentHashMap();

    public ConsumerContext(RestClientContext clientCtx) {
        super(clientCtx);
    }

    public JMSConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(JMSConsumer consumer) {
        this.consumer = consumer;
    }

    public long getId(Message message) throws JMSException {
        if (message == null || !this.messages.containsValue(message)) {
            return -1L;
        }
        for (Map.Entry<Long, Message> entry : this.messages.entrySet()) {
            if (!message.getJMSMessageID().equals(entry.getValue().getJMSMessageID())) continue;
            return entry.getKey();
        }
        return -1L;
    }

    private final void put(long id, Message msg) {
        if (msg == null) {
            return;
        }
        if (id > this.getLastId()) {
            this.setLastId(id);
        }
        this.messages.put(id, msg);
    }

    public Message getMessage(long id) {
        this.getClientCtx().setLastActivity(System.currentTimeMillis());
        return this.messages.get(id);
    }

    synchronized Message receive(long timeout, long msgId) throws JMSException {
        Message message = null;
        if (timeout > 0L) {
            message = this.getConsumer().receive(timeout);
        } else if (timeout == 0L) {
            message = this.getConsumer().receiveNoWait();
        } else {
            message = this.getConsumer().receive();
            if (message == null) {
                throw new JMSException("The consumer expire (timeout)");
            }
        }
        this.getClientCtx().setLastActivity(System.currentTimeMillis());
        if (message != null) {
            if (this.getJmsContext().getSessionMode() == 2) {
                long id = msgId;
                if (id == -1L) {
                    id = this.incLastId();
                }
                this.put(id, message);
            } else {
                this.incLastId();
            }
        }
        return message;
    }

    public Message removeMessage(long id) {
        return this.messages.remove(id);
    }

    public void clear() {
        this.messages.clear();
    }
}

