/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.tools.rest.jms;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.dyade.aaa.common.Debug;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.objectweb.joram.tools.rest.jms.ConsumerContext;
import org.objectweb.joram.tools.rest.jms.Helper;
import org.objectweb.joram.tools.rest.jms.SessionContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

@Path(value="/context")
public class JmsContextService {
    public static Logger logger = Debug.getLogger((String)JmsContextService.class.getName());
    private final Helper helper = Helper.getInstance();
    public static final String CONTEXT = "context";
    public static final String CONTEXT_SEND = "send-message";
    public static final String CONTEXT_SEND_NEXT = "send-next-message";
    public static final String CONTEXT_CONSUME = "receive-message";
    public static final String CONTEXT_CONSUME_NEXT = "receive-next-message";
    public static final String CONTEXT_COMMIT = "commit";
    public static final String CONTEXT_ROLLBACK = "rollback";
    public static final String CONTEXT_ACK = "acknowledge";
    public static final String CONTEXT_ACK_MSG = "acknowledge-message";
    public static final String JMS_HEADER = "header";
    public static final String JMS_PROPERTIES = "properties";
    public static final String JMS_BODY = "body";
    public static final String JMS_TYPE = "type";

    public static void logLinks(Response.ResponseBuilder builder) {
        if (builder == null) {
            return;
        }
        Response response = builder.build();
        if (response != null) {
            Set links = response.getLinks();
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)"links: ");
            }
            for (Link link : links) {
                if (!logger.isLoggable(BasicLevel.INFO)) continue;
                logger.log(BasicLevel.INFO, (Object)("\t" + link.getRel() + ": " + link.getUri()));
            }
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)"");
            }
        }
    }

    @GET
    @Produces(value={"text/html"})
    public String info(@Context UriInfo uriInfo) {
        StringBuilder buff = new StringBuilder();
        buff.append("<html>");
        buff.append("<body>");
        buff.append("<h3>send a message (POST)</h3>");
        buff.append("<pre>");
        buff.append(uriInfo.getAbsolutePathBuilder() + "/{<b>name</b>}");
        buff.append("\n" + uriInfo.getAbsolutePathBuilder() + "/{<b>name</b>/{<b>id</b>}");
        buff.append("\n<b>options:</b>");
        buff.append("\n  <b>persistent:</b> Specifies the delivery mode of messages that are sent using this JMSProducer");
        buff.append("\n  <b>correlation-id:</b> Specifies that messages sent using this JMSProducer will have their JMSCorrelationID header value set to the specified correlation ID");
        buff.append("\n  <b>priority:</b> Specifies the priority of messages that are sent using this JMSProducer");
        buff.append("\n  <b>time-to-live:</b> Specifies the time to live of messages that are sent using this JMSProducer");
        buff.append("</pre>");
        buff.append("<h3>send a message JSON (POST)</h3>");
        buff.append("<pre>");
        buff.append(uriInfo.getAbsolutePathBuilder() + "/{<b>name</b>}");
        buff.append("\n" + uriInfo.getAbsolutePathBuilder() + "/{<b>name</b>/{<b>id</b>}");
        buff.append("\n<b>options:</b>");
        buff.append("\n  <b>persistent:</b> Specifies the delivery mode of messages that are sent using this JMSProducer");
        buff.append("\n  <b>correlation-id:</b> Specifies that messages sent using this JMSProducer will have their JMSCorrelationID header value set to the specified correlation ID");
        buff.append("\n  <b>priority:</b> Specifies the priority of messages that are sent using this JMSProducer");
        buff.append("\n  <b>time-to-live:</b> Specifies the time to live of messages that are sent using this JMSProducer");
        buff.append("\n  <b>type:</b> The JMS message type BytesMessage, MapMessage, ObjectMessage, StreamMessage or TextMessage (default: TextMessage)");
        buff.append("\n<b>post:</b>");
        buff.append("\n  <b>json:</b> JSon maps contains the body, the properties and the header");
        buff.append("\n example:");
        buff.append("\n  {");
        buff.append("\n    \"jmsBody\":\"my test message.\",");
        buff.append("\n    \"jmsProperties\": {");
        buff.append("\n        \"p1\":\"value1\",");
        buff.append("\n        \"p2\":[\"12\",\"java.lang.Integer\"],");
        buff.append("\n        \"p3\":true,");
        buff.append("\n        \"p4\":[\"123456789\",\"java.lang.Long\"],");
        buff.append("\n        \"p5\":3");
        buff.append("\n      }");
        buff.append("\n    }");
        buff.append("</pre>");
        buff.append("<h3>consume a message (GET)</h3>");
        buff.append("<pre>");
        buff.append(uriInfo.getAbsolutePathBuilder() + "/{<b>name</b>}");
        buff.append("\n" + uriInfo.getAbsolutePathBuilder() + "/{<b>name</b>/{<b>id</b>}");
        buff.append("\n<b>options:</b>");
        buff.append("\n  <b>timeout:</b>  The timeout value (in milliseconds) for receive (default=-1 indefinitely, 0=receiveNoWait");
        buff.append("\n  <b>durable:</b> true to creates an durable subscription on the specified topic");
        buff.append("\n  <b>shared:</b> true for shared");
        buff.append("\n  <b>sub-name:</b> the name used to identify this subscription");
        buff.append("</pre>");
        buff.append("<h3>commit the producer or consumer messages (HEAD)</h3>");
        buff.append("<pre>");
        buff.append(uriInfo.getAbsolutePathBuilder() + "/{<b>name</b>}/" + CONTEXT_COMMIT);
        buff.append("</pre>");
        buff.append("<h3>rollback the producer or consumer messages (HEAD)</h3>");
        buff.append("<pre>");
        buff.append(uriInfo.getAbsolutePathBuilder() + "/{<b>name</b>}/" + CONTEXT_ROLLBACK);
        buff.append("</pre>");
        buff.append("<h3>acknowledge the producer or consumer (DELETE)</h3>");
        buff.append("<pre>");
        buff.append(uriInfo.getAbsolutePathBuilder() + "/{<b>name</b>}");
        buff.append("\n" + uriInfo.getAbsolutePathBuilder() + "/{<b>name</b>}/{<b>id</b>}");
        buff.append("</pre>");
        buff.append("</body>");
        buff.append("</html>");
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{name}")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response sendMsg(@Context HttpHeaders headers, @PathParam(value="name") String prodName, @DefaultValue(value="-1") @QueryParam(value="persistent") int deliveryMode, @DefaultValue(value="-1") @QueryParam(value="delivery-time") long deliveryTime, @DefaultValue(value="-1") @QueryParam(value="priority") int priority, @DefaultValue(value="-1") @QueryParam(value="time-to-live") long timeToLive, @QueryParam(value="correlation-id") String correlationID, @Context UriInfo uriInfo, String body) {
        Response.ResponseBuilder builder;
        block16: {
            Response response;
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("POST: " + uriInfo.getAbsolutePathBuilder()));
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("sendMsg(" + headers + ", " + prodName + ", " + deliveryMode + ", " + deliveryTime + ", " + priority + ", " + timeToLive + ", " + correlationID + ", " + uriInfo + ", " + body));
            }
            builder = null;
            try {
                if (prodName != null) break block16;
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)"sendMsg: The producer name is null.");
                }
                builder = Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).entity((Object)"The producer name is null.");
                response = builder.build();
            }
            catch (Throwable throwable) {
                JmsContextService.logLinks(builder);
                throw throwable;
            }
            JmsContextService.logLinks(builder);
            return response;
        }
        long msgId = 0L;
        try {
            msgId = this.helper.send(prodName, TextMessage.class.getSimpleName(), null, null, body, deliveryMode, deliveryTime, priority, timeToLive, correlationID);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("sendMsg: msgId = " + msgId));
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
            Response response = builder.build();
            JmsContextService.logLinks(builder);
            return response;
        }
        builder = Response.status((Response.Status)Response.Status.OK);
        UriBuilder nextBuilder = uriInfo.getAbsolutePathBuilder();
        URI next = nextBuilder.build(new Object[0]);
        builder.link(next, CONTEXT_SEND);
        nextBuilder = uriInfo.getAbsolutePathBuilder().path("" + (msgId + 1L));
        next = nextBuilder.build(new Object[0]);
        builder.link(next, CONTEXT_SEND_NEXT);
        try {
            if (this.helper.getSessionCtx(prodName).getJmsContext().getTransacted()) {
                nextBuilder = uriInfo.getAbsolutePathBuilder().path(CONTEXT_COMMIT);
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_COMMIT);
                nextBuilder = uriInfo.getAbsolutePathBuilder().path(CONTEXT_ROLLBACK);
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_ROLLBACK);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
            Response response = builder.build();
            JmsContextService.logLinks(builder);
            return response;
        }
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response sendMsgJson(@Context HttpHeaders headers, @PathParam(value="name") String prodName, @DefaultValue(value="-1") @QueryParam(value="persistent") int deliveryMode, @DefaultValue(value="-1") @QueryParam(value="delivery-time") long deliveryTime, @DefaultValue(value="-1") @QueryParam(value="priority") int priority, @DefaultValue(value="-1") @QueryParam(value="time-to-live") long timeToLive, @QueryParam(value="correlation-id") String correlationID, @Context UriInfo uriInfo, String json) {
        Response.ResponseBuilder builder;
        block22: {
            Response response;
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("POST: " + uriInfo.getAbsolutePathBuilder()));
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("sendMsg(" + headers + ", " + prodName + ", " + deliveryMode + ", " + deliveryTime + ", " + priority + ", " + timeToLive + ", " + correlationID + ", " + uriInfo + ", " + json));
            }
            builder = null;
            try {
                if (prodName != null) break block22;
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)"sendMsg: The producer name is null.");
                }
                builder = Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).entity((Object)"The producer name is null.");
                response = builder.build();
            }
            catch (Throwable throwable) {
                JmsContextService.logLinks(builder);
                throw throwable;
            }
            JmsContextService.logLinks(builder);
            return response;
        }
        long msgId = 0L;
        try {
            String jmsType = null;
            Map jmsHeaders = null;
            Map jmsProps = null;
            Object jmsBody = null;
            if (json != null) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("json = " + json));
                }
                Gson gson = new GsonBuilder().create();
                HashMap maps = (HashMap)gson.fromJson(json, HashMap.class);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("maps = " + maps));
                }
                jmsType = (String)maps.get(JMS_TYPE);
                jmsHeaders = (Map)maps.get(JMS_HEADER);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("jmsHeaders = " + jmsHeaders));
                }
                jmsProps = (Map)maps.get(JMS_PROPERTIES);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("jmsProps = " + jmsProps));
                }
                jmsBody = maps.get(JMS_BODY);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("jmsBody = " + jmsBody));
                }
            }
            msgId = this.helper.send(prodName, jmsType, jmsHeaders, jmsProps, jmsBody, deliveryMode, deliveryTime, priority, timeToLive, correlationID);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("sendMsg: msgId = " + msgId));
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
            Response jmsHeaders = builder.build();
            JmsContextService.logLinks(builder);
            return jmsHeaders;
        }
        builder = Response.status((Response.Status)Response.Status.OK);
        UriBuilder nextBuilder = uriInfo.getAbsolutePathBuilder();
        URI next = nextBuilder.build(new Object[0]);
        builder.link(next, CONTEXT_SEND);
        nextBuilder = uriInfo.getAbsolutePathBuilder().path("" + (msgId + 1L));
        next = nextBuilder.build(new Object[0]);
        builder.link(next, CONTEXT_SEND_NEXT);
        try {
            if (this.helper.getSessionCtx(prodName).getJmsContext().getTransacted()) {
                nextBuilder = uriInfo.getAbsolutePathBuilder().path(CONTEXT_COMMIT);
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_COMMIT);
                nextBuilder = uriInfo.getAbsolutePathBuilder().path(CONTEXT_ROLLBACK);
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_ROLLBACK);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
            Response response = builder.build();
            JmsContextService.logLinks(builder);
            return response;
        }
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{name}/{id}")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response sendMsg(@Context HttpHeaders headers, @PathParam(value="name") String prodName, @PathParam(value="id") long id, @DefaultValue(value="-1") @QueryParam(value="persistent") int deliveryMode, @DefaultValue(value="-1") @QueryParam(value="delivery-time") long deliveryTime, @DefaultValue(value="-1") @QueryParam(value="priority") int priority, @DefaultValue(value="-1") @QueryParam(value="time-to-live") long timeToLive, @QueryParam(value="correlation-id") String correlationID, @Context UriInfo uriInfo, String body) {
        SessionContext prodCtx;
        Response.ResponseBuilder builder;
        block22: {
            block21: {
                block20: {
                    Response response;
                    if (logger.isLoggable(BasicLevel.INFO)) {
                        logger.log(BasicLevel.INFO, (Object)("POST: " + uriInfo.getAbsolutePathBuilder()));
                    }
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("sendMsg(" + headers + ", " + prodName + ", " + id + ", " + deliveryMode + ", " + deliveryTime + ", " + priority + ", " + timeToLive + ", " + correlationID + ", " + uriInfo + ", " + body));
                    }
                    builder = null;
                    try {
                        if (prodName != null) break block20;
                        if (logger.isLoggable(BasicLevel.WARN)) {
                            logger.log(BasicLevel.WARN, (Object)"sendMsg: The producer name is null.");
                        }
                        builder = Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).entity((Object)"The producer name is null.");
                        response = builder.build();
                    }
                    catch (Throwable throwable) {
                        JmsContextService.logLinks(builder);
                        throw throwable;
                    }
                    JmsContextService.logLinks(builder);
                    return response;
                }
                prodCtx = this.helper.getSessionCtx(prodName);
                if (prodCtx != null) break block21;
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)("Unknown " + prodName + ", prodCtx == null"));
                }
                builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unknown " + prodName + ", prodCtx == null"));
                Response response = builder.build();
                JmsContextService.logLinks(builder);
                return response;
            }
            if (id >= prodCtx.getLastId()) break block22;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"sendMsg: The message already send, nothing to do.");
            }
            builder = Response.status((Response.Status)Response.Status.OK);
            Response response = builder.build();
            JmsContextService.logLinks(builder);
            return response;
        }
        try {
            long msgId = this.helper.send(prodName, TextMessage.class.getSimpleName(), null, null, body, deliveryMode, deliveryTime, priority, timeToLive, correlationID);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("sendMsg: msgId = " + msgId));
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
            Response response = builder.build();
            JmsContextService.logLinks(builder);
            return response;
        }
        builder = Response.status((Response.Status)Response.Status.OK);
        UriBuilder nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(CONTEXT).path(prodName);
        builder.link(nextBuilder.build(new Object[0]), CONTEXT_SEND);
        nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(CONTEXT).path(prodName).path("" + (prodCtx.getLastId() + 1L));
        builder.link(nextBuilder.build(new Object[0]), CONTEXT_SEND_NEXT);
        try {
            if (prodCtx.getJmsContext().getTransacted()) {
                nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(CONTEXT).path(prodName).path(CONTEXT_COMMIT);
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_COMMIT);
                nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(CONTEXT).path(prodName).path(CONTEXT_ROLLBACK);
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_ROLLBACK);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
            Response response = builder.build();
            JmsContextService.logLinks(builder);
            return response;
        }
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{name}/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response sendMsgJson(@Context HttpHeaders headers, @PathParam(value="name") String prodName, @PathParam(value="id") long id, @DefaultValue(value="-1") @QueryParam(value="persistent") int deliveryMode, @DefaultValue(value="-1") @QueryParam(value="delivery-time") long deliveryTime, @DefaultValue(value="-1") @QueryParam(value="priority") int priority, @DefaultValue(value="-1") @QueryParam(value="time-to-live") long timeToLive, @QueryParam(value="correlation-id") String correlationID, @Context UriInfo uriInfo, String json) {
        SessionContext prodCtx;
        Response.ResponseBuilder builder;
        block28: {
            block27: {
                block26: {
                    Response response;
                    if (logger.isLoggable(BasicLevel.INFO)) {
                        logger.log(BasicLevel.INFO, (Object)("POST: " + uriInfo.getAbsolutePathBuilder()));
                    }
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("sendMsg(" + headers + ", " + prodName + ", " + id + ", " + deliveryMode + ", " + deliveryTime + ", " + priority + ", " + timeToLive + ", " + correlationID + ", " + uriInfo + ", " + json));
                    }
                    builder = null;
                    try {
                        if (prodName != null) break block26;
                        if (logger.isLoggable(BasicLevel.WARN)) {
                            logger.log(BasicLevel.WARN, (Object)"sendMsg: The producer name is null.");
                        }
                        builder = Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).entity((Object)"The producer name is null.");
                        response = builder.build();
                    }
                    catch (Throwable throwable) {
                        JmsContextService.logLinks(builder);
                        throw throwable;
                    }
                    JmsContextService.logLinks(builder);
                    return response;
                }
                prodCtx = this.helper.getSessionCtx(prodName);
                if (prodCtx != null) break block27;
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)("Unknown " + prodName + ", prodCtx == null"));
                }
                builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unknown " + prodName + ", prodCtx == null"));
                Response response = builder.build();
                JmsContextService.logLinks(builder);
                return response;
            }
            if (id >= prodCtx.getLastId()) break block28;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"sendMsg: The message already send, nothing to do.");
            }
            builder = Response.status((Response.Status)Response.Status.OK);
            Response response = builder.build();
            JmsContextService.logLinks(builder);
            return response;
        }
        try {
            Map jmsHeaders = null;
            Map jmsProps = null;
            Object jmsBody = null;
            String jmsType = null;
            if (json != null) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("json = " + json));
                }
                Gson gson = new GsonBuilder().create();
                HashMap maps = (HashMap)gson.fromJson(json, HashMap.class);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("maps = " + maps));
                }
                jmsType = (String)maps.get(JMS_TYPE);
                jmsHeaders = (Map)maps.get(JMS_HEADER);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("jmsHeaders = " + jmsHeaders));
                }
                jmsProps = (Map)maps.get(JMS_PROPERTIES);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("jmsProps = " + jmsProps));
                }
                jmsBody = maps.get(JMS_BODY);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("jmsBody = " + jmsBody));
                }
            }
            long msgId = this.helper.send(prodName, jmsType, jmsHeaders, jmsProps, jmsBody, deliveryMode, deliveryTime, priority, timeToLive, correlationID);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("sendMsg: msgId = " + msgId));
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
            Response jmsProps = builder.build();
            JmsContextService.logLinks(builder);
            return jmsProps;
        }
        builder = Response.status((Response.Status)Response.Status.OK);
        UriBuilder nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(CONTEXT).path(prodName);
        builder.link(nextBuilder.build(new Object[0]), CONTEXT_SEND);
        nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(CONTEXT).path(prodName).path("" + (prodCtx.getLastId() + 1L));
        builder.link(nextBuilder.build(new Object[0]), CONTEXT_SEND_NEXT);
        try {
            if (prodCtx.getJmsContext().getTransacted()) {
                nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(CONTEXT).path(prodName).path(CONTEXT_COMMIT);
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_COMMIT);
                nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(CONTEXT).path(prodName).path(CONTEXT_ROLLBACK);
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_ROLLBACK);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
            Response response = builder.build();
            JmsContextService.logLinks(builder);
            return response;
        }
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @GET
    @Path(value="/{name}")
    @Produces(value={"text/plain", "application/json"})
    @Consumes(value={"text/plain"})
    public Response consumeMsg(@Context HttpHeaders headers, @PathParam(value="name") String consName, @DefaultValue(value="-1") @QueryParam(value="timeout") long timeout, @DefaultValue(value="false") @QueryParam(value="no-local") boolean noLocal, @DefaultValue(value="false") @QueryParam(value="durable") boolean durable, @DefaultValue(value="false") @QueryParam(value="shared") boolean shared, @QueryParam(value="sub-name") String subName, @Context UriInfo uriInfo) {
        UriBuilder nextBuilder;
        boolean jsonMedia;
        HashMap<String, Object> msg;
        Message message;
        Response.ResponseBuilder builder;
        block44: {
            block46: {
                HashMap<String, Object> jsonMap;
                block45: {
                    block43: {
                        Response response;
                        if (logger.isLoggable(BasicLevel.INFO)) {
                            logger.log(BasicLevel.INFO, (Object)("GET: " + uriInfo.getAbsolutePathBuilder()));
                        }
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("consumeTextMsg(" + headers + ", " + consName + ", " + timeout + ", " + noLocal + ", " + durable + ", " + shared + ", " + subName + ", " + uriInfo));
                        }
                        builder = null;
                        try {
                            if (consName != null) break block43;
                            if (logger.isLoggable(BasicLevel.WARN)) {
                                logger.log(BasicLevel.WARN, (Object)"sendMsg: The consumer name is null.");
                            }
                            builder = Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).entity((Object)"The consumer name is null.");
                            response = builder.build();
                        }
                        catch (Throwable throwable) {
                            JmsContextService.logLinks(builder);
                            throw throwable;
                        }
                        JmsContextService.logLinks(builder);
                        return response;
                    }
                    message = null;
                    try {
                        message = this.helper.consume(consName, timeout, noLocal, durable, shared, subName, -1L);
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("consumeTextMsg: message = " + message));
                        }
                    }
                    catch (Exception e) {
                        if (logger.isLoggable(BasicLevel.WARN)) {
                            logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
                        }
                        builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage());
                        Response response = builder.build();
                        JmsContextService.logLinks(builder);
                        return response;
                    }
                    msg = null;
                    jsonMedia = false;
                    List medias = headers.getAcceptableMediaTypes();
                    if (medias.contains(MediaType.APPLICATION_JSON_TYPE)) {
                        jsonMedia = true;
                    }
                    if (message instanceof TextMessage) {
                        if (jsonMedia) {
                            jsonMap = new HashMap<String, Object>();
                            jsonMap.put(JMS_TYPE, message.getClass().getSimpleName());
                            jsonMap.put(JMS_BODY, ((TextMessage)message).getText());
                            jsonMap.put(JMS_PROPERTIES, this.getPropertiesToJsonMap(message));
                            jsonMap.put(JMS_HEADER, this.getHeaderToJsonMap(message));
                            msg = jsonMap;
                        } else {
                            msg = ((TextMessage)message).getText();
                        }
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("consumeTextMsg: msg = " + msg));
                        }
                        break block44;
                    }
                    if (!(message instanceof MapMessage)) break block45;
                    if (jsonMedia) {
                        jsonMap = new HashMap();
                        jsonMap.put(JMS_TYPE, message.getClass().getSimpleName());
                        jsonMap.put(JMS_BODY, message.getBody(Map.class));
                        jsonMap.put(JMS_PROPERTIES, this.getPropertiesToJsonMap(message));
                        jsonMap.put(JMS_HEADER, this.getHeaderToJsonMap(message));
                        msg = jsonMap;
                        break block44;
                    }
                    builder = Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)"Only available with MediaType.APPLICATION_JSON");
                    Response jsonMap2 = builder.build();
                    JmsContextService.logLinks(builder);
                    return jsonMap2;
                }
                if (!(message instanceof BytesMessage)) break block46;
                if (jsonMedia) {
                    jsonMap = new HashMap();
                    jsonMap.put(JMS_TYPE, message.getClass().getSimpleName());
                    jsonMap.put(JMS_BODY, message.getBody(byte[].class));
                    jsonMap.put(JMS_PROPERTIES, this.getPropertiesToJsonMap(message));
                    jsonMap.put(JMS_HEADER, this.getHeaderToJsonMap(message));
                    msg = jsonMap;
                    break block44;
                }
                builder = Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)"Only available with MediaType.APPLICATION_JSON");
                Response jsonMap3 = builder.build();
                JmsContextService.logLinks(builder);
                return jsonMap3;
            }
            if (message != null) {
                throw new JMSException("Invalide Message type: " + message);
            }
            {
                catch (JMSException e) {
                    if (logger.isLoggable(BasicLevel.WARN)) {
                        logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
                    }
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage());
                    Response response = builder.build();
                    JmsContextService.logLinks(builder);
                    return response;
                }
            }
        }
        if (timeout > 0L && message == null) {
            builder = Response.status((Response.Status)Response.Status.NO_CONTENT);
        } else if (jsonMedia) {
            Gson gson = new GsonBuilder().create();
            String json = gson.toJson((Object)msg);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("json = " + json));
            }
            builder = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)json);
        } else {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("msg = " + msg));
            }
            builder = Response.status((Response.Status)Response.Status.OK).entity((Object)msg);
        }
        ConsumerContext consCtx = (ConsumerContext)this.helper.getSessionCtx(consName);
        try {
            if (consCtx.getJmsContext().getTransacted()) {
                nextBuilder = uriInfo.getAbsolutePathBuilder().path(CONTEXT_COMMIT);
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_COMMIT);
                nextBuilder = uriInfo.getAbsolutePathBuilder().path(CONTEXT_ROLLBACK);
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_ROLLBACK);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
            Response response = builder.build();
            JmsContextService.logLinks(builder);
            return response;
        }
        try {
            if (consCtx.getJmsContext().getSessionMode() == 2) {
                nextBuilder = uriInfo.getAbsolutePathBuilder();
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_ACK);
                long id = consCtx.getId(message);
                if (id > 0L) {
                    nextBuilder = uriInfo.getAbsolutePathBuilder().path("" + id);
                    builder.link(nextBuilder.build(new Object[0]), CONTEXT_ACK_MSG);
                }
            }
            long id = consCtx.getLastId();
            UriBuilder nextBuilder2 = uriInfo.getAbsolutePathBuilder().path("" + (id + 1L));
            builder.link(nextBuilder2.build(new Object[0]), CONTEXT_CONSUME_NEXT);
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
            Response id = builder.build();
            JmsContextService.logLinks(builder);
            return id;
        }
        UriBuilder nextBuilder3 = uriInfo.getAbsolutePathBuilder();
        URI next = nextBuilder3.build(new Object[0]);
        builder.link(next, CONTEXT_CONSUME);
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @GET
    @Path(value="/{name}/{id}")
    @Produces(value={"text/plain", "application/json"})
    @Consumes(value={"text/plain"})
    public Response consumeMsg(@Context HttpHeaders headers, @PathParam(value="name") String consName, @PathParam(value="id") long id, @DefaultValue(value="-1") @QueryParam(value="timeout") long timeout, @DefaultValue(value="false") @QueryParam(value="no-local") boolean noLocal, @DefaultValue(value="false") @QueryParam(value="durable") boolean durable, @DefaultValue(value="false") @QueryParam(value="shared") boolean shared, @QueryParam(value="sub-name") String subName, @Context UriInfo uriInfo) {
        UriBuilder nextBuilder;
        HashMap<String, Object> msg;
        boolean jsonMedia;
        Message message;
        Response.ResponseBuilder builder;
        block43: {
            block45: {
                HashMap<String, Object> jsonMap;
                block44: {
                    block42: {
                        Response response;
                        if (logger.isLoggable(BasicLevel.INFO)) {
                            logger.log(BasicLevel.INFO, (Object)("GET: " + uriInfo.getAbsolutePathBuilder()));
                        }
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("consumeTextMsg(" + headers + ", " + consName + ", " + id + ", " + timeout + ", " + noLocal + ", " + durable + ", " + shared + ", " + subName + ", " + uriInfo));
                        }
                        builder = null;
                        try {
                            if (consName != null) break block42;
                            if (logger.isLoggable(BasicLevel.WARN)) {
                                logger.log(BasicLevel.WARN, (Object)"consumeMsg: The consumer name is null.");
                            }
                            builder = Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).entity((Object)"The consumer name is null.");
                            response = builder.build();
                        }
                        catch (Throwable throwable) {
                            JmsContextService.logLinks(builder);
                            throw throwable;
                        }
                        JmsContextService.logLinks(builder);
                        return response;
                    }
                    message = null;
                    try {
                        message = this.helper.consume(consName, timeout, noLocal, durable, shared, subName, id);
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("consumeTextMsg: message = " + message));
                        }
                    }
                    catch (Exception e) {
                        if (logger.isLoggable(BasicLevel.WARN)) {
                            logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
                        }
                        builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage());
                        Response response = builder.build();
                        JmsContextService.logLinks(builder);
                        return response;
                    }
                    jsonMedia = false;
                    List medias = headers.getAcceptableMediaTypes();
                    if (medias.contains(MediaType.APPLICATION_JSON_TYPE)) {
                        jsonMedia = true;
                    }
                    msg = null;
                    if (message instanceof TextMessage) {
                        if (jsonMedia) {
                            jsonMap = new HashMap<String, Object>();
                            jsonMap.put(JMS_TYPE, message.getClass().getSimpleName());
                            jsonMap.put(JMS_BODY, ((TextMessage)message).getText());
                            jsonMap.put(JMS_PROPERTIES, this.getPropertiesToJsonMap(message));
                            jsonMap.put(JMS_HEADER, this.getHeaderToJsonMap(message));
                            msg = jsonMap;
                        } else {
                            msg = ((TextMessage)message).getText();
                        }
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("consumeTextMsg: msg = " + msg));
                        }
                        break block43;
                    }
                    if (!(message instanceof MapMessage)) break block44;
                    if (jsonMedia) {
                        jsonMap = new HashMap();
                        jsonMap.put(JMS_TYPE, message.getClass().getSimpleName());
                        jsonMap.put(JMS_BODY, message.getBody(Map.class));
                        jsonMap.put(JMS_PROPERTIES, this.getPropertiesToJsonMap(message));
                        jsonMap.put(JMS_HEADER, this.getHeaderToJsonMap(message));
                        msg = jsonMap;
                        break block43;
                    }
                    builder = Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)"Only available with MediaType.APPLICATION_JSON");
                    Response jsonMap2 = builder.build();
                    JmsContextService.logLinks(builder);
                    return jsonMap2;
                }
                if (!(message instanceof BytesMessage)) break block45;
                if (jsonMedia) {
                    jsonMap = new HashMap();
                    jsonMap.put(JMS_TYPE, message.getClass().getSimpleName());
                    jsonMap.put(JMS_BODY, message.getBody(byte[].class));
                    jsonMap.put(JMS_PROPERTIES, this.getPropertiesToJsonMap(message));
                    jsonMap.put(JMS_HEADER, this.getHeaderToJsonMap(message));
                    msg = jsonMap;
                    break block43;
                }
                builder = Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)"Only available with MediaType.APPLICATION_JSON");
                Response jsonMap3 = builder.build();
                JmsContextService.logLinks(builder);
                return jsonMap3;
            }
            if (message != null) {
                throw new JMSException("Invalide Message type: " + message);
            }
            {
                catch (JMSException e) {
                    if (logger.isLoggable(BasicLevel.WARN)) {
                        logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
                    }
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage());
                    Response response = builder.build();
                    JmsContextService.logLinks(builder);
                    return response;
                }
            }
        }
        if (timeout > 0L && message == null) {
            builder = Response.status((Response.Status)Response.Status.NO_CONTENT);
        } else if (jsonMedia) {
            Gson gson = new GsonBuilder().create();
            String json = gson.toJson((Object)msg);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("json = " + json));
            }
            builder = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)json);
        } else {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("msg = " + msg));
            }
            builder = Response.status((Response.Status)Response.Status.OK).entity((Object)msg);
        }
        ConsumerContext consCtx = (ConsumerContext)this.helper.getSessionCtx(consName);
        try {
            if (consCtx.getJmsContext().getTransacted()) {
                nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(CONTEXT).path(consName).path(CONTEXT_COMMIT);
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_COMMIT);
                nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(CONTEXT).path(consName).path(CONTEXT_ROLLBACK);
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_ROLLBACK);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
            Response response = builder.build();
            JmsContextService.logLinks(builder);
            return response;
        }
        try {
            if (consCtx.getJmsContext().getSessionMode() == 2) {
                nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(CONTEXT).path(consName);
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_ACK);
                nextBuilder = uriInfo.getAbsolutePathBuilder();
                builder.link(nextBuilder.build(new Object[0]), CONTEXT_ACK_MSG);
            }
            id = consCtx.getLastId();
            nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(CONTEXT).path(consName).path("" + (id + 1L));
            builder.link(nextBuilder.build(new Object[0]), CONTEXT_CONSUME_NEXT);
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)e);
            }
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString());
            Response response = builder.build();
            JmsContextService.logLinks(builder);
            return response;
        }
        nextBuilder = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(CONTEXT).path(consName);
        URI next = nextBuilder.build(new Object[0]);
        builder.link(next, CONTEXT_CONSUME);
        Response response = builder.build();
        JmsContextService.logLinks(builder);
        return response;
    }

    private Map getPropertiesToJsonMap(Message message) throws JMSException {
        HashMap<String, String[]> props = new HashMap<String, String[]>();
        Enumeration names = message.getPropertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object v = message.getObjectProperty(name);
            if (v == null) continue;
            String[] value = new String[]{"" + v, v.getClass().getName()};
            props.put(name, value);
        }
        return props;
    }

    private Map getHeaderToJsonMap(Message message) {
        HashMap<String, Object> header = new HashMap<String, Object>();
        try {
            if (message.getJMSDeliveryMode() == 1) {
                header.put("DeliveryMode", "NON_PERSISTENT");
            } else if (message.getJMSDeliveryMode() == 2) {
                header.put("DeliveryMode", "PERSISTENT");
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            header.put("Priority", message.getJMSPriority());
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            header.put("Redelivered", message.getJMSRedelivered());
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            header.put("Timestamp", message.getJMSTimestamp());
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            if (message.getJMSExpiration() > 0L) {
                header.put("Expiration", message.getJMSExpiration());
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            if (message.getJMSCorrelationID() != null) {
                header.put("CorrelationID", message.getJMSCorrelationID());
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            if (message.getJMSCorrelationIDAsBytes() != null) {
                header.put("CorrelationIDAsBytes", message.getJMSCorrelationIDAsBytes());
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            if (message.getJMSDestination() != null) {
                header.put("Destination", message.getJMSDestination());
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            if (message.getJMSMessageID() != null) {
                header.put("MessageID", message.getJMSMessageID());
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            if (message.getJMSReplyTo() != null) {
                header.put("ReplyTo", message.getJMSReplyTo());
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            if (message.getJMSType() != null) {
                header.put("Type", message.getJMSType());
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return header;
    }

    /*
     * Exception decompiling
     */
    @HEAD
    @Path(value="/{name}/commit")
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public Response commit(@Context HttpHeaders headers, @PathParam(value="name") String ctxName, @Context UriInfo uriInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 7[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @HEAD
    @Path(value="/{name}/rollback")
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public Response rollback(@Context HttpHeaders headers, @PathParam(value="name") String ctxName, @Context UriInfo uriInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 7[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @DELETE
    @Path(value="/{name}")
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public Response acknowledgeCons(@Context HttpHeaders headers, @PathParam(value="name") String ctxName, @Context UriInfo uriInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 7[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @DELETE
    @Path(value="/{name}/{id}")
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public Response acknowledgeCons(@Context HttpHeaders headers, @PathParam(value="name") String ctxName, @PathParam(value="id") long id, @Context UriInfo uriInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 7[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

