/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.tools.rest.jms;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSConsumer;
import javax.jms.JMSException;
import javax.jms.Message;
import org.objectweb.joram.tools.rest.jms.RestClientContext;
import org.objectweb.joram.tools.rest.jms.SessionContext;

public class ConsumerContext
extends SessionContext {
    private JMSConsumer consumer;
    private ConcurrentHashMap<Long, Message> messages = new ConcurrentHashMap();

    public ConsumerContext(RestClientContext clientCtx) {
        super(clientCtx);
    }

    public JMSConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(JMSConsumer consumer) {
        this.consumer = consumer;
    }

    public long getId(Message message) throws JMSException {
        if (message == null || !this.messages.containsValue(message)) {
            return -1L;
        }
        for (Map.Entry<Long, Message> entry : this.messages.entrySet()) {
            if (!message.getJMSMessageID().equals(entry.getValue().getJMSMessageID())) continue;
            return entry.getKey();
        }
        return -1L;
    }

    public void put(long id, Message msg) {
        if (msg == null) {
            return;
        }
        if (id > this.getLastId()) {
            this.setLastId(id);
        }
        this.messages.put(id, msg);
    }

    public Message getMessage(long id) {
        return this.messages.get(id);
    }

    public Message removeMessage(long id) {
        return this.messages.remove(id);
    }

    public void clear() {
        this.messages.clear();
    }
}

