/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.tools.rest.jms;

import fr.dyade.aaa.common.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.objectweb.joram.tools.rest.jms.Helper;
import org.objectweb.joram.tools.rest.jms.RestClientContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class CleanerTask
implements Callable<Boolean> {
    public static Logger logger = Debug.getLogger((String)CleanerTask.class.getName());
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    private int period = 60;
    private int timeOut = 3600;
    private ScheduledFuture<?> callableHandle;
    private HashMap<String, RestClientContext> restClientCtxs = Helper.getInstance().getRestClientCtxs();
    private Helper helper = Helper.getInstance();

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public void start() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("cleanerTask.start period = " + this.period));
        }
        if (this.scheduler != null && this.scheduler.isTerminated()) {
            this.scheduler = Executors.newScheduledThreadPool(2);
        }
        if (this.callableHandle != null && !this.callableHandle.isCancelled()) {
            this.callableHandle.cancel(true);
        }
        this.callableHandle = this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                CleanerTask.this.submitCallTask();
            }
        }, 0L, this.period, TimeUnit.SECONDS);
    }

    public void stop() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"cleanerTask.stop");
        }
        if (this.callableHandle != null) {
            this.callableHandle.cancel(true);
        }
        this.scheduler.shutdown();
    }

    public void submitCallTask() {
        Boolean res = false;
        Future<Boolean> future = this.scheduler.submit(this);
        try {
            res = future.get(this.timeOut, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"==== cleanerTask.submitCallTask InterruptedException");
            }
        }
        catch (ExecutionException e) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"==== cleanerTask.submitCallTask ExecutionException");
            }
        }
        catch (TimeoutException e) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"==== cleanerTask.submitCallTask TimeoutException");
            }
            future.cancel(true);
        }
    }

    @Override
    public Boolean call() throws Exception {
        ArrayList<String> toClose = new ArrayList<String>();
        for (RestClientContext restClientCtx : this.restClientCtxs.values()) {
            if (restClientCtx.getIdleTimeout() < 1L || restClientCtx.getLastActivity() + restClientCtx.getIdleTimeout() >= System.currentTimeMillis()) continue;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("cleanerTask.call close : " + restClientCtx.getClientId()));
            }
            if (toClose.contains(restClientCtx.getClientId())) continue;
            toClose.add(restClientCtx.getClientId());
        }
        for (String clientId : toClose) {
            this.helper.close(clientId);
        }
        return true;
    }
}

