/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.tools.rest.jms;

import fr.dyade.aaa.common.Debug;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.glassfish.jersey.servlet.ServletContainer;
import org.objectweb.joram.tools.rest.jms.CleanerTask;
import org.objectweb.joram.tools.rest.jms.Helper;
import org.objectweb.joram.tools.rest.jms.JmsJerseyApplication;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class Activator
implements BundleActivator {
    public static Logger logger = Debug.getLogger((String)Activator.class.getName());
    public static final String SERVICE_NAME = "rest.service.name";
    private BundleContext context = null;
    private HttpService httpService;
    public String servletAlias = "/joram";
    private CleanerTask cleanerTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext) throws Exception {
        this.context = bundleContext;
        ServiceReference reference = bundleContext.getServiceReference(HttpService.class);
        if (reference == null) {
            logger.log(BasicLevel.ERROR, (Object)"rest.jms.Activator ServiceReference<HttpService> = null");
            throw new Exception("rest.jms.Activator ServiceReference<HttpService> = null");
        }
        this.httpService = (HttpService)bundleContext.getService(reference);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("rest.jms.activator httpService = " + this.httpService));
        }
        ClassLoader myClassLoader = this.getClass().getClassLoader();
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(myClassLoader);
            String serviceName = bundleContext.getProperty(SERVICE_NAME);
            if (serviceName != null && !serviceName.isEmpty()) {
                this.servletAlias = serviceName.startsWith("/") ? serviceName : "/" + serviceName;
            }
            Helper.getInstance().setGlobalProperties(bundleContext);
            Hashtable<String, String> jerseyServletParams = new Hashtable<String, String>();
            ((Dictionary)jerseyServletParams).put("javax.ws.rs.Application", JmsJerseyApplication.class.getName());
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("start: REGISTERING SERVLETS " + this.servletAlias));
            }
            HttpContext httpContext = null;
            this.httpService.registerServlet(this.servletAlias, (Servlet)new ServletContainer(), jerseyServletParams, httpContext);
            String period = bundleContext.getProperty("rest.cleaner.period");
            if (period != null && !period.isEmpty()) {
                this.cleanerTask = new CleanerTask();
                this.cleanerTask.setPeriod(Integer.parseInt(period));
                this.cleanerTask.start();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.cleanerTask != null) {
            this.cleanerTask.stop();
        }
        Helper.getInstance().closeAll();
        if (this.httpService != null) {
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("stop: UNREGISTERING SERVLETS " + this.servletAlias));
            }
            this.httpService.unregister(this.servletAlias);
        }
    }
}

