/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.tools.rest.jms;

import fr.dyade.aaa.common.Debug;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.joram.tools.rest.jms.ConsumerContext;
import org.objectweb.joram.tools.rest.jms.ProducerContext;
import org.objectweb.joram.tools.rest.jms.RestClientContext;
import org.objectweb.joram.tools.rest.jms.SessionContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;

public class Helper {
    public static final String BUNDLE_CF_PROP = "rest.jms.connectionFactory";
    public static final String BUNDLE_JNDI_FACTORY_INITIAL_PROP = "rest.jndi.factory.initial";
    public static final String BUNDLE_JNDI_FACTORY_HOST_PROP = "rest.jndi.factory.host";
    public static final String BUNDLE_JNDI_FACTORY_PORT_PROP = "rest.jndi.factory.port";
    public static final String BUNDLE_IDLE_TIMEOUT_PROP = "rest.idle.timeout";
    public static final String BUNDLE_CLEANER_PERIOD_PROP = "rest.cleaner.period";
    public static Logger logger = Debug.getLogger((String)Helper.class.getName());
    private static final AtomicLong counter = new AtomicLong(100L);
    private static Helper helper = null;
    private InitialContext ictx;
    private HashMap<String, RestClientContext> restClientCtxs = new HashMap();
    private HashMap<String, SessionContext> sessionCtxs = new HashMap();
    private String cfName;
    private BundleContext bundleContext;
    private long globalIdleTimeout;
    private Properties jndiProps;

    private Helper() {
    }

    public static Helper getInstance() {
        if (helper == null) {
            helper = new Helper();
        }
        return helper;
    }

    public void setGlobalProperties(BundleContext bundleContext) throws NamingException {
        String value;
        this.bundleContext = bundleContext;
        this.setConnectionFactoryName(bundleContext.getProperty(BUNDLE_CF_PROP));
        if (bundleContext.getProperty(BUNDLE_JNDI_FACTORY_INITIAL_PROP) != null && bundleContext.getProperty(BUNDLE_JNDI_FACTORY_HOST_PROP) != null && bundleContext.getProperty(BUNDLE_JNDI_FACTORY_PORT_PROP) != null) {
            this.jndiProps = new Properties();
            this.jndiProps.setProperty("java.naming.factory.initial", bundleContext.getProperty(BUNDLE_JNDI_FACTORY_INITIAL_PROP));
            this.jndiProps.setProperty("java.naming.factory.host", bundleContext.getProperty(BUNDLE_JNDI_FACTORY_HOST_PROP));
            this.jndiProps.setProperty("java.naming.factory.port", bundleContext.getProperty(BUNDLE_JNDI_FACTORY_PORT_PROP));
        } else {
            this.jndiProps = new Properties();
            this.jndiProps.setProperty("java.naming.factory.initial", "fr.dyade.aaa.jndi2.client.NamingContextFactory");
            this.jndiProps.setProperty("java.naming.factory.host", "localhost");
            this.jndiProps.setProperty("java.naming.factory.port", "16400");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("jndiProperties = " + this.jndiProps));
        }
        if ((value = bundleContext.getProperty(BUNDLE_IDLE_TIMEOUT_PROP)) != null && !value.isEmpty()) {
            this.globalIdleTimeout = Long.parseLong(value);
        }
    }

    public HashMap<String, RestClientContext> getRestClientCtxs() {
        return this.restClientCtxs;
    }

    public void setConnectionFactoryName(String cfName) {
        if (cfName != null) {
            this.cfName = cfName;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Helper.setConnectionFactoryName = " + this.cfName));
            }
        } else {
            this.cfName = "cf";
        }
    }

    public void closeAll() throws Exception {
        ArrayList<RestClientContext> values = new ArrayList<RestClientContext>(this.restClientCtxs.values());
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.closeAll " + values));
        }
        for (RestClientContext restClientCtx : values) {
            this.close(restClientCtx.getClientId());
        }
        if (this.ictx != null) {
            this.ictx.close();
        }
    }

    public void close(String clientId) {
        RestClientContext restClientCtx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.close " + clientId));
        }
        if ((restClientCtx = this.restClientCtxs.get(clientId)) != null) {
            ArrayList<String> names = new ArrayList<String>(restClientCtx.getSessionCtxNames());
            for (String name : names) {
                this.closeSessionCtx(name);
            }
            this.restClientCtxs.remove(clientId);
        }
    }

    public void closeSessionCtx(String ctxName) {
        SessionContext ctx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.closeSessionCtx " + ctxName));
        }
        if ((ctx = this.sessionCtxs.get(ctxName)) != null) {
            RestClientContext restClientCtx = ctx.getClientCtx();
            ctx.getJmsContext().close();
            this.sessionCtxs.remove(ctxName);
            restClientCtx.removeSessionCtxNames(ctxName);
            if (restClientCtx.getSessionCtxNames().isEmpty()) {
                restClientCtx.getJmsContext().close();
                this.restClientCtxs.remove(restClientCtx.getClientId());
            }
        }
    }

    public Destination lookupDestination(String destName) throws NamingException {
        Object obj;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.lookupDestination " + destName));
        }
        if ((obj = this.lookup(destName)) instanceof Queue || obj instanceof Topic) {
            return (Destination)obj;
        }
        return null;
    }

    public Object lookup(String name) throws NamingException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.lookup " + name));
        }
        if (this.ictx == null) {
            this.ictx = new InitialContext(this.jndiProps);
        }
        return this.ictx.lookup(name);
    }

    public String createProducer(String userName, String password, String clientId, String prodName, Destination dest, int sessionMode, int deliveryMode, long deliveryDelay, String correlationID, int priority, long timeToLive, String destName, boolean isQueue, long idleTimeout) throws Exception {
        SessionContext prodContext;
        RestClientContext restClientCtx;
        String prodId = prodName;
        if (prodId == null) {
            prodId = this.createProducerId();
        }
        if ((restClientCtx = this.getClientContext(clientId)).getJmsContext() == null) {
            if (restClientCtx.getConnectionFactory() == null) {
                restClientCtx.setConnectionFactory((ConnectionFactory)this.lookup(this.cfName));
                if (idleTimeout != 0L) {
                    restClientCtx.setIdleTimeout(idleTimeout);
                } else if (this.globalIdleTimeout > 0L) {
                    restClientCtx.setIdleTimeout(this.globalIdleTimeout);
                }
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Helper.createProducer cf = " + restClientCtx.getConnectionFactory()));
            }
            JMSContext jmsContext = userName != null && !userName.isEmpty() ? restClientCtx.getConnectionFactory().createContext(userName, password) : restClientCtx.getConnectionFactory().createContext();
            jmsContext.setClientID(restClientCtx.getClientId());
            jmsContext.setAutoStart(false);
            restClientCtx.setJmsContext(jmsContext);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Helper.createProducer jmsContext = " + restClientCtx.getJmsContext()));
            }
        }
        if ((prodContext = this.sessionCtxs.get(prodId)) == null) {
            prodContext = new ProducerContext(restClientCtx);
            prodContext.setJmsContext(restClientCtx.getJmsContext().createContext(sessionMode));
            JMSProducer producer = prodContext.getJmsContext().createProducer();
            producer.setDeliveryMode(deliveryMode);
            if (correlationID != null) {
                producer.setJMSCorrelationID(correlationID);
            }
            producer.setPriority(priority);
            producer.setTimeToLive(timeToLive);
            producer.setDeliveryDelay(deliveryDelay);
            ((ProducerContext)prodContext).setProducer(producer);
            this.sessionCtxs.put(prodId, prodContext);
            restClientCtx.addSessionCtxNames(prodId);
            Object destination = dest;
            if (destination == null) {
                destination = isQueue ? restClientCtx.getJmsContext().createQueue(destName) : restClientCtx.getJmsContext().createTopic(destName);
            }
            prodContext.setDest((Destination)destination);
        }
        return prodId;
    }

    public String createConsumer(String userName, String password, String clientId, String consName, Destination dest, int sessionMode, String messageSelector, boolean noLocal, boolean durable, boolean shared, String name, String destName, boolean isQueue, long idleTimeout) throws Exception {
        SessionContext consumerContext;
        RestClientContext restClientCtx;
        String consId = consName;
        if (consId == null) {
            consId = this.createConsumerId();
        }
        if ((restClientCtx = this.getClientContext(clientId)).getJmsContext() == null) {
            if (restClientCtx.getConnectionFactory() == null) {
                restClientCtx.setConnectionFactory((ConnectionFactory)this.lookup(this.cfName));
                if (idleTimeout != 0L) {
                    restClientCtx.setIdleTimeout(idleTimeout);
                } else if (this.globalIdleTimeout > 0L) {
                    restClientCtx.setIdleTimeout(this.globalIdleTimeout);
                }
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Helper.createConsumer cf = " + restClientCtx.getConnectionFactory()));
            }
            JMSContext jmsContext = userName != null && !userName.isEmpty() ? restClientCtx.getConnectionFactory().createContext(userName, password) : restClientCtx.getConnectionFactory().createContext();
            restClientCtx.setJmsContext(jmsContext);
            restClientCtx.getJmsContext().setClientID(restClientCtx.getClientId());
            restClientCtx.getJmsContext().setAutoStart(false);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Helper.createConsumer jmsContext = " + restClientCtx.getJmsContext()));
            }
        }
        if ((consumerContext = this.sessionCtxs.get(consId)) == null) {
            consumerContext = new ConsumerContext(restClientCtx);
            Object destination = dest;
            if (destination == null) {
                destination = isQueue ? restClientCtx.getJmsContext().createQueue(destName) : restClientCtx.getJmsContext().createTopic(destName);
            }
            consumerContext.setDest((Destination)destination);
            consumerContext.setJmsContext(restClientCtx.getJmsContext().createContext(sessionMode));
            if (durable && !shared) {
                if (messageSelector == null) {
                    ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createDurableConsumer((Topic)consumerContext.getDest(), name));
                } else {
                    ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createDurableConsumer((Topic)consumerContext.getDest(), name, messageSelector, noLocal));
                }
            } else if (durable && shared) {
                if (messageSelector == null) {
                    ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createSharedDurableConsumer((Topic)consumerContext.getDest(), name));
                } else {
                    ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createSharedDurableConsumer((Topic)consumerContext.getDest(), name, messageSelector));
                }
            } else if (shared) {
                if (messageSelector == null) {
                    ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createSharedConsumer((Topic)consumerContext.getDest(), name));
                } else {
                    ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createSharedConsumer((Topic)consumerContext.getDest(), name, messageSelector));
                }
            } else if (messageSelector == null) {
                ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createConsumer(consumerContext.getDest()));
            } else {
                ((ConsumerContext)consumerContext).setConsumer(consumerContext.getJmsContext().createConsumer(consumerContext.getDest(), messageSelector, noLocal));
            }
            this.sessionCtxs.put(consId, consumerContext);
            restClientCtx.addSessionCtxNames(consId);
            if (!consumerContext.getJmsContext().getAutoStart()) {
                consumerContext.getJmsContext().start();
            }
        }
        return consId;
    }

    private void setMapMessage(Map<String, Object> jsonMap, MapMessage msg) throws Exception {
        if (jsonMap == null) {
            return;
        }
        block26: for (String key : jsonMap.keySet()) {
            Object value;
            block30: {
                value = jsonMap.get(key);
                if (value instanceof ArrayList) {
                    ArrayList array = (ArrayList)value;
                    try {
                        if (array.size() != 2) break block30;
                        String className = (String)array.get(1);
                        Constructor<?> constructor = Class.forName(className).getConstructor(String.class);
                        value = constructor.newInstance(array.get(0));
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(BasicLevel.ERROR)) continue;
                        logger.log(BasicLevel.ERROR, (Object)("setMapMessage: ignore map entry " + key + ", " + value + " : " + e.getMessage()));
                        continue;
                    }
                }
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("setMapMessage: " + key + ", value = " + value + ", " + value.getClass().getSimpleName()));
            }
            switch (value.getClass().getSimpleName()) {
                case "String": {
                    msg.setString(key, (String)value);
                    continue block26;
                }
                case "Boolean": {
                    msg.setBoolean(key, ((Boolean)value).booleanValue());
                    continue block26;
                }
                case "Integer": {
                    msg.setInt(key, ((Integer)value).intValue());
                    continue block26;
                }
                case "Double": {
                    msg.setDouble(key, ((Double)value).doubleValue());
                    continue block26;
                }
                case "Float": {
                    msg.setFloat(key, ((Float)value).floatValue());
                    continue block26;
                }
                case "Short": {
                    msg.setShort(key, ((Short)value).shortValue());
                    continue block26;
                }
                case "Char": {
                    msg.setChar(key, ((Character)value).charValue());
                    continue block26;
                }
                case "Byte": {
                    msg.setByte(key, ((Byte)value).byteValue());
                    continue block26;
                }
                case "Bytes": {
                    msg.setBytes(key, (byte[])value);
                    continue block26;
                }
            }
            try {
                msg.setObjectProperty(key, value);
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.ERROR)) continue;
                logger.log(BasicLevel.ERROR, (Object)("ignore jms setObjectProperties(" + key + ", " + value + ") : " + e.getMessage()));
            }
        }
    }

    private Object getValue(Map map, String key) throws Exception {
        Object value = map.get(key);
        if (value instanceof ArrayList) {
            ArrayList array = (ArrayList)value;
            try {
                if (array.size() == 2) {
                    String className = (String)array.get(1);
                    Constructor<?> constructor = Class.forName(className).getConstructor(String.class);
                    value = constructor.newInstance(array.get(0));
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(BasicLevel.ERROR)) {
                    logger.log(BasicLevel.ERROR, (Object)("getValue(" + key + ", " + value + ") : " + e.getMessage()));
                }
                throw e;
            }
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long send(String prodName, String type, Map<String, Object> jmsHeaders, Map<String, Object> jmsProps, Object jmsBody, int deliveryMode, long deliveryTime, int priority, long timeToLive, String correlationID) throws Exception {
        try {
            Object value;
            ProducerContext producerCtx = (ProducerContext)this.sessionCtxs.get(prodName);
            if (producerCtx == null) {
                throw new Exception(prodName + " not found.");
            }
            TextMessage msg = null;
            if (type.equals(TextMessage.class.getSimpleName())) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("send text message = " + jmsBody));
                }
                msg = producerCtx.getJmsContext().createTextMessage((String)jmsBody);
            } else if (type.equals(BytesMessage.class.getSimpleName())) {
                if (!(jmsBody instanceof ArrayList)) throw new Exception("BytesMessage: invalid jmsBody = " + jmsBody.getClass().getName());
                msg = producerCtx.getJmsContext().createBytesMessage();
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("send bytes message = " + jmsBody));
                }
                byte[] bytes = new byte[((ArrayList)jmsBody).size()];
                for (int i = 0; i < ((ArrayList)jmsBody).size(); ++i) {
                    value = ((ArrayList)jmsBody).get(i);
                    bytes[i] = ((Number)value).byteValue();
                }
                ((BytesMessage)msg).writeBytes(bytes);
                ((BytesMessage)msg).reset();
            } else if (type.equals(MapMessage.class.getSimpleName())) {
                if (!(jmsBody instanceof Map)) throw new Exception("MapMessage: invalid jmsBody = " + jmsBody.getClass().getName());
                msg = producerCtx.getJmsContext().createMapMessage();
                this.setMapMessage((Map)jmsBody, (MapMessage)msg);
            } else {
                if (type.equals(ObjectMessage.class.getSimpleName())) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) throw new Exception("type: " + type + ", not yet implemented");
                    logger.log(BasicLevel.DEBUG, (Object)("send object message = " + jmsBody));
                    throw new Exception("type: " + type + ", not yet implemented");
                }
                if (!type.equals(StreamMessage.class.getSimpleName())) throw new Exception("Unknown message type: " + type);
                throw new Exception("type: " + type + ", not yet implemented");
            }
            if (jmsHeaders != null) {
                Object value2;
                if (deliveryMode == -1 && (value2 = (Integer)this.getValue(jmsHeaders, "DeliveryMode")) != null) {
                    msg.setJMSDeliveryMode(((Integer)value2).intValue());
                }
                if (deliveryTime == -1L && (value2 = (Long)this.getValue(jmsHeaders, "DeliveryTime")) != null) {
                    msg.setJMSDeliveryTime(((Long)value2).longValue());
                }
                if (priority == -1 && (value2 = (Integer)this.getValue(jmsHeaders, "Priority")) != null) {
                    msg.setJMSPriority(((Integer)value2).intValue());
                }
                if (timeToLive == -1L && (value2 = (Long)this.getValue(jmsHeaders, "Expiration")) != null) {
                    msg.setJMSExpiration(((Long)value2).longValue());
                }
                if (correlationID == null && (value2 = (String)this.getValue(jmsHeaders, "CorrelationID")) != null) {
                    msg.setJMSCorrelationID((String)value2);
                }
            }
            if (jmsProps != null) {
                block25: for (String key : jmsProps.keySet()) {
                    value = null;
                    try {
                        value = this.getValue(jmsProps, key);
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(BasicLevel.ERROR)) continue;
                        logger.log(BasicLevel.ERROR, (Object)("ignore set jms properties(" + key + ", " + value + ") : " + e.getMessage()));
                        continue;
                    }
                    if (value == null) continue;
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("set jms properties: " + key + ", value = " + value + ", " + value.getClass().getSimpleName()));
                    }
                    switch (value.getClass().getSimpleName()) {
                        case "String": {
                            msg.setStringProperty(key, (String)value);
                            continue block25;
                        }
                        case "Boolean": {
                            msg.setBooleanProperty(key, ((Boolean)value).booleanValue());
                            continue block25;
                        }
                        case "Integer": {
                            msg.setIntProperty(key, ((Integer)value).intValue());
                            continue block25;
                        }
                        case "Double": {
                            msg.setDoubleProperty(key, ((Double)value).doubleValue());
                            continue block25;
                        }
                        case "Float": {
                            msg.setFloatProperty(key, ((Float)value).floatValue());
                            continue block25;
                        }
                        case "Short": {
                            msg.setShortProperty(key, ((Short)value).shortValue());
                            continue block25;
                        }
                        case "Byte": {
                            msg.setByteProperty(key, ((Byte)value).byteValue());
                            continue block25;
                        }
                    }
                    try {
                        msg.setObjectProperty(key, value);
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(BasicLevel.ERROR)) continue;
                        logger.log(BasicLevel.ERROR, (Object)("ignore jms setObjectProperties(" + key + ", " + value + ") : " + e.getMessage()));
                    }
                }
            }
            if (deliveryMode > -1) {
                msg.setJMSDeliveryMode(deliveryMode);
            }
            if (deliveryTime > -1L) {
                msg.setJMSDeliveryTime(deliveryTime);
            }
            if (priority > -1) {
                msg.setJMSPriority(priority);
            }
            if (timeToLive > -1L) {
                msg.setJMSExpiration(timeToLive);
            }
            if (correlationID != null) {
                msg.setJMSCorrelationID(correlationID);
            }
            producerCtx.getProducer().send(producerCtx.getDest(), (Message)msg);
            producerCtx.incLastId();
            producerCtx.getClientCtx().setLastActivity(System.currentTimeMillis());
            return producerCtx.getLastId();
        }
        catch (Exception e) {
            if (!logger.isLoggable(BasicLevel.WARN)) throw e;
            logger.log(BasicLevel.WARN, (Object)e);
            throw e;
        }
    }

    public Message consume(String consName, long timeout, boolean noLocal, boolean durable, boolean shared, String name, long msgId) throws Exception {
        ConsumerContext consumerCtx = (ConsumerContext)this.sessionCtxs.get(consName);
        if (consumerCtx == null) {
            throw new Exception(consName + " not found.");
        }
        Message message = consumerCtx.getMessage(msgId);
        if (message != null) {
            return message;
        }
        if (timeout > 0L) {
            message = consumerCtx.getConsumer().receive(timeout);
        } else if (timeout == 0L) {
            message = consumerCtx.getConsumer().receiveNoWait();
        } else {
            message = consumerCtx.getConsumer().receive();
            if (message == null) {
                throw new JMSException("The consumer expire (timeout)");
            }
        }
        consumerCtx.getClientCtx().setLastActivity(System.currentTimeMillis());
        if (message == null) {
            return null;
        }
        if (consumerCtx.getJmsContext().getSessionMode() == 2) {
            long id = msgId;
            if (id == -1L) {
                id = consumerCtx.incLastId();
            }
            consumerCtx.put(id, message);
        } else {
            consumerCtx.incLastId();
        }
        return message;
    }

    public String createClientId() {
        return "clientID" + counter.getAndIncrement();
    }

    public String createProducerId() {
        return "prod" + counter.getAndIncrement();
    }

    public String createConsumerId() {
        return "cons" + counter.getAndIncrement();
    }

    public SessionContext getSessionCtx(String name) {
        return this.sessionCtxs.get(name);
    }

    public RestClientContext getClientContext(String id) {
        RestClientContext ret = this.restClientCtxs.get(id);
        if (ret == null) {
            String clientID = id;
            if (clientID == null) {
                clientID = this.createClientId();
            }
            ret = new RestClientContext(clientID);
            this.restClientCtxs.put(clientID, ret);
        }
        return ret;
    }

    public void commit(String name) throws Exception {
        SessionContext ctx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.commit " + name));
        }
        if ((ctx = this.sessionCtxs.get(name)) == null) {
            throw new Exception(name + " not found.");
        }
        if (ctx.getJmsContext().getTransacted()) {
            ctx.getJmsContext().commit();
        }
    }

    public void acknowledgeAllMsg(String consName) throws Exception {
        ConsumerContext consumerCtx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.acknowledgeAllMsg " + consName));
        }
        if ((consumerCtx = (ConsumerContext)this.sessionCtxs.get(consName)) == null) {
            throw new Exception(consName + " not found.");
        }
        if (consumerCtx.getJmsContext().getSessionMode() == 2) {
            consumerCtx.getJmsContext().acknowledge();
            consumerCtx.clear();
        }
    }

    public void acknowledgeMsg(String consName, long id) throws Exception {
        ConsumerContext consumerCtx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Helper.acknowledgeMsg " + consName + ", " + id));
        }
        if ((consumerCtx = (ConsumerContext)this.sessionCtxs.get(consName)) == null) {
            throw new Exception(consName + " not found.");
        }
        if (consumerCtx.getJmsContext().getSessionMode() == 2) {
            Message msg = consumerCtx.getMessage(id);
            msg.acknowledge();
            consumerCtx.removeMessage(id);
        }
    }
}

