/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.utils.ConversionUtils;

public final class FileOutputStreamProxy
extends OutputStream {
    private static final ThreadLocal storeThreadLocal = new ThreadLocal();
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final String name;

    public static void setResourceStore(ResourceStore pStore) {
        storeThreadLocal.set(pStore);
    }

    public FileOutputStreamProxy(File pFile, boolean append) throws FileNotFoundException {
        this("" + pFile);
    }

    public FileOutputStreamProxy(File pFile) throws FileNotFoundException {
        this("" + pFile);
    }

    public FileOutputStreamProxy(FileDescriptor fdObj) {
        throw new RuntimeException();
    }

    public FileOutputStreamProxy(String pName, boolean append) throws FileNotFoundException {
        this(pName);
    }

    public FileOutputStreamProxy(String pName) throws FileNotFoundException {
        this.name = ConversionUtils.getResourceNameFromFileName(pName);
    }

    public void write(int value) throws IOException {
        this.out.write(value);
    }

    public void close() throws IOException {
        this.out.close();
        ResourceStore store = (ResourceStore)storeThreadLocal.get();
        if (store == null) {
            throw new RuntimeException("forgot to set the ResourceStore for this thread?");
        }
        store.write(this.name, this.out.toByteArray());
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }
}

