/**
 * EasyBeans
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: EZBApplicationJNDIResolver.java 2981 2008-04-27 15:58:00Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.easybeans.console.jmxbrowser.service;


public class JMXAttributes {

    private String name = null;

    private String desc = null;

    private String type = null;

    private String value = null;


    private boolean readable = false;

    private boolean writable = false;

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public boolean isWritable() {
        return writable;
    }

    public void setWritable(final boolean writable) {
        this.writable = writable;
    }

    public boolean isReadable() {
        return readable;
    }

    public void setReadable(final boolean readable) {
        this.readable = readable;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(final String desc) {
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public void setValue(final String value) {
        this.value = value;
    }

    public String getType() {
        return type;
    }

    public void setType(final String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(JMXAttributes.class.getSimpleName());
        sb.append("[name='");
        sb.append(name);
        sb.append("', desc='");
        sb.append(desc);
        sb.append("', type='");
        sb.append(type);
        sb.append("', value='");
        sb.append(value);
        sb.append("', isReadable='");
        sb.append(readable);
        sb.append("', isWritable='");
        sb.append(writable);
        sb.append("']");
        return sb.toString();
    }

}
