/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.gridlines;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Typeface;
import java.text.DecimalFormat;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.LinearRing;
import org.osmdroid.views.overlay.Overlay;

public class LatLonGridlineOverlay2
extends Overlay {
    private DecimalFormat mDecimalFormatter = new DecimalFormat("#.#####");
    private float mMultiplier = 1.0f;
    private final Paint mLinePaint = new Paint();
    private final Paint mTextBackgroundPaint = new Paint();
    private final Paint mTextPaint = new Paint();
    private final GeoPoint mOptimizationGeoPoint = new GeoPoint(0.0, 0.0);
    private final Point mOptimizationPoint = new Point();

    public LatLonGridlineOverlay2() {
        this.mLinePaint.setAntiAlias(true);
        this.mLinePaint.setStyle(Paint.Style.STROKE);
        this.mTextBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setStyle(Paint.Style.STROKE);
        this.mTextPaint.setTypeface(Typeface.DEFAULT_BOLD);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.setLineColor(-16777216);
        this.setFontColor(-1);
        this.setBackgroundColor(-16777216);
        this.setLineWidth(1.0f);
        this.setFontSizeDp((short)32);
    }

    @Override
    public void draw(Canvas c, Projection pProjection) {
        if (!this.isEnabled()) {
            return;
        }
        double incrementor = this.getIncrementor((int)pProjection.getZoomLevel());
        GeoPoint mapCenter = pProjection.getCurrentCenter();
        double startLongitude = incrementor * (double)Math.round(mapCenter.getLongitude() / incrementor);
        double startLatitude = this.computeStartLatitude(mapCenter.getLatitude(), incrementor);
        double worldMapSize = pProjection.getWorldMapSize();
        float screenWidth = pProjection.getWidth();
        float screenHeight = pProjection.getHeight();
        float screenCenterX = screenWidth / 2.0f;
        float screenCenterY = screenHeight / 2.0f;
        float screenDiagonal = (float)Math.sqrt(screenWidth * screenWidth + screenHeight * screenHeight);
        double screenRadius = screenDiagonal / 2.0f;
        double squaredScreenRadius = screenRadius * screenRadius;
        float textOffsetX = screenWidth / 5.0f;
        float textOffsetY = screenHeight / 5.0f;
        float textBaseline = -this.mTextPaint.ascent() + 0.5f;
        float textDescent = this.mTextPaint.descent() + 0.5f;
        float textHeight = textBaseline + textDescent;
        for (int lineOrText = 0; lineOrText <= 1; ++lineOrText) {
            for (int latOrLon = 0; latOrLon <= 1; ++latOrLon) {
                float orientation = -pProjection.getOrientation() + (float)(latOrLon == 0 ? 0 : 90);
                for (int increaseOrDecrease = 0; increaseOrDecrease <= 1; ++increaseOrDecrease) {
                    double delta = increaseOrDecrease == 0 ? incrementor : -incrementor;
                    int latest = latOrLon == 0 ? Math.round(screenCenterY) : Math.round(screenCenterX);
                    boolean stillVisible = true;
                    double longitude = startLongitude;
                    double latitude = startLatitude;
                    int i = 0;
                    while (stillVisible) {
                        if (i > 0) {
                            if (latOrLon == 1) {
                                longitude += delta;
                                while (longitude < -180.0) {
                                    longitude += 360.0;
                                }
                                while (longitude > 180.0) {
                                    longitude -= 360.0;
                                }
                            } else if ((latitude += delta) > MapView.getTileSystem().getMaxLatitude()) {
                                latitude = this.computeStartLatitude(MapView.getTileSystem().getMinLatitude(), incrementor);
                            } else if (latitude < MapView.getTileSystem().getMinLatitude()) {
                                latitude = this.computeStartLatitude(MapView.getTileSystem().getMaxLatitude(), incrementor);
                            }
                        }
                        this.mOptimizationGeoPoint.setCoords(latitude, longitude);
                        pProjection.toPixels(this.mOptimizationGeoPoint, this.mOptimizationPoint);
                        if (latOrLon == 0) {
                            this.mOptimizationPoint.y = (int)Math.round(LinearRing.getCloserValue(latest, this.mOptimizationPoint.y, worldMapSize));
                            if (i > 0) {
                                if (delta < 0.0) {
                                    while (this.mOptimizationPoint.y < latest) {
                                        this.mOptimizationPoint.y = (int)((double)this.mOptimizationPoint.y + worldMapSize);
                                    }
                                } else {
                                    while (this.mOptimizationPoint.y > latest) {
                                        this.mOptimizationPoint.y = (int)((double)this.mOptimizationPoint.y - worldMapSize);
                                    }
                                }
                            }
                            latest = this.mOptimizationPoint.y;
                        } else {
                            latest = this.mOptimizationPoint.x = (int)Math.round(LinearRing.getCloserValue(latest, this.mOptimizationPoint.x, worldMapSize));
                        }
                        if (i != 0 || increaseOrDecrease != 1) {
                            double squaredDistanceToCenter;
                            float xB;
                            float xA;
                            float yA;
                            float yB;
                            if (latOrLon == 0) {
                                yA = yB = (float)this.mOptimizationPoint.y;
                                xA = screenCenterX - screenDiagonal;
                                xB = screenCenterX + screenDiagonal;
                                squaredDistanceToCenter = ((float)this.mOptimizationPoint.y - screenCenterY) * ((float)this.mOptimizationPoint.y - screenCenterY);
                            } else {
                                xA = xB = (float)this.mOptimizationPoint.x;
                                yA = screenCenterY - screenDiagonal;
                                yB = screenCenterY + screenDiagonal;
                                squaredDistanceToCenter = ((float)this.mOptimizationPoint.x - screenCenterX) * ((float)this.mOptimizationPoint.x - screenCenterX);
                            }
                            boolean bl = stillVisible = squaredDistanceToCenter <= squaredScreenRadius;
                            if (stillVisible) {
                                if (lineOrText == 0) {
                                    c.drawLine(xA, yA, xB, yB, this.mLinePaint);
                                } else {
                                    String text = this.formatCoordinate(latOrLon == 0 ? latitude : longitude, latOrLon == 0);
                                    float textCenterX = latOrLon == 0 ? textOffsetX : xA;
                                    float textCenterY = latOrLon == 0 ? yA : screenHeight - textOffsetY;
                                    float textWidth = this.mTextPaint.measureText(text) + 0.5f;
                                    if (orientation != 0.0f) {
                                        c.save();
                                        c.rotate(orientation, textCenterX, textCenterY);
                                    }
                                    c.drawRect(textCenterX - textWidth / 2.0f, textCenterY - textHeight / 2.0f, textCenterX + textWidth / 2.0f, textCenterY + textHeight / 2.0f, this.mTextBackgroundPaint);
                                    c.drawText(text, textCenterX, textCenterY + textHeight / 2.0f - textDescent, this.mTextPaint);
                                    if (orientation != 0.0f) {
                                        c.restore();
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public void setDecimalFormatter(DecimalFormat df) {
        this.mDecimalFormatter = df;
    }

    public void setLineColor(int lineColor) {
        this.mLinePaint.setColor(lineColor);
    }

    public void setFontColor(int fontColor) {
        this.mTextPaint.setColor(fontColor);
    }

    public void setFontSizeDp(short fontSizeDp) {
        this.mTextPaint.setTextSize((float)fontSizeDp);
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mTextBackgroundPaint.setColor(backgroundColor);
    }

    public void setLineWidth(float lineWidth) {
        this.mLinePaint.setStrokeWidth(lineWidth);
    }

    public void setMultiplier(float multiplier) {
        this.mMultiplier = multiplier;
    }

    protected double getIncrementor(int zoom) {
        switch (zoom) {
            case 0: 
            case 1: {
                return 30.0 * (double)this.mMultiplier;
            }
            case 2: {
                return 15.0 * (double)this.mMultiplier;
            }
            case 3: {
                return 9.0 * (double)this.mMultiplier;
            }
            case 4: {
                return 6.0 * (double)this.mMultiplier;
            }
            case 5: {
                return 3.0 * (double)this.mMultiplier;
            }
            case 6: {
                return 2.0 * (double)this.mMultiplier;
            }
            case 7: {
                return 1.0 * (double)this.mMultiplier;
            }
            case 8: {
                return 0.5 * (double)this.mMultiplier;
            }
            case 9: {
                return 0.25 * (double)this.mMultiplier;
            }
            case 10: {
                return 0.1 * (double)this.mMultiplier;
            }
            case 11: {
                return 0.05 * (double)this.mMultiplier;
            }
            case 12: {
                return 0.025 * (double)this.mMultiplier;
            }
            case 13: {
                return 0.0125 * (double)this.mMultiplier;
            }
            case 14: {
                return 0.00625 * (double)this.mMultiplier;
            }
            case 15: {
                return 0.003125 * (double)this.mMultiplier;
            }
            case 16: {
                return 0.0015625 * (double)this.mMultiplier;
            }
            case 17: {
                return 7.8125E-4 * (double)this.mMultiplier;
            }
            case 18: {
                return 3.90625E-4 * (double)this.mMultiplier;
            }
            case 19: {
                return 1.953125E-4 * (double)this.mMultiplier;
            }
            case 20: {
                return 9.765625E-5 * (double)this.mMultiplier;
            }
            case 21: {
                return 4.8828125E-5 * (double)this.mMultiplier;
            }
            case 22: {
                return 2.44140625E-5 * (double)this.mMultiplier;
            }
            case 23: {
                return 1.220703125E-5 * (double)this.mMultiplier;
            }
            case 24: {
                return 6.103515625E-6 * (double)this.mMultiplier;
            }
            case 25: {
                return 3.0517578125E-6 * (double)this.mMultiplier;
            }
            case 26: {
                return 1.52587890625E-6 * (double)this.mMultiplier;
            }
            case 27: {
                return 7.62939453125E-7 * (double)this.mMultiplier;
            }
            case 28: {
                return 3.814697265625E-7 * (double)this.mMultiplier;
            }
        }
        return 1.9073486328125E-7 * (double)this.mMultiplier;
    }

    private double computeStartLatitude(double pLatitude, double pIncrementor) {
        double result;
        for (result = pIncrementor * (double)Math.round(pLatitude / pIncrementor); result > MapView.getTileSystem().getMaxLatitude(); result -= pIncrementor) {
        }
        while (result < MapView.getTileSystem().getMinLatitude()) {
            result += pIncrementor;
        }
        return result;
    }

    private String formatCoordinate(double pValue, boolean pLatitudeOrLongitude) {
        return this.mDecimalFormatter.format(pValue) + (pValue == 0.0 ? "" : (pValue > 0.0 ? (pLatitudeOrLongitude ? "N" : "E") : (pLatitudeOrLongitude ? "S" : "W")));
    }
}

