/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.api.IProjection;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.GeometryMath;
import org.osmdroid.util.PointL;
import org.osmdroid.util.RectL;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;

public class Projection
implements IProjection {
    public static final double mProjectedMapSize = 1.152921504606847E18;
    private long mOffsetX;
    private long mOffsetY;
    private long mScrollX;
    private long mScrollY;
    private final Matrix mRotateAndScaleMatrix = new Matrix();
    private final Matrix mUnrotateAndScaleMatrix = new Matrix();
    private final float[] mRotateScalePoints = new float[2];
    private final BoundingBox mBoundingBoxProjection = new BoundingBox();
    private final double mZoomLevelProjection;
    private final Rect mScreenRectProjection = new Rect();
    private final Rect mIntrinsicScreenRectProjection;
    private boolean horizontalWrapEnabled;
    private boolean verticalWrapEnabled;
    private final double mMercatorMapSize;
    private final double mTileSize;
    private final float mOrientation;
    private final GeoPoint mCurrentCenter = new GeoPoint(0.0, 0.0);
    private final TileSystem mTileSystem;
    private final int mMapCenterOffsetX;
    private final int mMapCenterOffsetY;

    Projection(MapView mapView) {
        this(mapView.getZoomLevelDouble(), mapView.getIntrinsicScreenRect(null), mapView.getExpectedCenter(), mapView.getMapScrollX(), mapView.getMapScrollY(), mapView.getMapOrientation(), mapView.isHorizontalMapRepetitionEnabled(), mapView.isVerticalMapRepetitionEnabled(), MapView.getTileSystem(), mapView.getMapCenterOffsetX(), mapView.getMapCenterOffsetY());
    }

    public Projection(double pZoomLevel, Rect pScreenRect, GeoPoint pCenter, long pScrollX, long pScrollY, float pOrientation, boolean pHorizontalWrapEnabled, boolean pVerticalWrapEnabled, TileSystem pTileSystem, int pMapCenterOffsetX, int pMapCenterOffsetY) {
        this.mMapCenterOffsetX = pMapCenterOffsetX;
        this.mMapCenterOffsetY = pMapCenterOffsetY;
        this.mZoomLevelProjection = pZoomLevel;
        this.horizontalWrapEnabled = pHorizontalWrapEnabled;
        this.verticalWrapEnabled = pVerticalWrapEnabled;
        this.mTileSystem = pTileSystem;
        this.mMercatorMapSize = TileSystem.MapSize(this.mZoomLevelProjection);
        this.mTileSize = TileSystem.getTileSize(this.mZoomLevelProjection);
        this.mIntrinsicScreenRectProjection = pScreenRect;
        GeoPoint center = pCenter != null ? pCenter : new GeoPoint(0.0, 0.0);
        this.mScrollX = pScrollX;
        this.mScrollY = pScrollY;
        this.mOffsetX = (long)this.getScreenCenterX() - this.mScrollX - this.mTileSystem.getMercatorXFromLongitude(center.getLongitude(), this.mMercatorMapSize, this.horizontalWrapEnabled);
        this.mOffsetY = (long)this.getScreenCenterY() - this.mScrollY - this.mTileSystem.getMercatorYFromLatitude(center.getLatitude(), this.mMercatorMapSize, this.verticalWrapEnabled);
        this.mOrientation = pOrientation;
        this.mRotateAndScaleMatrix.preRotate(this.mOrientation, (float)this.getScreenCenterX(), (float)this.getScreenCenterY());
        this.mRotateAndScaleMatrix.invert(this.mUnrotateAndScaleMatrix);
        this.refresh();
    }

    public Projection(double pZoomLevel, int pWidth, int pHeight, GeoPoint pCenter, float pOrientation, boolean pHorizontalWrapEnabled, boolean pVerticalWrapEnabled, int pMapCenterOffsetX, int pMapCenterOffsetY) {
        this(pZoomLevel, new Rect(0, 0, pWidth, pHeight), pCenter, 0L, 0L, pOrientation, pHorizontalWrapEnabled, pVerticalWrapEnabled, MapView.getTileSystem(), pMapCenterOffsetX, pMapCenterOffsetY);
    }

    public Projection getOffspring(double pZoomLevel, Rect pScreenRect) {
        return new Projection(pZoomLevel, pScreenRect, this.mCurrentCenter, 0L, 0L, this.mOrientation, this.horizontalWrapEnabled, this.verticalWrapEnabled, this.mTileSystem, 0, 0);
    }

    public double getZoomLevel() {
        return this.mZoomLevelProjection;
    }

    public BoundingBox getBoundingBox() {
        return this.mBoundingBoxProjection;
    }

    public Rect getScreenRect() {
        return this.mScreenRectProjection;
    }

    public Rect getIntrinsicScreenRect() {
        return this.mIntrinsicScreenRectProjection;
    }

    @Override
    public IGeoPoint fromPixels(int x, int y) {
        return this.fromPixels(x, y, null, false);
    }

    public IGeoPoint fromPixels(int pPixelX, int pPixelY, GeoPoint pReuse) {
        return this.fromPixels(pPixelX, pPixelY, pReuse, false);
    }

    public IGeoPoint fromPixels(int pPixelX, int pPixelY, GeoPoint pReuse, boolean forceWrap) {
        return this.mTileSystem.getGeoFromMercator(this.getCleanMercator(this.getMercatorXFromPixel(pPixelX), this.horizontalWrapEnabled), this.getCleanMercator(this.getMercatorYFromPixel(pPixelY), this.verticalWrapEnabled), this.mMercatorMapSize, pReuse, this.horizontalWrapEnabled || forceWrap, this.verticalWrapEnabled || forceWrap);
    }

    @Override
    public Point toPixels(IGeoPoint in, Point reuse) {
        return this.toPixels(in, reuse, false);
    }

    public Point toPixels(IGeoPoint in, Point reuse, boolean forceWrap) {
        Point out = reuse != null ? reuse : new Point();
        out.x = TileSystem.truncateToInt(this.getLongPixelXFromLongitude(in.getLongitude(), forceWrap));
        out.y = TileSystem.truncateToInt(this.getLongPixelYFromLatitude(in.getLatitude(), forceWrap));
        return out;
    }

    public long getLongPixelXFromLongitude(double pLongitude, boolean forceWrap) {
        return this.getLongPixelXFromMercator(this.mTileSystem.getMercatorXFromLongitude(pLongitude, this.mMercatorMapSize, this.horizontalWrapEnabled || forceWrap), this.horizontalWrapEnabled);
    }

    public long getLongPixelXFromLongitude(double pLongitude) {
        return this.getLongPixelXFromMercator(this.mTileSystem.getMercatorXFromLongitude(pLongitude, this.mMercatorMapSize, false), false);
    }

    public long getLongPixelYFromLatitude(double pLatitude, boolean forceWrap) {
        return this.getLongPixelYFromMercator(this.mTileSystem.getMercatorYFromLatitude(pLatitude, this.mMercatorMapSize, this.verticalWrapEnabled || forceWrap), this.verticalWrapEnabled);
    }

    public long getLongPixelYFromLatitude(double pLatitude) {
        return this.getLongPixelYFromMercator(this.mTileSystem.getMercatorYFromLatitude(pLatitude, this.mMercatorMapSize, false), false);
    }

    public PointL toProjectedPixels(GeoPoint geoPoint, PointL reuse) {
        return this.toProjectedPixels(geoPoint.getLatitude(), geoPoint.getLongitude(), reuse);
    }

    @Deprecated
    public PointL toProjectedPixels(long latituteE6, long longitudeE6, PointL reuse) {
        return this.toProjectedPixels((double)latituteE6 * 1.0E-6, (double)longitudeE6 * 1.0E-6, reuse);
    }

    public PointL toProjectedPixels(double latitude, double longitude, PointL reuse) {
        return this.toProjectedPixels(latitude, longitude, true, reuse);
    }

    public PointL toProjectedPixels(double latitude, double longitude, boolean pWrapEnabled, PointL reuse) {
        return this.mTileSystem.getMercatorFromGeo(latitude, longitude, 1.152921504606847E18, reuse, pWrapEnabled);
    }

    @Deprecated
    public Point toPixelsFromProjected(PointL in, Point reuse) {
        Point out = reuse != null ? reuse : new Point();
        double power = this.getProjectedPowerDifference();
        PointL tmp = new PointL();
        this.getLongPixelsFromProjected(in, power, true, tmp);
        out.x = TileSystem.truncateToInt(tmp.x);
        out.y = TileSystem.truncateToInt(tmp.y);
        return out;
    }

    @Deprecated
    public Point toPixelsFromMercator(long pMercatorX, long pMercatorY, Point reuse) {
        Point out = reuse != null ? reuse : new Point();
        out.x = TileSystem.truncateToInt(this.getLongPixelXFromMercator(pMercatorX, true));
        out.y = TileSystem.truncateToInt(this.getLongPixelYFromMercator(pMercatorY, true));
        return out;
    }

    public PointL toMercatorPixels(int pPixelX, int pPixelY, PointL reuse) {
        PointL out = reuse != null ? reuse : new PointL();
        out.x = this.getCleanMercator(this.getMercatorXFromPixel(pPixelX), this.horizontalWrapEnabled);
        out.y = this.getCleanMercator(this.getMercatorYFromPixel(pPixelY), this.verticalWrapEnabled);
        return out;
    }

    @Override
    public float metersToEquatorPixels(float meters) {
        return this.metersToPixels(meters, 0.0, this.mZoomLevelProjection);
    }

    public float metersToPixels(float meters) {
        return this.metersToPixels(meters, this.getBoundingBox().getCenterWithDateLine().getLatitude(), this.mZoomLevelProjection);
    }

    public float metersToPixels(float meters, double latitude, double zoomLevel) {
        return (float)((double)meters / TileSystem.GroundResolution(latitude, zoomLevel));
    }

    @Override
    public IGeoPoint getNorthEast() {
        return this.fromPixels(this.mIntrinsicScreenRectProjection.right, this.mIntrinsicScreenRectProjection.top, null, true);
    }

    @Override
    public IGeoPoint getSouthWest() {
        return this.fromPixels(this.mIntrinsicScreenRectProjection.left, this.mIntrinsicScreenRectProjection.bottom, null, true);
    }

    public Matrix getInvertedScaleRotateCanvasMatrix() {
        return this.mUnrotateAndScaleMatrix;
    }

    public Point unrotateAndScalePoint(int x, int y, Point reuse) {
        return this.applyMatrixToPoint(x, y, reuse, this.mUnrotateAndScaleMatrix, this.mOrientation != 0.0f);
    }

    public Point rotateAndScalePoint(int x, int y, Point reuse) {
        return this.applyMatrixToPoint(x, y, reuse, this.mRotateAndScaleMatrix, this.mOrientation != 0.0f);
    }

    private Point applyMatrixToPoint(int pX, int pY, Point reuse, Matrix pMatrix, boolean pCondition) {
        Point out;
        Point point = out = reuse != null ? reuse : new Point();
        if (pCondition) {
            this.mRotateScalePoints[0] = pX;
            this.mRotateScalePoints[1] = pY;
            pMatrix.mapPoints(this.mRotateScalePoints);
            out.x = (int)this.mRotateScalePoints[0];
            out.y = (int)this.mRotateScalePoints[1];
        } else {
            out.x = pX;
            out.y = pY;
        }
        return out;
    }

    public void detach() {
    }

    public Rect getPixelFromTile(int pTileX, int pTileY, Rect pReuse) {
        Rect out = pReuse != null ? pReuse : new Rect();
        out.left = TileSystem.truncateToInt(this.getLongPixelXFromMercator(this.getMercatorFromTile(pTileX), false));
        out.top = TileSystem.truncateToInt(this.getLongPixelYFromMercator(this.getMercatorFromTile(pTileY), false));
        out.right = TileSystem.truncateToInt(this.getLongPixelXFromMercator(this.getMercatorFromTile(pTileX + 1), false));
        out.bottom = TileSystem.truncateToInt(this.getLongPixelYFromMercator(this.getMercatorFromTile(pTileY + 1), false));
        return out;
    }

    public long getMercatorFromTile(int pTile) {
        return TileSystem.getMercatorFromTile(pTile, this.mTileSize);
    }

    public Matrix getScaleRotateCanvasMatrix() {
        return this.mRotateAndScaleMatrix;
    }

    public double getProjectedPowerDifference() {
        return 1.152921504606847E18 / this.getWorldMapSize();
    }

    @Deprecated
    public Point getPixelsFromProjected(PointL in, double powerDifference, Point reuse) {
        Point out = reuse != null ? reuse : new Point();
        PointL tmp = new PointL();
        this.getLongPixelsFromProjected(in, powerDifference, true, tmp);
        out.x = TileSystem.truncateToInt(tmp.x);
        out.y = TileSystem.truncateToInt(tmp.y);
        return out;
    }

    public PointL getLongPixelsFromProjected(PointL in, double powerDifference, boolean pCloser, PointL reuse) {
        PointL out = reuse != null ? reuse : new PointL();
        out.x = this.getLongPixelXFromMercator((long)((double)in.x / powerDifference), pCloser);
        out.y = this.getLongPixelYFromMercator((long)((double)in.y / powerDifference), pCloser);
        return out;
    }

    private long getCloserPixel(long pPixel, int pScreenLimitFirst, int pScreenLimitLast, double pMapSize) {
        long center = (pScreenLimitFirst + pScreenLimitLast) / 2;
        long previous = 0L;
        if (pPixel < (long)pScreenLimitFirst) {
            while (pPixel < (long)pScreenLimitFirst) {
                previous = pPixel;
                pPixel = (long)((double)pPixel + pMapSize);
            }
            if (pPixel < (long)pScreenLimitLast) {
                return pPixel;
            }
            if (Math.abs(center - pPixel) < Math.abs(center - previous)) {
                return pPixel;
            }
            return previous;
        }
        while (pPixel >= (long)pScreenLimitFirst) {
            previous = pPixel;
            pPixel = (long)((double)pPixel - pMapSize);
        }
        if (previous < (long)pScreenLimitLast) {
            return previous;
        }
        if (Math.abs(center - pPixel) < Math.abs(center - previous)) {
            return pPixel;
        }
        return previous;
    }

    private long getLongPixelXFromMercator(long pMercatorX, boolean pCloser) {
        return this.getLongPixelFromMercator(pMercatorX, pCloser, this.mOffsetX, this.mIntrinsicScreenRectProjection.left, this.mIntrinsicScreenRectProjection.right);
    }

    private long getLongPixelYFromMercator(long pMercatorY, boolean pCloser) {
        return this.getLongPixelFromMercator(pMercatorY, pCloser, this.mOffsetY, this.mIntrinsicScreenRectProjection.top, this.mIntrinsicScreenRectProjection.bottom);
    }

    private long getLongPixelFromMercator(long pMercator, boolean pCloser, long pOffset, int pScreenLimitFirst, int pScreenLimitLast) {
        long result = pMercator + pOffset;
        if (pCloser) {
            result = this.getCloserPixel(result, pScreenLimitFirst, pScreenLimitLast, this.mMercatorMapSize);
        }
        return result;
    }

    public int getTileFromMercator(long pMercator) {
        return TileSystem.getTileFromMercator(pMercator, this.mTileSize);
    }

    public RectL getMercatorViewPort(RectL pReuse) {
        RectL out = pReuse != null ? pReuse : new RectL();
        float left = this.mIntrinsicScreenRectProjection.left;
        float right = this.mIntrinsicScreenRectProjection.right;
        float top = this.mIntrinsicScreenRectProjection.top;
        float bottom = this.mIntrinsicScreenRectProjection.bottom;
        if (this.mOrientation != 0.0f) {
            float[] scaleRotatePoints = new float[]{this.mIntrinsicScreenRectProjection.left, this.mIntrinsicScreenRectProjection.top, this.mIntrinsicScreenRectProjection.right, this.mIntrinsicScreenRectProjection.bottom, this.mIntrinsicScreenRectProjection.left, this.mIntrinsicScreenRectProjection.bottom, this.mIntrinsicScreenRectProjection.right, this.mIntrinsicScreenRectProjection.top};
            this.mUnrotateAndScaleMatrix.mapPoints(scaleRotatePoints);
            for (int i = 0; i < 8; i += 2) {
                if (left > scaleRotatePoints[i]) {
                    left = scaleRotatePoints[i];
                }
                if (right < scaleRotatePoints[i]) {
                    right = scaleRotatePoints[i];
                }
                if (top > scaleRotatePoints[i + 1]) {
                    top = scaleRotatePoints[i + 1];
                }
                if (!(bottom < scaleRotatePoints[i + 1])) continue;
                bottom = scaleRotatePoints[i + 1];
            }
        }
        out.left = this.getMercatorXFromPixel((int)left);
        out.top = this.getMercatorYFromPixel((int)top);
        out.right = this.getMercatorXFromPixel((int)right);
        out.bottom = this.getMercatorYFromPixel((int)bottom);
        return out;
    }

    public int getScreenCenterX() {
        return (this.mIntrinsicScreenRectProjection.right + this.mIntrinsicScreenRectProjection.left) / 2 + this.mMapCenterOffsetX;
    }

    public int getScreenCenterY() {
        return (this.mIntrinsicScreenRectProjection.bottom + this.mIntrinsicScreenRectProjection.top) / 2 + this.mMapCenterOffsetY;
    }

    public long getMercatorXFromPixel(int pPixelX) {
        return (long)pPixelX - this.mOffsetX;
    }

    public long getMercatorYFromPixel(int pPixelY) {
        return (long)pPixelY - this.mOffsetY;
    }

    public long getCleanMercator(long pMercator, boolean wrapEnabled) {
        return this.mTileSystem.getCleanMercator(pMercator, this.mMercatorMapSize, wrapEnabled);
    }

    public GeoPoint getCurrentCenter() {
        return this.mCurrentCenter;
    }

    public long getOffsetX() {
        return this.mOffsetX;
    }

    public long getOffsetY() {
        return this.mOffsetY;
    }

    public void save(Canvas pCanvas, boolean pMapRotation, boolean pForce) {
        if (this.mOrientation != 0.0f || pForce) {
            pCanvas.save();
            pCanvas.concat(pMapRotation ? this.mRotateAndScaleMatrix : this.mUnrotateAndScaleMatrix);
        }
    }

    public void restore(Canvas pCanvas, boolean pForce) {
        if (this.mOrientation != 0.0f || pForce) {
            pCanvas.restore();
        }
    }

    private void refresh() {
        IGeoPoint swGeoPoint;
        this.fromPixels(this.getScreenCenterX(), this.getScreenCenterY(), this.mCurrentCenter);
        IGeoPoint neGeoPoint = this.fromPixels(this.mIntrinsicScreenRectProjection.right, this.mIntrinsicScreenRectProjection.top, null, true);
        TileSystem tileSystem = MapView.getTileSystem();
        if (neGeoPoint.getLatitude() > tileSystem.getMaxLatitude()) {
            neGeoPoint = new GeoPoint(tileSystem.getMaxLatitude(), neGeoPoint.getLongitude());
        }
        if (neGeoPoint.getLatitude() < tileSystem.getMinLatitude()) {
            neGeoPoint = new GeoPoint(tileSystem.getMinLatitude(), neGeoPoint.getLongitude());
        }
        if ((swGeoPoint = this.fromPixels(this.mIntrinsicScreenRectProjection.left, this.mIntrinsicScreenRectProjection.bottom, null, true)).getLatitude() > tileSystem.getMaxLatitude()) {
            swGeoPoint = new GeoPoint(tileSystem.getMaxLatitude(), swGeoPoint.getLongitude());
        }
        if (swGeoPoint.getLatitude() < tileSystem.getMinLatitude()) {
            swGeoPoint = new GeoPoint(tileSystem.getMinLatitude(), swGeoPoint.getLongitude());
        }
        this.mBoundingBoxProjection.set(neGeoPoint.getLatitude(), neGeoPoint.getLongitude(), swGeoPoint.getLatitude(), swGeoPoint.getLongitude());
        if (this.mOrientation != 0.0f && this.mOrientation != 180.0f) {
            GeometryMath.getBoundingBoxForRotatatedRectangle(this.mIntrinsicScreenRectProjection, this.getScreenCenterX(), this.getScreenCenterY(), this.mOrientation, this.mScreenRectProjection);
        } else {
            this.mScreenRectProjection.left = this.mIntrinsicScreenRectProjection.left;
            this.mScreenRectProjection.top = this.mIntrinsicScreenRectProjection.top;
            this.mScreenRectProjection.right = this.mIntrinsicScreenRectProjection.right;
            this.mScreenRectProjection.bottom = this.mIntrinsicScreenRectProjection.bottom;
        }
    }

    public void adjustOffsets(IGeoPoint pGeoPoint, PointF pPixel) {
        if (pPixel == null) {
            return;
        }
        if (pGeoPoint == null) {
            return;
        }
        Point unRotatedExpectedPixel = this.unrotateAndScalePoint((int)pPixel.x, (int)pPixel.y, null);
        Point unRotatedActualPixel = this.toPixels(pGeoPoint, null);
        long deltaX = unRotatedExpectedPixel.x - unRotatedActualPixel.x;
        long deltaY = unRotatedExpectedPixel.y - unRotatedActualPixel.y;
        this.adjustOffsets(deltaX, deltaY);
    }

    @Deprecated
    public void adjustOffsets(BoundingBox pBoundingBox) {
        if (pBoundingBox == null) {
            return;
        }
        this.adjustOffsets(pBoundingBox.getLonWest(), pBoundingBox.getLonEast(), false, 0);
        this.adjustOffsets(pBoundingBox.getActualNorth(), pBoundingBox.getActualSouth(), true, 0);
    }

    void adjustOffsets(double pNorthOrWest, double pSouthOrEast, boolean isLatitude, int pExtraSize) {
        long deltaY;
        long deltaX;
        if (isLatitude) {
            long min = this.getLongPixelYFromLatitude(pNorthOrWest);
            long max = this.getLongPixelYFromLatitude(pSouthOrEast);
            deltaX = 0L;
            deltaY = Projection.getScrollableOffset(min, max, this.mMercatorMapSize, this.mIntrinsicScreenRectProjection.height(), pExtraSize);
        } else {
            long min = this.getLongPixelXFromLongitude(pNorthOrWest);
            long max = this.getLongPixelXFromLongitude(pSouthOrEast);
            deltaX = Projection.getScrollableOffset(min, max, this.mMercatorMapSize, this.mIntrinsicScreenRectProjection.width(), pExtraSize);
            deltaY = 0L;
        }
        this.adjustOffsets(deltaX, deltaY);
    }

    void adjustOffsets(long pDeltaX, long pDeltaY) {
        if (pDeltaX == 0L && pDeltaY == 0L) {
            return;
        }
        this.mOffsetX += pDeltaX;
        this.mOffsetY += pDeltaY;
        this.mScrollX -= pDeltaX;
        this.mScrollY -= pDeltaY;
        this.refresh();
    }

    public static long getScrollableOffset(long pPixelMin, long pPixelMax, double pWorldSize, int pScreenSize, int pExtraSize) {
        while (pPixelMax - pPixelMin < 0L) {
            pPixelMax = (long)((double)pPixelMax + pWorldSize);
        }
        if (pPixelMax - pPixelMin < (long)(pScreenSize - 2 * pExtraSize)) {
            long half = (pPixelMax - pPixelMin) / 2L;
            long delta = (long)(pScreenSize / 2) - half - pPixelMin;
            if (delta > 0L) {
                return delta;
            }
            delta = (long)(pScreenSize / 2) + half - pPixelMax;
            if (delta < 0L) {
                return delta;
            }
            return 0L;
        }
        long delta = (long)pExtraSize - pPixelMin;
        if (delta < 0L) {
            return delta;
        }
        delta = (long)(pScreenSize - pExtraSize) - pPixelMax;
        if (delta > 0L) {
            return delta;
        }
        return 0L;
    }

    boolean setMapScroll(MapView pMapView) {
        if (pMapView.getMapScrollX() == this.mScrollX && pMapView.getMapScrollY() == this.mScrollY) {
            return false;
        }
        pMapView.setMapScroll(this.mScrollX, this.mScrollY);
        return true;
    }

    public boolean isHorizontalWrapEnabled() {
        return this.horizontalWrapEnabled;
    }

    public boolean isVerticalWrapEnabled() {
        return this.verticalWrapEnabled;
    }

    public float getOrientation() {
        return this.mOrientation;
    }

    public int getWidth() {
        return this.mIntrinsicScreenRectProjection.width();
    }

    public int getHeight() {
        return this.mIntrinsicScreenRectProjection.height();
    }

    public double getWorldMapSize() {
        return this.mMercatorMapSize;
    }
}

