/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import org.osmdroid.util.PointAccepter;
import org.osmdroid.util.PointL;

public class SideOptimizationPointAccepter
implements PointAccepter {
    private static final int STATUS_DIFFERENT = 0;
    private static final int STATUS_SAME_X = 1;
    private static final int STATUS_SAME_Y = 2;
    private final PointL mLatestPoint = new PointL();
    private final PointL mStartPoint = new PointL();
    private final PointAccepter mPointAccepter;
    private boolean mFirst;
    private long mMin;
    private long mMax;
    private int mStatus;

    public SideOptimizationPointAccepter(PointAccepter pPointAccepter) {
        this.mPointAccepter = pPointAccepter;
    }

    @Override
    public void init() {
        this.mFirst = true;
        this.mStatus = 0;
        this.mPointAccepter.init();
    }

    @Override
    public void add(long pX, long pY) {
        if (this.mFirst) {
            this.mFirst = false;
            this.addToAccepter(pX, pY);
            this.mLatestPoint.set(pX, pY);
            return;
        }
        if (this.mLatestPoint.x == pX && this.mLatestPoint.y == pY) {
            return;
        }
        if (this.mLatestPoint.x == pX) {
            if (this.mStatus == 1) {
                if (this.mMin > pY) {
                    this.mMin = pY;
                }
                if (this.mMax < pY) {
                    this.mMax = pY;
                }
            } else {
                this.flushSides();
                this.mStatus = 1;
                this.mStartPoint.set(this.mLatestPoint);
                this.mMin = Math.min(pY, this.mLatestPoint.y);
                this.mMax = Math.max(pY, this.mLatestPoint.y);
            }
        } else if (this.mLatestPoint.y == pY) {
            if (this.mStatus == 2) {
                if (this.mMin > pX) {
                    this.mMin = pX;
                }
                if (this.mMax < pX) {
                    this.mMax = pX;
                }
            } else {
                this.flushSides();
                this.mStatus = 2;
                this.mStartPoint.set(this.mLatestPoint);
                this.mMin = Math.min(pX, this.mLatestPoint.x);
                this.mMax = Math.max(pX, this.mLatestPoint.x);
            }
        } else {
            this.flushSides();
            this.addToAccepter(pX, pY);
        }
        this.mLatestPoint.set(pX, pY);
    }

    @Override
    public void end() {
        this.flushSides();
        this.mPointAccepter.end();
    }

    private void flushSides() {
        switch (this.mStatus) {
            case 0: {
                break;
            }
            case 1: {
                long segmentMax;
                long segmentMin;
                long x = this.mStartPoint.x;
                if (this.mStartPoint.y <= this.mLatestPoint.y) {
                    segmentMin = this.mStartPoint.y;
                    segmentMax = this.mLatestPoint.y;
                } else {
                    segmentMin = this.mLatestPoint.y;
                    segmentMax = this.mStartPoint.y;
                }
                if (this.mMin < segmentMin) {
                    this.addToAccepter(x, this.mMin);
                }
                if (this.mMax > segmentMax) {
                    this.addToAccepter(x, this.mMax);
                }
                this.addToAccepter(x, this.mLatestPoint.y);
                break;
            }
            case 2: {
                long segmentMax;
                long segmentMin;
                long y = this.mStartPoint.y;
                if (this.mStartPoint.x <= this.mLatestPoint.x) {
                    segmentMin = this.mStartPoint.x;
                    segmentMax = this.mLatestPoint.x;
                } else {
                    segmentMin = this.mLatestPoint.x;
                    segmentMax = this.mStartPoint.x;
                }
                if (this.mMin < segmentMin) {
                    this.addToAccepter(this.mMin, y);
                }
                if (this.mMax > segmentMax) {
                    this.addToAccepter(this.mMax, y);
                }
                this.addToAccepter(this.mLatestPoint.x, y);
            }
        }
        this.mStatus = 0;
    }

    private void addToAccepter(long pX, long pY) {
        this.mPointAccepter.add(pX, pY);
    }
}

