/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.modules.CantContinueException;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.tilesource.BitmapTileSourceBase;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.tileprovider.util.Counters;
import org.osmdroid.tileprovider.util.StreamUtils;
import org.osmdroid.util.MapTileIndex;

public class TileDownloader {
    public Drawable downloadTile(long pMapTileIndex, IFilesystemCache pFilesystemCache, OnlineTileSourceBase pTileSource) throws CantContinueException {
        return this.downloadTile(pMapTileIndex, 0, pTileSource.getTileURLString(pMapTileIndex), pFilesystemCache, pTileSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Drawable downloadTile(long pMapTileIndex, int redirectCount, String targetUrl, IFilesystemCache pFilesystemCache, OnlineTileSourceBase pTileSource) throws CantContinueException {
        Drawable drawable;
        ByteArrayOutputStream dataStream;
        ByteArrayInputStream byteStream;
        HttpURLConnection c;
        BufferedOutputStream out;
        InputStream in;
        block54: {
            String redirectUrl;
            block53: {
                Drawable drawable2;
                block52: {
                    if (redirectCount > 3) {
                        return null;
                    }
                    String userAgent = null;
                    if (pTileSource.getTileSourcePolicy().normalizesUserAgent()) {
                        userAgent = Configuration.getInstance().getNormalizedUserAgent();
                    }
                    if (userAgent == null) {
                        userAgent = Configuration.getInstance().getUserAgentValue();
                    }
                    if (!pTileSource.getTileSourcePolicy().acceptsUserAgent(userAgent)) {
                        Log.e((String)"OsmDroid", (String)("Please configure a relevant user agent; current value is: " + userAgent));
                        return null;
                    }
                    in = null;
                    out = null;
                    c = null;
                    byteStream = null;
                    dataStream = null;
                    try {
                        String tileURLString = targetUrl;
                        if (Configuration.getInstance().isDebugMode()) {
                            Log.d((String)"OsmDroid", (String)("Downloading Maptile from url: " + tileURLString));
                        }
                        if (TextUtils.isEmpty((CharSequence)tileURLString)) {
                            Drawable drawable3 = null;
                            return drawable3;
                        }
                        if (Build.VERSION.SDK_INT < 20) {
                            CompatibilitySocketFactory socketFactory = new CompatibilitySocketFactory(HttpsURLConnection.getDefaultSSLSocketFactory());
                            HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
                        }
                        c = Configuration.getInstance().getHttpProxy() != null ? (HttpURLConnection)new URL(tileURLString).openConnection(Configuration.getInstance().getHttpProxy()) : (HttpURLConnection)new URL(tileURLString).openConnection();
                        c.setUseCaches(true);
                        c.setRequestProperty(Configuration.getInstance().getUserAgentHttpHeader(), userAgent);
                        for (Map.Entry entry : Configuration.getInstance().getAdditionalHttpRequestProperties().entrySet()) {
                            c.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                        c.connect();
                        if (c.getResponseCode() != 200) {
                            switch (c.getResponseCode()) {
                                case 301: 
                                case 302: 
                                case 307: 
                                case 308: {
                                    if (Configuration.getInstance().isMapTileDownloaderFollowRedirects()) {
                                        redirectUrl = c.getHeaderField("Location");
                                        if (redirectUrl == null) break;
                                        if (redirectUrl.startsWith("/")) {
                                            URL uRL = new URL(targetUrl);
                                            int port = uRL.getPort();
                                            boolean secure = targetUrl.toLowerCase().startsWith("https://");
                                            if (port == -1) {
                                                port = targetUrl.toLowerCase().startsWith("http://") ? 80 : 443;
                                            }
                                            redirectUrl = (secure ? "https://" : "http") + uRL.getHost() + ":" + port + redirectUrl;
                                        }
                                        Log.i((String)"OsmDroid", (String)("Http redirect for MapTile: " + MapTileIndex.toString(pMapTileIndex) + " HTTP response: " + c.getResponseMessage() + " to url " + redirectUrl));
                                        drawable2 = this.downloadTile(pMapTileIndex, redirectCount + 1, redirectUrl, pFilesystemCache, pTileSource);
                                        StreamUtils.closeStream(in);
                                        break block52;
                                    }
                                }
                                default: {
                                    Log.w((String)"OsmDroid", (String)("Problem downloading MapTile: " + MapTileIndex.toString(pMapTileIndex) + " HTTP response: " + c.getResponseMessage()));
                                    if (Configuration.getInstance().isDebugMapTileDownloader()) {
                                        Log.d((String)"OsmDroid", (String)tileURLString);
                                    }
                                    ++Counters.tileDownloadErrors;
                                    in = c.getErrorStream();
                                    redirectUrl = null;
                                    StreamUtils.closeStream(in);
                                    break block53;
                                }
                            }
                        }
                        String mime = c.getHeaderField("Content-Type");
                        if (Configuration.getInstance().isDebugMapTileDownloader()) {
                            Log.d((String)"OsmDroid", (String)(tileURLString + " success, mime is " + mime));
                        }
                        if (mime != null && !mime.toLowerCase().contains("image")) {
                            Log.w((String)"OsmDroid", (String)(tileURLString + " success, however the mime type does not appear to be an image " + mime));
                        }
                        in = c.getInputStream();
                        dataStream = new ByteArrayOutputStream();
                        out = new BufferedOutputStream(dataStream, 8192);
                        long l = pTileSource.getTileSourcePolicy().computeExpirationTime(c, System.currentTimeMillis());
                        StreamUtils.copy(in, out);
                        ((OutputStream)out).flush();
                        byte[] data = dataStream.toByteArray();
                        byteStream = new ByteArrayInputStream(data);
                        if (pFilesystemCache != null) {
                            pFilesystemCache.saveFile(pTileSource, pMapTileIndex, byteStream, l);
                            byteStream.reset();
                        }
                        drawable = pTileSource.getDrawable(byteStream);
                        StreamUtils.closeStream(in);
                        break block54;
                    }
                    catch (UnknownHostException e) {
                        Log.w((String)"OsmDroid", (String)("UnknownHostException downloading MapTile: " + MapTileIndex.toString(pMapTileIndex) + " : " + e));
                        ++Counters.tileDownloadErrors;
                        return null;
                    }
                    catch (BitmapTileSourceBase.LowMemoryException e) {
                        ++Counters.countOOM;
                        Log.w((String)"OsmDroid", (String)("LowMemoryException downloading MapTile: " + MapTileIndex.toString(pMapTileIndex) + " : " + e));
                        throw new CantContinueException(e);
                    }
                    catch (FileNotFoundException e) {
                        ++Counters.tileDownloadErrors;
                        Log.w((String)"OsmDroid", (String)("Tile not found: " + MapTileIndex.toString(pMapTileIndex) + " : " + e));
                        return null;
                    }
                    catch (IOException e) {
                        ++Counters.tileDownloadErrors;
                        Log.w((String)"OsmDroid", (String)("IOException downloading MapTile: " + MapTileIndex.toString(pMapTileIndex) + " : " + e));
                        return null;
                    }
                    catch (Throwable e) {
                        ++Counters.tileDownloadErrors;
                        Log.e((String)"OsmDroid", (String)("Error downloading MapTile: " + MapTileIndex.toString(pMapTileIndex)), (Throwable)e);
                        return null;
                    }
                }
                StreamUtils.closeStream(out);
                StreamUtils.closeStream(byteStream);
                StreamUtils.closeStream(dataStream);
                try {
                    c.disconnect();
                    return drawable2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return drawable2;
            }
            StreamUtils.closeStream(out);
            StreamUtils.closeStream(byteStream);
            StreamUtils.closeStream(dataStream);
            try {
                c.disconnect();
                return redirectUrl;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return redirectUrl;
        }
        StreamUtils.closeStream(out);
        StreamUtils.closeStream(byteStream);
        StreamUtils.closeStream(dataStream);
        try {
            c.disconnect();
            return drawable;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return drawable;
        finally {
            StreamUtils.closeStream(in);
            StreamUtils.closeStream(out);
            StreamUtils.closeStream(byteStream);
            StreamUtils.closeStream(dataStream);
            try {
                c.disconnect();
            }
            catch (Exception e) {}
        }
    }

    @Deprecated
    public Long getHttpExpiresTime(String pHttpExpiresHeader) {
        block3: {
            if (pHttpExpiresHeader != null && pHttpExpiresHeader.length() > 0) {
                try {
                    Date dateExpires = Configuration.getInstance().getHttpHeaderDateTimeFormat().parse(pHttpExpiresHeader);
                    return dateExpires.getTime();
                }
                catch (Exception ex) {
                    if (!Configuration.getInstance().isDebugMapTileDownloader()) break block3;
                    Log.d((String)"OsmDroid", (String)("Unable to parse expiration tag for tile, server returned " + pHttpExpiresHeader), (Throwable)ex);
                }
            }
        }
        return null;
    }

    @Deprecated
    public Long getHttpCacheControlDuration(String pHttpCacheControlHeader) {
        block4: {
            if (pHttpCacheControlHeader != null && pHttpCacheControlHeader.length() > 0) {
                try {
                    String[] parts = pHttpCacheControlHeader.split(", ");
                    String maxAge = "max-age=";
                    for (String part : parts) {
                        int pos = part.indexOf("max-age=");
                        if (pos != 0) continue;
                        String durationString = part.substring("max-age=".length());
                        return Long.valueOf(durationString);
                    }
                }
                catch (Exception ex) {
                    if (!Configuration.getInstance().isDebugMapTileDownloader()) break block4;
                    Log.d((String)"OsmDroid", (String)("Unable to parse cache control tag for tile, server returned " + pHttpCacheControlHeader), (Throwable)ex);
                }
            }
        }
        return null;
    }

    @Deprecated
    public long computeExpirationTime(String pHttpExpiresHeader, String pHttpCacheControlHeader, long pNow) {
        Long override = Configuration.getInstance().getExpirationOverrideDuration();
        if (override != null) {
            return pNow + override;
        }
        long extension = Configuration.getInstance().getExpirationExtendedDuration();
        Long cacheControlDuration = this.getHttpCacheControlDuration(pHttpCacheControlHeader);
        if (cacheControlDuration != null) {
            return pNow + cacheControlDuration * 1000L + extension;
        }
        Long httpExpiresTime = this.getHttpExpiresTime(pHttpExpiresHeader);
        if (httpExpiresTime != null) {
            return httpExpiresTime + extension;
        }
        return pNow + 604800000L + extension;
    }

    private static class CompatibilitySocketFactory
    extends SSLSocketFactory {
        SSLSocketFactory sslSocketFactory;

        CompatibilitySocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.sslSocketFactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.sslSocketFactory.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket() throws IOException {
            SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket();
            return this.upgradeTlsAndRemoveSsl(socket);
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket(s, host, port, autoClose);
            return this.upgradeTlsAndRemoveSsl(socket);
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket(host, port);
            return this.upgradeTlsAndRemoveSsl(socket);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket(host, port, localHost, localPort);
            return this.upgradeTlsAndRemoveSsl(socket);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket(host, port);
            return this.upgradeTlsAndRemoveSsl(socket);
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket(address, port, localAddress, localPort);
            return this.upgradeTlsAndRemoveSsl(socket);
        }

        private SSLSocket upgradeTlsAndRemoveSsl(SSLSocket socket) {
            Object[] newEnabledProtocols;
            Object[] supportedProtocols = socket.getSupportedProtocols();
            Object[] enabledProtocols = socket.getEnabledProtocols();
            if (Arrays.binarySearch(supportedProtocols, "TLSv1.2") >= 0) {
                newEnabledProtocols = new String[]{"TLSv1.2"};
            } else {
                int sslEnabled = Arrays.binarySearch(enabledProtocols, "SSLv3");
                if (sslEnabled >= 0) {
                    newEnabledProtocols = new String[enabledProtocols.length - 1];
                    System.arraycopy(enabledProtocols, 0, newEnabledProtocols, 0, sslEnabled);
                    if (newEnabledProtocols.length > sslEnabled) {
                        System.arraycopy(enabledProtocols, sslEnabled + 1, newEnabledProtocols, sslEnabled, newEnabledProtocols.length - sslEnabled);
                    }
                } else {
                    newEnabledProtocols = enabledProtocols;
                }
            }
            socket.setEnabledProtocols((String[])newEnabledProtocols);
            return socket;
        }
    }
}

