/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.milestones;

import org.osmdroid.util.Distance;
import org.osmdroid.views.overlay.milestones.MilestoneLister;
import org.osmdroid.views.overlay.milestones.MilestoneStep;

public class MilestoneMeterDistanceLister
extends MilestoneLister {
    private final double mNbMetersRecurrence;
    private double mDistance;
    private int mIndex;
    private final double[] mMilestoneMeters;
    private int mMilestoneMetersIndex;
    private double mNeededForNext;
    private boolean mSideEffectLastFlag;
    private double mSideEffectLastEpsilon = 1.0E-5;
    private long mSideEffectLastX;
    private long mSideEffectLastY;
    private double mSideEffectLastOrientation;

    public MilestoneMeterDistanceLister(double pNbMetersRecurrence) {
        this.mNbMetersRecurrence = pNbMetersRecurrence;
        this.mMilestoneMeters = null;
    }

    public MilestoneMeterDistanceLister(double[] pMilestoneMeters) {
        this.mNbMetersRecurrence = 0.0;
        this.mMilestoneMeters = pMilestoneMeters;
    }

    @Override
    public void init() {
        super.init();
        this.mDistance = 0.0;
        this.mIndex = 0;
        if (this.mMilestoneMeters != null) {
            this.mMilestoneMetersIndex = 0;
        }
        this.mNeededForNext = this.getNewNeededForNext();
        this.mSideEffectLastFlag = false;
    }

    @Override
    protected void add(long x0, long y0, long x1, long y1) {
        double currentDistance;
        this.mSideEffectLastFlag = false;
        if (this.mNeededForNext == -1.0) {
            return;
        }
        if ((currentDistance = this.getDistance(++this.mIndex)) == 0.0) {
            return;
        }
        double pixelDistance = Math.sqrt(Distance.getSquaredDistanceToPoint(x0, y0, x1, y1));
        double metersToPixels = pixelDistance / currentDistance;
        double orientation = MilestoneMeterDistanceLister.getOrientation(x0, y0, x1, y1);
        double x = x0;
        double y = y0;
        do {
            if (currentDistance < this.mNeededForNext) {
                this.mDistance += currentDistance;
                this.mNeededForNext -= currentDistance;
                this.mSideEffectLastFlag = true;
                this.mSideEffectLastX = x1;
                this.mSideEffectLastY = y1;
                this.mSideEffectLastOrientation = orientation;
                return;
            }
            this.mDistance += this.mNeededForNext;
            currentDistance -= this.mNeededForNext;
            this.add((long)(x += this.mNeededForNext * Math.cos(Math.PI / 180 * orientation) * metersToPixels), (long)(y += this.mNeededForNext * Math.sin(Math.PI / 180 * orientation) * metersToPixels), orientation);
            this.mNeededForNext = this.getNewNeededForNext();
        } while (this.mNeededForNext != -1.0);
    }

    private double getNewNeededForNext() {
        double needed;
        if (this.mMilestoneMeters == null) {
            return this.mNbMetersRecurrence;
        }
        if (this.mMilestoneMetersIndex >= this.mMilestoneMeters.length) {
            return -1.0;
        }
        double before = this.mMilestoneMetersIndex == 0 ? 0.0 : this.mMilestoneMeters[this.mMilestoneMetersIndex - 1];
        if ((needed = this.mMilestoneMeters[this.mMilestoneMetersIndex++] - before) < 0.0) {
            throw new IllegalArgumentException();
        }
        return needed;
    }

    @Override
    public void end() {
        if (this.mSideEffectLastFlag && this.mNeededForNext < this.mSideEffectLastEpsilon) {
            this.add(this.mSideEffectLastX, this.mSideEffectLastY, this.mSideEffectLastOrientation);
        }
        super.end();
    }

    public void setSideEffectLastEpsilon(double pSideEffectLastEpsilon) {
        this.mSideEffectLastEpsilon = pSideEffectLastEpsilon;
    }

    private void add(long pX, long pY, double pOrientation) {
        this.add(new MilestoneStep(pX, pY, pOrientation, this.mDistance));
    }
}

