/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Region;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.LinearRing;
import org.osmdroid.views.overlay.PolyOverlayWithIW;

public class Polygon
extends PolyOverlayWithIW {
    protected OnClickListener mOnClickListener;

    public Polygon() {
        this((MapView)null);
    }

    public Polygon(MapView mapView) {
        super(mapView, true, true);
        this.mFillPaint = new Paint();
        this.mFillPaint.setColor(0);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mOutlinePaint.setColor(-16777216);
        this.mOutlinePaint.setStrokeWidth(10.0f);
        this.mOutlinePaint.setStyle(Paint.Style.STROKE);
        this.mOutlinePaint.setAntiAlias(true);
    }

    @Deprecated
    public int getFillColor() {
        return this.mFillPaint.getColor();
    }

    @Deprecated
    public int getStrokeColor() {
        return this.mOutlinePaint.getColor();
    }

    @Deprecated
    public float getStrokeWidth() {
        return this.mOutlinePaint.getStrokeWidth();
    }

    @Override
    public Paint getFillPaint() {
        return super.getFillPaint();
    }

    public List<GeoPoint> getPoints() {
        return this.mOutline.getPoints();
    }

    @Deprecated
    public void setFillColor(int fillColor) {
        this.mFillPaint.setColor(fillColor);
    }

    @Deprecated
    public void setStrokeColor(int color) {
        this.mOutlinePaint.setColor(color);
    }

    @Deprecated
    public void setStrokeWidth(float width) {
        this.mOutlinePaint.setStrokeWidth(width);
    }

    public void setPoints(List<GeoPoint> points) {
        this.mOutline.setPoints(points);
        this.setDefaultInfoWindowLocation();
        this.mBounds = BoundingBox.fromGeoPointsSafe(points);
    }

    public void addPoint(GeoPoint p) {
        this.mOutline.addPoint(p);
    }

    public void setHoles(List<? extends List<GeoPoint>> holes) {
        this.mHoles = new ArrayList(holes.size());
        for (List<GeoPoint> list : holes) {
            LinearRing newHole = new LinearRing(this.mPath);
            newHole.setGeodesic(this.mOutline.isGeodesic());
            newHole.setPoints(list);
            this.mHoles.add(newHole);
        }
    }

    public List<List<GeoPoint>> getHoles() {
        ArrayList<List<GeoPoint>> result = new ArrayList<List<GeoPoint>>(this.mHoles.size());
        for (LinearRing hole : this.mHoles) {
            result.add(hole.getPoints());
        }
        return result;
    }

    public static ArrayList<GeoPoint> pointsAsCircle(GeoPoint center, double radiusInMeters) {
        ArrayList<GeoPoint> circlePoints = new ArrayList<GeoPoint>(60);
        for (int f = 0; f < 360; f += 6) {
            GeoPoint onCircle = center.destinationPoint(radiusInMeters, f);
            circlePoints.add(onCircle);
        }
        return circlePoints;
    }

    public static ArrayList<IGeoPoint> pointsAsRect(BoundingBox rectangle) {
        ArrayList<IGeoPoint> points = new ArrayList<IGeoPoint>(4);
        points.add(new GeoPoint(rectangle.getLatNorth(), rectangle.getLonWest()));
        points.add(new GeoPoint(rectangle.getLatNorth(), rectangle.getLonEast()));
        points.add(new GeoPoint(rectangle.getLatSouth(), rectangle.getLonEast()));
        points.add(new GeoPoint(rectangle.getLatSouth(), rectangle.getLonWest()));
        return points;
    }

    public static ArrayList<IGeoPoint> pointsAsRect(GeoPoint center, double lengthInMeters, double widthInMeters) {
        ArrayList<IGeoPoint> points = new ArrayList<IGeoPoint>(4);
        GeoPoint east = center.destinationPoint(lengthInMeters * 0.5, 90.0);
        GeoPoint south = center.destinationPoint(widthInMeters * 0.5, 180.0);
        double westLon = center.getLongitude() * 2.0 - east.getLongitude();
        double northLat = center.getLatitude() * 2.0 - south.getLatitude();
        points.add(new GeoPoint(south.getLatitude(), east.getLongitude()));
        points.add(new GeoPoint(south.getLatitude(), westLon));
        points.add(new GeoPoint(northLat, westLon));
        points.add(new GeoPoint(northLat, east.getLongitude()));
        return points;
    }

    public boolean contains(MotionEvent event) {
        if (this.mPath.isEmpty()) {
            return false;
        }
        RectF bounds = new RectF();
        this.mPath.computeBounds(bounds, true);
        Region region = new Region();
        region.setPath(this.mPath, new Region((int)bounds.left, (int)bounds.top, (int)bounds.right, (int)bounds.bottom));
        return region.contains((int)event.getX(), (int)event.getY());
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        Projection pj = mapView.getProjection();
        GeoPoint eventPos = (GeoPoint)pj.fromPixels((int)event.getX(), (int)event.getY());
        boolean tapped = this.contains(event);
        if (tapped) {
            if (this.mOnClickListener == null) {
                return this.onClickDefault(this, mapView, eventPos);
            }
            return this.mOnClickListener.onClick(this, mapView, eventPos);
        }
        return tapped;
    }

    @Override
    public void onDetach(MapView mapView) {
        super.onDetach(mapView);
        this.mOnClickListener = null;
    }

    public boolean onClickDefault(Polygon polygon, MapView mapView, GeoPoint eventPos) {
        polygon.setInfoWindowLocation(eventPos);
        polygon.showInfoWindow();
        return true;
    }

    public void setOnClickListener(OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    public static interface OnClickListener {
        public boolean onClick(Polygon var1, MapView var2, GeoPoint var3);
    }
}

