/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import org.osmdroid.tileprovider.BitmapPool;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.RectL;
import org.osmdroid.views.MapView;
import org.osmdroid.views.MapViewRepository;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.OverlayWithIW;
import org.osmdroid.views.overlay.infowindow.MarkerInfoWindow;

public class Marker
extends OverlayWithIW {
    protected int mTextLabelBackgroundColor = -1;
    protected int mTextLabelForegroundColor = -16777216;
    protected int mTextLabelFontSize = 24;
    protected Drawable mIcon;
    protected GeoPoint mPosition;
    protected float mBearing;
    protected float mAnchorU;
    protected float mAnchorV;
    protected float mIWAnchorU;
    protected float mIWAnchorV;
    protected float mAlpha;
    protected boolean mDraggable;
    protected boolean mIsDragged;
    protected boolean mFlat;
    protected OnMarkerClickListener mOnMarkerClickListener;
    protected OnMarkerDragListener mOnMarkerDragListener;
    protected Drawable mImage;
    protected boolean mPanToView;
    protected float mDragOffsetY;
    protected Point mPositionPixels;
    protected Resources mResources;
    private MapViewRepository mMapViewRepository;
    public static final float ANCHOR_CENTER = 0.5f;
    public static final float ANCHOR_LEFT = 0.0f;
    public static final float ANCHOR_TOP = 0.0f;
    public static final float ANCHOR_RIGHT = 1.0f;
    public static final float ANCHOR_BOTTOM = 1.0f;
    private boolean mDisplayed;
    private final Rect mRect = new Rect();
    private final Rect mOrientedMarkerRect = new Rect();
    private Paint mPaint;

    public Marker(MapView mapView) {
        this(mapView, mapView.getContext());
    }

    public Marker(MapView mapView, Context resourceProxy) {
        this.mMapViewRepository = mapView.getRepository();
        this.mResources = mapView.getContext().getResources();
        this.mBearing = 0.0f;
        this.mAlpha = 1.0f;
        this.mPosition = new GeoPoint(0.0, 0.0);
        this.mAnchorU = 0.5f;
        this.mAnchorV = 0.5f;
        this.mIWAnchorU = 0.5f;
        this.mIWAnchorV = 0.0f;
        this.mDraggable = false;
        this.mIsDragged = false;
        this.mPositionPixels = new Point();
        this.mPanToView = true;
        this.mDragOffsetY = 0.0f;
        this.mFlat = false;
        this.mOnMarkerClickListener = null;
        this.mOnMarkerDragListener = null;
        this.setDefaultIcon();
        this.setInfoWindow(this.mMapViewRepository.getDefaultMarkerInfoWindow());
    }

    public void setIcon(Drawable icon) {
        if (icon != null) {
            this.mIcon = icon;
        } else {
            this.setDefaultIcon();
        }
    }

    public void setDefaultIcon() {
        this.mIcon = this.mMapViewRepository.getDefaultMarkerIcon();
        this.setAnchor(0.5f, 1.0f);
    }

    public void setTextIcon(String pText) {
        Paint background = new Paint();
        background.setColor(this.mTextLabelBackgroundColor);
        Paint p = new Paint();
        p.setTextSize((float)this.mTextLabelFontSize);
        p.setColor(this.mTextLabelForegroundColor);
        p.setAntiAlias(true);
        p.setTypeface(Typeface.DEFAULT_BOLD);
        p.setTextAlign(Paint.Align.LEFT);
        int width = (int)(p.measureText(pText) + 0.5f);
        float baseline = (int)(-p.ascent() + 0.5f);
        int height = (int)(baseline + p.descent() + 0.5f);
        Bitmap image = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(image);
        c.drawPaint(background);
        c.drawText(pText, 0.0f, baseline, p);
        this.mIcon = new BitmapDrawable(this.mResources, image);
        this.setAnchor(0.5f, 0.5f);
    }

    public Drawable getIcon() {
        return this.mIcon;
    }

    public GeoPoint getPosition() {
        return this.mPosition;
    }

    public void setPosition(GeoPoint position) {
        this.mPosition = position.clone();
        if (this.isInfoWindowShown()) {
            this.closeInfoWindow();
            this.showInfoWindow();
        }
        this.mBounds = new BoundingBox(position.getLatitude(), position.getLongitude(), position.getLatitude(), position.getLongitude());
    }

    public float getRotation() {
        return this.mBearing;
    }

    public void setRotation(float rotation) {
        this.mBearing = rotation;
    }

    public void setAnchor(float anchorU, float anchorV) {
        this.mAnchorU = anchorU;
        this.mAnchorV = anchorV;
    }

    public void setInfoWindowAnchor(float anchorU, float anchorV) {
        this.mIWAnchorU = anchorU;
        this.mIWAnchorV = anchorV;
    }

    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public void setDraggable(boolean draggable) {
        this.mDraggable = draggable;
    }

    public boolean isDraggable() {
        return this.mDraggable;
    }

    public void setFlat(boolean flat) {
        this.mFlat = flat;
    }

    public boolean isFlat() {
        return this.mFlat;
    }

    public void remove(MapView mapView) {
        mapView.getOverlays().remove(this);
    }

    public void setOnMarkerClickListener(OnMarkerClickListener listener) {
        this.mOnMarkerClickListener = listener;
    }

    public void setOnMarkerDragListener(OnMarkerDragListener listener) {
        this.mOnMarkerDragListener = listener;
    }

    public void setImage(Drawable image) {
        this.mImage = image;
    }

    public Drawable getImage() {
        return this.mImage;
    }

    public void setDragOffset(float mmUp) {
        this.mDragOffsetY = mmUp;
    }

    public float getDragOffset() {
        return this.mDragOffsetY;
    }

    public void setInfoWindow(MarkerInfoWindow infoWindow) {
        this.mInfoWindow = infoWindow;
    }

    public void setPanToView(boolean panToView) {
        this.mPanToView = panToView;
    }

    public void showInfoWindow() {
        if (this.mInfoWindow == null) {
            return;
        }
        int markerWidth = this.mIcon.getIntrinsicWidth();
        int markerHeight = this.mIcon.getIntrinsicHeight();
        int offsetX = (int)((float)markerWidth * (this.mIWAnchorU - this.mAnchorU));
        int offsetY = (int)((float)markerHeight * (this.mIWAnchorV - this.mAnchorV));
        if (this.mBearing == 0.0f) {
            this.mInfoWindow.open(this, this.mPosition, offsetX, offsetY);
            return;
        }
        boolean centerX = false;
        boolean centerY = false;
        double radians = (double)(-this.mBearing) * Math.PI / 180.0;
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        int rotatedX = (int)RectL.getRotatedX(offsetX, offsetY, 0L, 0L, cos, sin);
        int rotatedY = (int)RectL.getRotatedY(offsetX, offsetY, 0L, 0L, cos, sin);
        this.mInfoWindow.open(this, this.mPosition, rotatedX, rotatedY);
    }

    public boolean isInfoWindowShown() {
        if (this.mInfoWindow instanceof MarkerInfoWindow) {
            MarkerInfoWindow iw = (MarkerInfoWindow)this.mInfoWindow;
            return iw != null && iw.isOpen() && iw.getMarkerReference() == this;
        }
        return super.isInfoWindowOpen();
    }

    @Override
    public void draw(Canvas canvas, Projection pj) {
        if (this.mIcon == null) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        pj.toPixels(this.mPosition, this.mPositionPixels);
        float rotationOnScreen = this.mFlat ? -this.mBearing : -pj.getOrientation() - this.mBearing;
        this.drawAt(canvas, this.mPositionPixels.x, this.mPositionPixels.y, rotationOnScreen);
        if (this.isInfoWindowShown()) {
            this.mInfoWindow.draw();
        }
    }

    @Override
    public void onDetach(MapView mapView) {
        BitmapPool.getInstance().asyncRecycle(this.mIcon);
        this.mIcon = null;
        BitmapPool.getInstance().asyncRecycle(this.mImage);
        this.mOnMarkerClickListener = null;
        this.mOnMarkerDragListener = null;
        this.mResources = null;
        this.setRelatedObject(null);
        if (this.isInfoWindowShown()) {
            this.closeInfoWindow();
        }
        this.mMapViewRepository = null;
        this.setInfoWindow(null);
        this.onDestroy();
        super.onDetach(mapView);
    }

    @Deprecated
    public static void cleanDefaults() {
    }

    public boolean hitTest(MotionEvent event, MapView mapView) {
        return this.mIcon != null && this.mDisplayed && this.mOrientedMarkerRect.contains((int)event.getX(), (int)event.getY());
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        boolean touched = this.hitTest(event, mapView);
        if (touched) {
            if (this.mOnMarkerClickListener == null) {
                return this.onMarkerClickDefault(this, mapView);
            }
            return this.mOnMarkerClickListener.onMarkerClick(this, mapView);
        }
        return touched;
    }

    public void moveToEventPosition(MotionEvent event, MapView mapView) {
        float offsetY = TypedValue.applyDimension((int)5, (float)this.mDragOffsetY, (DisplayMetrics)mapView.getContext().getResources().getDisplayMetrics());
        Projection pj = mapView.getProjection();
        this.mPosition = (GeoPoint)pj.fromPixels((int)event.getX(), (int)(event.getY() - offsetY));
        mapView.invalidate();
    }

    @Override
    public boolean onLongPress(MotionEvent event, MapView mapView) {
        boolean touched = this.hitTest(event, mapView);
        if (touched && this.mDraggable) {
            this.mIsDragged = true;
            this.closeInfoWindow();
            if (this.mOnMarkerDragListener != null) {
                this.mOnMarkerDragListener.onMarkerDragStart(this);
            }
            this.moveToEventPosition(event, mapView);
        }
        return touched;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        if (this.mDraggable && this.mIsDragged) {
            if (event.getAction() == 1) {
                this.mIsDragged = false;
                if (this.mOnMarkerDragListener != null) {
                    this.mOnMarkerDragListener.onMarkerDragEnd(this);
                }
                return true;
            }
            if (event.getAction() == 2) {
                this.moveToEventPosition(event, mapView);
                if (this.mOnMarkerDragListener != null) {
                    this.mOnMarkerDragListener.onMarkerDrag(this);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setAlpha(1.0f);
        } else {
            this.setAlpha(0.0f);
        }
    }

    protected boolean onMarkerClickDefault(Marker marker, MapView mapView) {
        marker.showInfoWindow();
        if (marker.mPanToView) {
            mapView.getController().animateTo(marker.getPosition());
        }
        return true;
    }

    public int getTextLabelBackgroundColor() {
        return this.mTextLabelBackgroundColor;
    }

    public void setTextLabelBackgroundColor(int mTextLabelBackgroundColor) {
        this.mTextLabelBackgroundColor = mTextLabelBackgroundColor;
    }

    public int getTextLabelForegroundColor() {
        return this.mTextLabelForegroundColor;
    }

    public void setTextLabelForegroundColor(int mTextLabelForegroundColor) {
        this.mTextLabelForegroundColor = mTextLabelForegroundColor;
    }

    public int getTextLabelFontSize() {
        return this.mTextLabelFontSize;
    }

    public void setTextLabelFontSize(int mTextLabelFontSize) {
        this.mTextLabelFontSize = mTextLabelFontSize;
    }

    public boolean isDisplayed() {
        return this.mDisplayed;
    }

    protected void drawAt(Canvas pCanvas, int pX, int pY, float pOrientation) {
        int markerWidth = this.mIcon.getIntrinsicWidth();
        int markerHeight = this.mIcon.getIntrinsicHeight();
        int offsetX = pX - Math.round((float)markerWidth * this.mAnchorU);
        int offsetY = pY - Math.round((float)markerHeight * this.mAnchorV);
        this.mRect.set(offsetX, offsetY, offsetX + markerWidth, offsetY + markerHeight);
        RectL.getBounds(this.mRect, pX, pY, (double)pOrientation, this.mOrientedMarkerRect);
        this.mDisplayed = Rect.intersects((Rect)this.mOrientedMarkerRect, (Rect)pCanvas.getClipBounds());
        if (!this.mDisplayed) {
            return;
        }
        if (this.mAlpha == 0.0f) {
            return;
        }
        if (pOrientation != 0.0f) {
            pCanvas.save();
            pCanvas.rotate(pOrientation, (float)pX, (float)pY);
        }
        if (this.mIcon instanceof BitmapDrawable) {
            Paint paint;
            if (this.mAlpha == 1.0f) {
                paint = null;
            } else {
                if (this.mPaint == null) {
                    this.mPaint = new Paint();
                }
                this.mPaint.setAlpha((int)(this.mAlpha * 255.0f));
                paint = this.mPaint;
            }
            pCanvas.drawBitmap(((BitmapDrawable)this.mIcon).getBitmap(), (float)offsetX, (float)offsetY, paint);
        } else {
            this.mIcon.setAlpha((int)(this.mAlpha * 255.0f));
            this.mIcon.setBounds(this.mRect);
            this.mIcon.draw(pCanvas);
        }
        if (pOrientation != 0.0f) {
            pCanvas.restore();
        }
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);

        public void onMarkerDragStart(Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1, MapView var2);
    }
}

