/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import android.graphics.Point;
import android.graphics.Rect;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.MyMath;
import org.osmdroid.util.PointL;
import org.osmdroid.util.RectL;

public abstract class TileSystem {
    @Deprecated
    public static final double EarthRadius = 6378137.0;
    @Deprecated
    public static final double MinLatitude = -85.05112877980659;
    @Deprecated
    public static final double MaxLatitude = 85.05112877980659;
    @Deprecated
    public static final double MinLongitude = -180.0;
    @Deprecated
    public static final double MaxLongitude = 180.0;
    private static int mTileSize = 256;
    public static final int primaryKeyMaxZoomLevel = 29;
    public static final int projectionZoomLevel = 30;
    private static int mMaxZoomLevel = 29;

    public static void setTileSize(int tileSize) {
        int pow2 = (int)(0.5 + Math.log(tileSize) / Math.log(2.0));
        mMaxZoomLevel = Math.min(29, 63 - pow2 - 1);
        mTileSize = tileSize;
    }

    public static int getTileSize() {
        return mTileSize;
    }

    public static int getMaximumZoomLevel() {
        return mMaxZoomLevel;
    }

    public static double getTileSize(double pZoomLevel) {
        return TileSystem.MapSize(pZoomLevel - (double)TileSystem.getInputTileZoomLevel(pZoomLevel));
    }

    public static int getInputTileZoomLevel(double pZoomLevel) {
        return MyMath.floorToInt(pZoomLevel);
    }

    @Deprecated
    public static int MapSize(int levelOfDetail) {
        return (int)Math.round(TileSystem.MapSize((double)levelOfDetail));
    }

    public static double MapSize(double pZoomLevel) {
        return (double)TileSystem.getTileSize() * TileSystem.getFactor(pZoomLevel);
    }

    public static double getFactor(double pZoomLevel) {
        return Math.pow(2.0, pZoomLevel);
    }

    public static double GroundResolution(double latitude, int levelOfDetail) {
        return TileSystem.GroundResolution(latitude, (double)levelOfDetail);
    }

    public static double GroundResolution(double latitude, double zoomLevel) {
        return TileSystem.GroundResolutionMapSize(TileSystem.wrap(latitude, -90.0, 90.0, 180.0), TileSystem.MapSize(zoomLevel));
    }

    public static double GroundResolutionMapSize(double latitude, double mapSize) {
        latitude = TileSystem.Clip(latitude, -90.0, 90.0);
        return Math.cos(latitude * Math.PI / 180.0) * 2.0 * Math.PI * 6378137.0 / mapSize;
    }

    public static double MapScale(double latitude, int levelOfDetail, int screenDpi) {
        return TileSystem.GroundResolution(latitude, levelOfDetail) * (double)screenDpi / 0.0254;
    }

    @Deprecated
    public Point LatLongToPixelXY(double latitude, double longitude, int levelOfDetail, Point reuse) {
        Point out = reuse == null ? new Point() : reuse;
        int size = TileSystem.MapSize(levelOfDetail);
        out.x = TileSystem.truncateToInt(this.getMercatorXFromLongitude(longitude, size, true));
        out.y = TileSystem.truncateToInt(this.getMercatorYFromLatitude(latitude, size, true));
        return out;
    }

    @Deprecated
    public PointL LatLongToPixelXY(double latitude, double longitude, double zoomLevel, PointL reuse) {
        return this.LatLongToPixelXYMapSize(TileSystem.wrap(latitude, -90.0, 90.0, 180.0), TileSystem.wrap(longitude, -180.0, 180.0, 360.0), TileSystem.MapSize(zoomLevel), reuse);
    }

    @Deprecated
    public PointL LatLongToPixelXYMapSize(double latitude, double longitude, double mapSize, PointL reuse) {
        return this.getMercatorFromGeo(latitude, longitude, mapSize, reuse, true);
    }

    @Deprecated
    public GeoPoint PixelXYToLatLong(int pixelX, int pixelY, int levelOfDetail, GeoPoint reuse) {
        return this.getGeoFromMercator(pixelX, pixelY, TileSystem.MapSize(levelOfDetail), reuse, true, true);
    }

    @Deprecated
    public GeoPoint PixelXYToLatLong(int pixelX, int pixelY, double zoomLevel, GeoPoint reuse) {
        return this.getGeoFromMercator(pixelX, pixelY, TileSystem.MapSize(zoomLevel), reuse, true, true);
    }

    public GeoPoint PixelXYToLatLongWithoutWrap(int pixelX, int pixelY, double zoomLevel, GeoPoint reuse) {
        double mapSize = TileSystem.MapSize(zoomLevel);
        return this.PixelXYToLatLongMapSizeWithoutWrap(pixelX, pixelY, mapSize, reuse);
    }

    public double getX01FromLongitude(double longitude, boolean wrapEnabled) {
        longitude = wrapEnabled ? TileSystem.Clip(longitude, this.getMinLongitude(), this.getMaxLongitude()) : longitude;
        double result = this.getX01FromLongitude(longitude);
        return wrapEnabled ? TileSystem.Clip(result, 0.0, 1.0) : result;
    }

    public double getY01FromLatitude(double latitude, boolean wrapEnabled) {
        latitude = wrapEnabled ? TileSystem.Clip(latitude, this.getMinLatitude(), this.getMaxLatitude()) : latitude;
        double result = this.getY01FromLatitude(latitude);
        return wrapEnabled ? TileSystem.Clip(result, 0.0, 1.0) : result;
    }

    public abstract double getX01FromLongitude(double var1);

    public abstract double getY01FromLatitude(double var1);

    @Deprecated
    public GeoPoint PixelXYToLatLongMapSize(int pixelX, int pixelY, double mapSize, GeoPoint reuse, boolean horizontalWrapEnabled, boolean verticalWrapEnabled) {
        return this.getGeoFromMercator(pixelX, pixelY, mapSize, reuse, horizontalWrapEnabled, verticalWrapEnabled);
    }

    public GeoPoint PixelXYToLatLongMapSizeWithoutWrap(int pixelX, int pixelY, double mapSize, GeoPoint reuse) {
        GeoPoint out = reuse == null ? new GeoPoint(0.0, 0.0) : reuse;
        double x = (double)pixelX / mapSize - 0.5;
        double y = 0.5 - (double)pixelY / mapSize;
        double latitude = 90.0 - 360.0 * Math.atan(Math.exp(-y * 2.0 * Math.PI)) / Math.PI;
        double longitude = 360.0 * x;
        out.setLatitude(latitude);
        out.setLongitude(longitude);
        return out;
    }

    public static double Clip(double n, double minValue, double maxValue) {
        return Math.min(Math.max(n, minValue), maxValue);
    }

    @Deprecated
    public Point PixelXYToTileXY(int pixelX, int pixelY, Point reuse) {
        return this.PixelXYToTileXY(pixelX, pixelY, TileSystem.getTileSize(), reuse);
    }

    @Deprecated
    public Point PixelXYToTileXY(int pPixelX, int pPixelY, double pTileSize, Point pReuse) {
        Point out = pReuse == null ? new Point() : pReuse;
        out.x = TileSystem.getTileFromMercator(pPixelX, pTileSize);
        out.y = TileSystem.getTileFromMercator(pPixelY, pTileSize);
        return out;
    }

    @Deprecated
    public Rect PixelXYToTileXY(Rect rect, double pTileSize, Rect pReuse) {
        Rect out = pReuse == null ? new Rect() : pReuse;
        out.left = TileSystem.getTileFromMercator(rect.left, pTileSize);
        out.top = TileSystem.getTileFromMercator(rect.top, pTileSize);
        out.right = TileSystem.getTileFromMercator(rect.right, pTileSize);
        out.bottom = TileSystem.getTileFromMercator(rect.bottom, pTileSize);
        return out;
    }

    @Deprecated
    public Point TileXYToPixelXY(int tileX, int tileY, Point reuse) {
        Point out = reuse == null ? new Point() : reuse;
        int size = TileSystem.getTileSize();
        out.x = TileSystem.truncateToInt(TileSystem.getMercatorFromTile(tileX, size));
        out.y = TileSystem.truncateToInt(TileSystem.getMercatorFromTile(tileY, size));
        return out;
    }

    @Deprecated
    public PointL TileXYToPixelXY(int pTileX, int pTileY, double pTileSize, PointL pReuse) {
        PointL out = pReuse == null ? new PointL() : pReuse;
        out.x = TileSystem.getMercatorFromTile(pTileX, pTileSize);
        out.y = TileSystem.getMercatorFromTile(pTileY, pTileSize);
        return out;
    }

    public static String TileXYToQuadKey(int tileX, int tileY, int levelOfDetail) {
        char[] quadKey = new char[levelOfDetail];
        for (int i = 0; i < levelOfDetail; ++i) {
            int digit = 48;
            int mask = 1 << i;
            if ((tileX & mask) != 0) {
                digit = (char)(digit + 1);
            }
            if ((tileY & mask) != 0) {
                digit = (char)(digit + 1);
                digit = (char)(digit + 1);
            }
            quadKey[levelOfDetail - i - 1] = digit;
        }
        return new String(quadKey);
    }

    public static Point QuadKeyToTileXY(String quadKey, Point reuse) {
        Point out;
        Point point = out = reuse == null ? new Point() : reuse;
        if (quadKey == null || quadKey.length() == 0) {
            throw new IllegalArgumentException("Invalid QuadKey: " + quadKey);
        }
        int tileX = 0;
        int tileY = 0;
        int zoom = quadKey.length();
        block6: for (int i = 0; i < zoom; ++i) {
            int value = 1 << i;
            switch (quadKey.charAt(zoom - i - 1)) {
                case '0': {
                    continue block6;
                }
                case '1': {
                    tileX += value;
                    continue block6;
                }
                case '2': {
                    tileY += value;
                    continue block6;
                }
                case '3': {
                    tileX += value;
                    tileY += value;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Invalid QuadKey: " + quadKey);
                }
            }
        }
        out.x = tileX;
        out.y = tileY;
        return out;
    }

    public double getBoundingBoxZoom(BoundingBox pBoundingBox, int pScreenWidth, int pScreenHeight) {
        double longitudeZoom = this.getLongitudeZoom(pBoundingBox.getLonEast(), pBoundingBox.getLonWest(), pScreenWidth);
        double latitudeZoom = this.getLatitudeZoom(pBoundingBox.getLatNorth(), pBoundingBox.getLatSouth(), pScreenHeight);
        if (longitudeZoom == Double.MIN_VALUE) {
            return latitudeZoom;
        }
        if (latitudeZoom == Double.MIN_VALUE) {
            return longitudeZoom;
        }
        return Math.min(latitudeZoom, longitudeZoom);
    }

    public double getLongitudeZoom(double pEast, double pWest, int pScreenWidth) {
        double x01West = this.getX01FromLongitude(pWest, true);
        double x01East = this.getX01FromLongitude(pEast, true);
        double span = x01East - x01West;
        if (span < 0.0) {
            span += 1.0;
        }
        if (span == 0.0) {
            return Double.MIN_VALUE;
        }
        return Math.log((double)pScreenWidth / span / (double)TileSystem.getTileSize()) / Math.log(2.0);
    }

    public double getLatitudeZoom(double pNorth, double pSouth, int pScreenHeight) {
        double y01North = this.getY01FromLatitude(pNorth, true);
        double y01South = this.getY01FromLatitude(pSouth, true);
        double span = y01South - y01North;
        if (span <= 0.0) {
            return Double.MIN_VALUE;
        }
        return Math.log((double)pScreenHeight / span / (double)TileSystem.getTileSize()) / Math.log(2.0);
    }

    private static double wrap(double n, double minValue, double maxValue, double interval) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue must be smaller than maxValue: " + minValue + ">" + maxValue);
        }
        if (interval > maxValue - minValue + 1.0) {
            throw new IllegalArgumentException("interval must be equal or smaller than maxValue-minValue: min: " + minValue + " max:" + maxValue + " int:" + interval);
        }
        while (n < minValue) {
            n += interval;
        }
        while (n > maxValue) {
            n -= interval;
        }
        return n;
    }

    public long getMercatorYFromLatitude(double pLatitude, double pMapSize, boolean wrapEnabled) {
        return this.getMercatorFromXY01(this.getY01FromLatitude(pLatitude, wrapEnabled), pMapSize, wrapEnabled);
    }

    public long getMercatorXFromLongitude(double pLongitude, double pMapSize, boolean wrapEnabled) {
        return this.getMercatorFromXY01(this.getX01FromLongitude(pLongitude, wrapEnabled), pMapSize, wrapEnabled);
    }

    public long getMercatorFromXY01(double pXY01, double pMapSize, boolean wrapEnabled) {
        return TileSystem.ClipToLong(pXY01 * pMapSize, pMapSize, wrapEnabled);
    }

    public double getLatitudeFromY01(double pY01, boolean wrapEnabled) {
        double latitude = this.getLatitudeFromY01(wrapEnabled ? TileSystem.Clip(pY01, 0.0, 1.0) : pY01);
        return wrapEnabled ? TileSystem.Clip(latitude, this.getMinLatitude(), this.getMaxLatitude()) : latitude;
    }

    public abstract double getLatitudeFromY01(double var1);

    public double getLongitudeFromX01(double pX01, boolean wrapEnabled) {
        double longitude = this.getLongitudeFromX01(wrapEnabled ? TileSystem.Clip(pX01, 0.0, 1.0) : pX01);
        return wrapEnabled ? TileSystem.Clip(longitude, this.getMinLongitude(), this.getMaxLongitude()) : longitude;
    }

    public abstract double getLongitudeFromX01(double var1);

    public long getCleanMercator(long pMercator, double pMercatorMapSize, boolean wrapEnabled) {
        return TileSystem.ClipToLong(wrapEnabled ? TileSystem.wrap(pMercator, 0.0, pMercatorMapSize, pMercatorMapSize) : (double)pMercator, pMercatorMapSize, wrapEnabled);
    }

    public static long ClipToLong(double pValue, double pMax, boolean pWrapEnabled) {
        long longValue = MyMath.floorToLong(pValue);
        if (!pWrapEnabled) {
            return longValue;
        }
        if (longValue <= 0L) {
            return 0L;
        }
        long longMax = MyMath.floorToLong(pMax - 1.0);
        return (double)longValue >= pMax ? longMax : longValue;
    }

    @Deprecated
    public static long Clip(long n, long minValue, long maxValue) {
        return Math.min(Math.max(n, minValue), maxValue);
    }

    public static int truncateToInt(long value) {
        return (int)Math.max(Math.min(value, Integer.MAX_VALUE), Integer.MIN_VALUE);
    }

    public PointL getMercatorFromGeo(double pLatitude, double pLongitude, double pMapSize, PointL pReuse, boolean wrapEnabled) {
        PointL out = pReuse == null ? new PointL() : pReuse;
        out.x = this.getMercatorXFromLongitude(pLongitude, pMapSize, wrapEnabled);
        out.y = this.getMercatorYFromLatitude(pLatitude, pMapSize, wrapEnabled);
        return out;
    }

    public GeoPoint getGeoFromMercator(long pMercatorX, long pMercatorY, double pMapSize, GeoPoint pReuse, boolean horizontalWrapEnabled, boolean verticalWrapEnabled) {
        GeoPoint out = pReuse == null ? new GeoPoint(0.0, 0.0) : pReuse;
        out.setLatitude(this.getLatitudeFromY01(this.getXY01FromMercator(pMercatorY, pMapSize, verticalWrapEnabled), verticalWrapEnabled));
        out.setLongitude(this.getLongitudeFromX01(this.getXY01FromMercator(pMercatorX, pMapSize, horizontalWrapEnabled), horizontalWrapEnabled));
        return out;
    }

    public double getXY01FromMercator(long pMercator, double pMapSize, boolean wrapEnabled) {
        return wrapEnabled ? TileSystem.Clip((double)pMercator / pMapSize, 0.0, 1.0) : (double)pMercator / pMapSize;
    }

    public double getRandomLongitude(double pRandom01) {
        return pRandom01 * (this.getMaxLongitude() - this.getMinLongitude()) + this.getMinLongitude();
    }

    public double getRandomLatitude(double pRandom01, double pMinLatitude) {
        return pRandom01 * (this.getMaxLatitude() - pMinLatitude) + pMinLatitude;
    }

    public double getRandomLatitude(double pRandom01) {
        return this.getRandomLatitude(pRandom01, this.getMinLatitude());
    }

    public static int getTileFromMercator(long pMercator, double pTileSize) {
        return MyMath.floorToInt((double)pMercator / pTileSize);
    }

    public static Rect getTileFromMercator(RectL pMercatorRect, double pTileSize, Rect pReuse) {
        Rect out = pReuse == null ? new Rect() : pReuse;
        out.left = TileSystem.getTileFromMercator(pMercatorRect.left, pTileSize);
        out.top = TileSystem.getTileFromMercator(pMercatorRect.top, pTileSize);
        out.right = TileSystem.getTileFromMercator(pMercatorRect.right, pTileSize);
        out.bottom = TileSystem.getTileFromMercator(pMercatorRect.bottom, pTileSize);
        return out;
    }

    public static long getMercatorFromTile(int pTile, double pTileSize) {
        return Math.round((double)pTile * pTileSize);
    }

    public abstract double getMinLatitude();

    public abstract double getMaxLatitude();

    public abstract double getMinLongitude();

    public abstract double getMaxLongitude();

    public double cleanLongitude(double pLongitude) {
        double result;
        for (result = pLongitude; result < -180.0; result += 360.0) {
        }
        while (result > 180.0) {
            result -= 360.0;
        }
        return TileSystem.Clip(result, this.getMinLongitude(), this.getMaxLongitude());
    }

    public double cleanLatitude(double pLatitude) {
        return TileSystem.Clip(pLatitude, this.getMinLatitude(), this.getMaxLatitude());
    }

    public boolean isValidLongitude(double pLongitude) {
        return pLongitude >= this.getMinLongitude() && pLongitude <= this.getMaxLongitude();
    }

    public boolean isValidLatitude(double pLatitude) {
        return pLatitude >= this.getMinLatitude() && pLatitude <= this.getMaxLatitude();
    }

    public String toStringLongitudeSpan() {
        return "[" + this.getMinLongitude() + "," + this.getMaxLongitude() + "]";
    }

    public String toStringLatitudeSpan() {
        return "[" + this.getMinLatitude() + "," + this.getMaxLatitude() + "]";
    }

    public int getTileXFromLongitude(double pLongitude, int pZoom) {
        return this.clipTile((int)Math.floor(this.getX01FromLongitude(pLongitude) * (double)(1 << pZoom)), pZoom);
    }

    public int getTileYFromLatitude(double pLatitude, int pZoom) {
        return this.clipTile((int)Math.floor(this.getY01FromLatitude(pLatitude) * (double)(1 << pZoom)), pZoom);
    }

    public double getLatitudeFromTileY(int pY, int pZoom) {
        return this.getLatitudeFromY01((double)this.clipTile(pY, pZoom) / (double)(1 << pZoom));
    }

    public double getLongitudeFromTileX(int pX, int pZoom) {
        return this.getLongitudeFromX01((double)this.clipTile(pX, pZoom) / (double)(1 << pZoom));
    }

    private int clipTile(int pTile, int pZoom) {
        if (pTile < 0) {
            return 0;
        }
        int max = 1 << pZoom;
        if (pTile >= max) {
            return max - 1;
        }
        return pTile;
    }
}

