/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.PointL;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.LineDrawer;
import org.osmdroid.views.overlay.LinearRing;
import org.osmdroid.views.overlay.OverlayWithIW;
import org.osmdroid.views.overlay.infowindow.InfoWindow;
import org.osmdroid.views.overlay.milestones.MilestoneManager;

public abstract class PolyOverlayWithIW
extends OverlayWithIW {
    protected LinearRing mOutline;
    protected List<LinearRing> mHoles = new ArrayList<LinearRing>();
    protected final Paint mOutlinePaint = new Paint();
    protected Paint mFillPaint;
    private List<MilestoneManager> mMilestoneManagers = new ArrayList<MilestoneManager>();
    private GeoPoint mInfoWindowLocation;
    private final LineDrawer mLineDrawer;
    protected final Path mPath;
    protected float mDensity = 1.0f;
    protected List<GeoPoint> mOriginalPoints = new ArrayList<GeoPoint>();

    protected PolyOverlayWithIW(MapView pMapView, boolean pUsePath, boolean pClosePath) {
        if (pMapView != null) {
            this.setInfoWindow(pMapView.getRepository().getDefaultPolylineInfoWindow());
            this.mDensity = pMapView.getContext().getResources().getDisplayMetrics().density;
        }
        if (pUsePath) {
            this.mPath = new Path();
            this.mLineDrawer = null;
            this.mOutline = new LinearRing(this.mPath, pClosePath);
        } else {
            this.mPath = null;
            this.mLineDrawer = new LineDrawer(256);
            this.mOutline = new LinearRing(this.mLineDrawer);
            this.mLineDrawer.setPaint(this.mOutlinePaint);
        }
    }

    public void setVisible(boolean visible) {
        this.setEnabled(visible);
    }

    public boolean isVisible() {
        return this.isEnabled();
    }

    public Paint getOutlinePaint() {
        return this.mOutlinePaint;
    }

    protected Paint getFillPaint() {
        return this.mFillPaint;
    }

    public void setGeodesic(boolean geodesic) {
        this.mOutline.setGeodesic(geodesic);
    }

    public boolean isGeodesic() {
        return this.mOutline.isGeodesic();
    }

    @Override
    public void setInfoWindow(InfoWindow infoWindow) {
        if (this.mInfoWindow != null && this.mInfoWindow.getRelatedObject() == this) {
            this.mInfoWindow.setRelatedObject(null);
        }
        this.mInfoWindow = infoWindow;
    }

    public void showInfoWindow() {
        if (this.mInfoWindow != null && this.mInfoWindowLocation != null) {
            this.mInfoWindow.open(this, this.mInfoWindowLocation, 0, 0);
        }
    }

    public void setInfoWindowLocation(GeoPoint location) {
        this.mInfoWindowLocation = location;
    }

    public GeoPoint getInfoWindowLocation() {
        return this.mInfoWindowLocation;
    }

    public void setMilestoneManagers(List<MilestoneManager> pMilestoneManagers) {
        if (pMilestoneManagers == null) {
            if (this.mMilestoneManagers.size() > 0) {
                this.mMilestoneManagers.clear();
            }
        } else {
            this.mMilestoneManagers = pMilestoneManagers;
        }
    }

    public double getDistance() {
        return this.mOutline.getDistance();
    }

    protected void setDefaultInfoWindowLocation() {
        int s = this.mOutline.getPoints().size();
        if (s == 0) {
            this.mInfoWindowLocation = new GeoPoint(0.0, 0.0);
            return;
        }
        this.mInfoWindowLocation = this.mOutline.getCenter(null);
    }

    @Override
    public void draw(Canvas pCanvas, Projection pProjection) {
        if (this.mPath != null) {
            this.drawWithPath(pCanvas, pProjection);
        } else {
            this.drawWithLines(pCanvas, pProjection);
        }
    }

    private void drawWithPath(Canvas pCanvas, Projection pProjection) {
        this.mPath.rewind();
        this.mOutline.setClipArea(pProjection);
        PointL offset = this.mOutline.buildPathPortion(pProjection, null, this.mMilestoneManagers.size() > 0);
        for (MilestoneManager milestoneManager : this.mMilestoneManagers) {
            milestoneManager.init();
            milestoneManager.setDistances(this.mOutline.getDistances());
            for (PointL point : this.mOutline.getPointsForMilestones()) {
                milestoneManager.add(point.x, point.y);
            }
            milestoneManager.end();
        }
        if (this.mHoles != null) {
            for (LinearRing hole : this.mHoles) {
                hole.setClipArea(pProjection);
                hole.buildPathPortion(pProjection, offset, this.mMilestoneManagers.size() > 0);
            }
            this.mPath.setFillType(Path.FillType.EVEN_ODD);
        }
        if (this.mFillPaint != null) {
            pCanvas.drawPath(this.mPath, this.mFillPaint);
        }
        pCanvas.drawPath(this.mPath, this.mOutlinePaint);
        for (MilestoneManager milestoneManager : this.mMilestoneManagers) {
            milestoneManager.draw(pCanvas);
        }
        if (this.isInfoWindowOpen() && this.mInfoWindow != null && this.mInfoWindow.getRelatedObject() == this) {
            this.mInfoWindow.draw();
        }
    }

    private void drawWithLines(Canvas pCanvas, Projection pProjection) {
        this.mLineDrawer.setCanvas(pCanvas);
        this.mOutline.setClipArea(pProjection);
        this.mOutline.buildLinePortion(pProjection, this.mMilestoneManagers.size() > 0);
        for (MilestoneManager milestoneManager : this.mMilestoneManagers) {
            milestoneManager.init();
            milestoneManager.setDistances(this.mOutline.getDistances());
            for (PointL point : this.mOutline.getPointsForMilestones()) {
                milestoneManager.add(point.x, point.y);
            }
            milestoneManager.end();
        }
        for (MilestoneManager milestoneManager : this.mMilestoneManagers) {
            milestoneManager.draw(pCanvas);
        }
        if (this.isInfoWindowOpen() && this.mInfoWindow != null && this.mInfoWindow.getRelatedObject() == this) {
            this.mInfoWindow.draw();
        }
    }

    @Override
    public void onDetach(MapView mapView) {
        this.mOutline = null;
        this.mHoles.clear();
        this.mMilestoneManagers.clear();
        this.mOriginalPoints = null;
        this.onDestroy();
    }
}

