/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.Overlay;

public class IconOverlay
extends Overlay {
    public static final float ANCHOR_CENTER = 0.5f;
    public static final float ANCHOR_LEFT = 0.0f;
    public static final float ANCHOR_TOP = 0.0f;
    public static final float ANCHOR_RIGHT = 1.0f;
    public static final float ANCHOR_BOTTOM = 1.0f;
    protected Drawable mIcon = null;
    protected IGeoPoint mPosition = null;
    protected float mBearing = 0.0f;
    protected float mAnchorU = 0.5f;
    protected float mAnchorV = 0.5f;
    protected float mAlpha = 1.0f;
    protected boolean mFlat = false;
    protected Point mPositionPixels = new Point();

    public IconOverlay() {
    }

    public IconOverlay(IGeoPoint position, Drawable icon) {
        this.set(position, icon);
    }

    @Override
    public void draw(Canvas canvas, Projection pj) {
        if (this.mIcon == null) {
            return;
        }
        if (this.mPosition == null) {
            return;
        }
        pj.toPixels(this.mPosition, this.mPositionPixels);
        int width = this.mIcon.getIntrinsicWidth();
        int height = this.mIcon.getIntrinsicHeight();
        Rect rect = new Rect(0, 0, width, height);
        rect.offset(-((int)(this.mAnchorU * (float)width)), -((int)(this.mAnchorV * (float)height)));
        this.mIcon.setBounds(rect);
        this.mIcon.setAlpha((int)(this.mAlpha * 255.0f));
        float rotationOnScreen = this.mFlat ? -this.mBearing : pj.getOrientation() - this.mBearing;
        IconOverlay.drawAt(canvas, this.mIcon, this.mPositionPixels.x, this.mPositionPixels.y, false, rotationOnScreen);
    }

    public IGeoPoint getPosition() {
        return this.mPosition;
    }

    public IconOverlay set(IGeoPoint position, Drawable icon) {
        this.mPosition = position;
        this.mIcon = icon;
        return this;
    }

    public IconOverlay moveTo(MotionEvent event, MapView mapView) {
        Projection pj = mapView.getProjection();
        this.moveTo(pj.fromPixels((int)event.getX(), (int)event.getY()), mapView);
        return this;
    }

    public IconOverlay moveTo(IGeoPoint position, MapView mapView) {
        this.mPosition = position;
        mapView.invalidate();
        return this;
    }
}

