/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.BitmapPool;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.IMapTileProviderCallback;
import org.osmdroid.tileprovider.MapTileCache;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.ReusableBitmapDrawable;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.modules.MapTileApproximater;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.util.MapTileIndex;
import org.osmdroid.util.PointL;
import org.osmdroid.util.RectL;
import org.osmdroid.util.TileLooper;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.Projection;

public abstract class MapTileProviderBase
implements IMapTileProviderCallback {
    public static final int MAPTILE_SUCCESS_ID = 0;
    public static final int MAPTILE_FAIL_ID = 1;
    private static int sApproximationBackgroundColor = -3355444;
    protected final MapTileCache mTileCache;
    private final Collection<Handler> mTileRequestCompleteHandlers = new LinkedHashSet<Handler>();
    protected boolean mUseDataConnection = true;
    protected Drawable mTileNotFoundImage = null;
    private ITileSource mTileSource;

    public abstract Drawable getMapTile(long var1);

    public void detach() {
        this.clearTileCache();
        if (this.mTileNotFoundImage != null) {
            Bitmap bitmap;
            if (Build.VERSION.SDK_INT < 9 && this.mTileNotFoundImage instanceof BitmapDrawable && (bitmap = ((BitmapDrawable)this.mTileNotFoundImage).getBitmap()) != null) {
                bitmap.recycle();
            }
            if (this.mTileNotFoundImage instanceof ReusableBitmapDrawable) {
                BitmapPool.getInstance().returnDrawableToPool((ReusableBitmapDrawable)this.mTileNotFoundImage);
            }
        }
        this.mTileNotFoundImage = null;
        this.clearTileCache();
    }

    public static void setApproximationBackgroundColor(int pColor) {
        sApproximationBackgroundColor = pColor;
    }

    public abstract int getMinimumZoomLevel();

    public abstract int getMaximumZoomLevel();

    public void setTileSource(ITileSource pTileSource) {
        this.mTileSource = pTileSource;
        this.clearTileCache();
    }

    public ITileSource getTileSource() {
        return this.mTileSource;
    }

    public MapTileCache createTileCache() {
        return new MapTileCache();
    }

    public MapTileProviderBase(ITileSource pTileSource) {
        this(pTileSource, null);
    }

    public MapTileProviderBase(ITileSource pTileSource, Handler pDownloadFinishedListener) {
        this.mTileCache = this.createTileCache();
        this.mTileRequestCompleteHandlers.add(pDownloadFinishedListener);
        this.mTileSource = pTileSource;
    }

    public void setTileLoadFailureImage(Drawable drawable) {
        this.mTileNotFoundImage = drawable;
    }

    @Override
    public void mapTileRequestCompleted(MapTileRequestState pState, Drawable pDrawable) {
        this.putTileIntoCache(pState.getMapTile(), pDrawable, -1);
        this.sendMessage(0);
        if (Configuration.getInstance().isDebugTileProviders()) {
            Log.d((String)"OsmDroid", (String)("MapTileProviderBase.mapTileRequestCompleted(): " + MapTileIndex.toString(pState.getMapTile())));
        }
    }

    @Override
    public void mapTileRequestFailed(MapTileRequestState pState) {
        if (this.mTileNotFoundImage != null) {
            this.putTileIntoCache(pState.getMapTile(), this.mTileNotFoundImage, -4);
            this.sendMessage(0);
        } else {
            this.sendMessage(1);
        }
        if (Configuration.getInstance().isDebugTileProviders()) {
            Log.d((String)"OsmDroid", (String)("MapTileProviderBase.mapTileRequestFailed(): " + MapTileIndex.toString(pState.getMapTile())));
        }
    }

    @Override
    public void mapTileRequestFailedExceedsMaxQueueSize(MapTileRequestState pState) {
        this.mapTileRequestFailed(pState);
    }

    @Override
    public void mapTileRequestExpiredTile(MapTileRequestState pState, Drawable pDrawable) {
        this.putTileIntoCache(pState.getMapTile(), pDrawable, ExpirableBitmapDrawable.getState(pDrawable));
        this.sendMessage(0);
        if (Configuration.getInstance().isDebugTileProviders()) {
            Log.d((String)"OsmDroid", (String)("MapTileProviderBase.mapTileRequestExpiredTile(): " + MapTileIndex.toString(pState.getMapTile())));
        }
    }

    protected void putTileIntoCache(long pMapTileIndex, Drawable pDrawable, int pState) {
        int stateBefore;
        if (pDrawable == null) {
            return;
        }
        Drawable before = this.mTileCache.getMapTile(pMapTileIndex);
        if (before != null && (stateBefore = ExpirableBitmapDrawable.getState(before)) > pState) {
            return;
        }
        ExpirableBitmapDrawable.setState(pDrawable, pState);
        this.mTileCache.putTile(pMapTileIndex, pDrawable);
    }

    @Deprecated
    protected void putExpiredTileIntoCache(MapTileRequestState pState, Drawable pDrawable) {
        this.putTileIntoCache(pState.getMapTile(), pDrawable, -2);
    }

    @Deprecated
    public void setTileRequestCompleteHandler(Handler handler) {
        this.mTileRequestCompleteHandlers.clear();
        this.mTileRequestCompleteHandlers.add(handler);
    }

    public Collection<Handler> getTileRequestCompleteHandlers() {
        return this.mTileRequestCompleteHandlers;
    }

    public void ensureCapacity(int pCapacity) {
        this.mTileCache.ensureCapacity(pCapacity);
    }

    public MapTileCache getTileCache() {
        return this.mTileCache;
    }

    public void clearTileCache() {
        this.mTileCache.clear();
    }

    @Override
    public boolean useDataConnection() {
        return this.mUseDataConnection;
    }

    public void setUseDataConnection(boolean pMode) {
        this.mUseDataConnection = pMode;
    }

    public void rescaleCache(Projection pProjection, double pNewZoomLevel, double pOldZoomLevel, Rect pViewPort) {
        if (TileSystem.getInputTileZoomLevel(pNewZoomLevel) == TileSystem.getInputTileZoomLevel(pOldZoomLevel)) {
            return;
        }
        long startMs = System.currentTimeMillis();
        if (Configuration.getInstance().isDebugTileProviders()) {
            Log.i((String)"OsmDroid", (String)("rescale tile cache from " + pOldZoomLevel + " to " + pNewZoomLevel));
        }
        PointL topLeftMercator = pProjection.toMercatorPixels(pViewPort.left, pViewPort.top, null);
        PointL bottomRightMercator = pProjection.toMercatorPixels(pViewPort.right, pViewPort.bottom, null);
        RectL viewPortMercator = new RectL(topLeftMercator.x, topLeftMercator.y, bottomRightMercator.x, bottomRightMercator.y);
        ScaleTileLooper tileLooper = pNewZoomLevel > pOldZoomLevel ? new ZoomInTileLooper() : new ZoomOutTileLooper();
        tileLooper.loop(pNewZoomLevel, viewPortMercator, pOldZoomLevel, this.getTileSource().getTileSizePixels());
        long endMs = System.currentTimeMillis();
        if (Configuration.getInstance().isDebugTileProviders()) {
            Log.i((String)"OsmDroid", (String)("Finished rescale in " + (endMs - startMs) + "ms"));
        }
    }

    public abstract IFilesystemCache getTileWriter();

    public abstract long getQueueSize();

    public void expireInMemoryCache(long pMapTileIndex) {
        Drawable drawable = this.mTileCache.getMapTile(pMapTileIndex);
        if (drawable != null) {
            ExpirableBitmapDrawable.setState(drawable, -2);
        }
    }

    private void sendMessage(int pMessageId) {
        for (int attempt = 0; attempt < 3; ++attempt) {
            if (!this.sendMessageFailFast(pMessageId)) continue;
            return;
        }
    }

    private boolean sendMessageFailFast(int pMessageId) {
        Iterator<Handler> iterator = this.mTileRequestCompleteHandlers.iterator();
        while (iterator.hasNext()) {
            Handler handler;
            try {
                handler = iterator.next();
            }
            catch (ConcurrentModificationException cme) {
                return false;
            }
            if (handler == null) continue;
            handler.sendEmptyMessage(pMessageId);
        }
        return true;
    }

    private class ZoomInTileLooper
    extends ScaleTileLooper {
        private ZoomInTileLooper() {
        }

        @Override
        public void computeTile(long pMapTileIndex, int pX, int pY) {
            Bitmap bitmap;
            long oldTile = MapTileIndex.getTileIndex(this.mOldTileZoomLevel, MapTileIndex.getX(pMapTileIndex) >> this.mDiff, MapTileIndex.getY(pMapTileIndex) >> this.mDiff);
            Drawable oldDrawable = MapTileProviderBase.this.mTileCache.getMapTile(oldTile);
            if (oldDrawable instanceof BitmapDrawable && (bitmap = MapTileApproximater.approximateTileFromLowerZoom((BitmapDrawable)oldDrawable, pMapTileIndex, this.mDiff)) != null) {
                this.mNewTiles.put(pMapTileIndex, bitmap);
            }
        }
    }

    private class ZoomOutTileLooper
    extends ScaleTileLooper {
        private static final int MAX_ZOOM_OUT_DIFF = 4;

        private ZoomOutTileLooper() {
        }

        @Override
        protected void computeTile(long pMapTileIndex, int pX, int pY) {
            if (this.mDiff >= 4) {
                return;
            }
            int xx = MapTileIndex.getX(pMapTileIndex) << this.mDiff;
            int yy = MapTileIndex.getY(pMapTileIndex) << this.mDiff;
            int numTiles = 1 << this.mDiff;
            Bitmap bitmap = null;
            Canvas canvas = null;
            for (int x = 0; x < numTiles; ++x) {
                for (int y = 0; y < numTiles; ++y) {
                    Bitmap oldBitmap;
                    long oldTile = MapTileIndex.getTileIndex(this.mOldTileZoomLevel, xx + x, yy + y);
                    Drawable oldDrawable = MapTileProviderBase.this.mTileCache.getMapTile(oldTile);
                    if (!(oldDrawable instanceof BitmapDrawable) || (oldBitmap = ((BitmapDrawable)oldDrawable).getBitmap()) == null) continue;
                    if (bitmap == null) {
                        bitmap = MapTileApproximater.getTileBitmap(this.mTileSize);
                        canvas = new Canvas(bitmap);
                        canvas.drawColor(sApproximationBackgroundColor);
                    }
                    this.mDestRect.set(x * this.mTileSize_2, y * this.mTileSize_2, (x + 1) * this.mTileSize_2, (y + 1) * this.mTileSize_2);
                    canvas.drawBitmap(oldBitmap, null, this.mDestRect, null);
                }
            }
            if (bitmap != null) {
                this.mNewTiles.put(pMapTileIndex, bitmap);
            }
        }
    }

    private abstract class ScaleTileLooper
    extends TileLooper {
        protected final HashMap<Long, Bitmap> mNewTiles = new HashMap();
        protected int mOldTileZoomLevel;
        protected int mTileSize;
        protected int mDiff;
        protected int mTileSize_2;
        protected Rect mSrcRect;
        protected Rect mDestRect;
        protected Paint mDebugPaint;
        private boolean isWorth;

        private ScaleTileLooper() {
        }

        public void loop(double pZoomLevel, RectL pViewPortMercator, double pOldZoomLevel, int pTileSize) {
            this.mSrcRect = new Rect();
            this.mDestRect = new Rect();
            this.mDebugPaint = new Paint();
            this.mOldTileZoomLevel = TileSystem.getInputTileZoomLevel(pOldZoomLevel);
            this.mTileSize = pTileSize;
            this.loop(pZoomLevel, pViewPortMercator);
        }

        @Override
        public void initialiseLoop() {
            super.initialiseLoop();
            this.mDiff = Math.abs(this.mTileZoomLevel - this.mOldTileZoomLevel);
            this.mTileSize_2 = this.mTileSize >> this.mDiff;
            this.isWorth = this.mDiff != 0;
        }

        @Override
        public void handleTile(long pMapTileIndex, int pX, int pY) {
            if (!this.isWorth) {
                return;
            }
            Drawable requestedTile = MapTileProviderBase.this.getMapTile(pMapTileIndex);
            if (requestedTile == null) {
                try {
                    this.computeTile(pMapTileIndex, pX, pY);
                }
                catch (OutOfMemoryError e) {
                    Log.e((String)"OsmDroid", (String)"OutOfMemoryError rescaling cache");
                }
            }
        }

        @Override
        public void finaliseLoop() {
            while (!this.mNewTiles.isEmpty()) {
                long index = this.mNewTiles.keySet().iterator().next();
                Bitmap bitmap = this.mNewTiles.remove(index);
                this.putScaledTileIntoCache(index, bitmap);
            }
        }

        protected abstract void computeTile(long var1, int var3, int var4);

        protected void putScaledTileIntoCache(long pMapTileIndex, Bitmap pBitmap) {
            ReusableBitmapDrawable drawable = new ReusableBitmapDrawable(pBitmap);
            MapTileProviderBase.this.putTileIntoCache(pMapTileIndex, (Drawable)drawable, -3);
            if (Configuration.getInstance().isDebugMode()) {
                Log.d((String)"OsmDroid", (String)("Created scaled tile: " + MapTileIndex.toString(pMapTileIndex)));
                this.mDebugPaint.setTextSize(40.0f);
                Canvas canvas = new Canvas(pBitmap);
                canvas.drawText("scaled", 50.0f, 50.0f, this.mDebugPaint);
            }
        }
    }
}

